/* -- niksm --
Критерий отбора СМБ - выполнение 1 из условий (или/или):
   1) 3 "месяца" подряд доставки не ниже К1 штук (по дефолту 2)
   2) за "месяц" доставки не ниже К2 штук (по дефолту 5)
Рассчитывается минимальная дата, когда клиент (user_phone_pd_id) проходит по критерию СМБ. С этого момента и навечно все его доставки относятся к Тир 4.
*/

drop table if exists niksm_temp_b2b_tier4_user_datefrom_raw;
create temporary table niksm_temp_b2b_tier4_user_datefrom_raw AS
select user_phone_pd_id,
       msk_order_created_dt as calday,
       sum(delivery_point_cnt) as dlv_cnt
from taxi_cdm_marketplace.fct_order
  join snb_taxi.logdata_logistic_tariffs lgst
    on lgst.order_tariff = fct_order.tariff_class_code
where true
  and utc_order_created_dttm >= timestamp'2020-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and success_order_flg
  and not corp_order_flg
  and user_phone_pd_id is not null
group by user_phone_pd_id,
         msk_order_created_dt;

-- drop table if exists snb_delivery.niksm_b2b_tier4_user_datefrom;
-- create table snb_delivery.niksm_b2b_tier4_user_datefrom as
truncate table snb_delivery.niksm_b2b_tier4_user_datefrom;
insert into snb_delivery.niksm_b2b_tier4_user_datefrom (user_phone_pd_id, datefrom)
WITH t0 as (
    select user_phone_pd_id,
           calday,
           dlv_cnt,
           coalesce(sum(dlv_cnt) over (partition by user_phone_pd_id order by calday range between 28*1-1 preceding and current row),0) as dlv_cnt_lag1,
           coalesce(sum(dlv_cnt) over (partition by user_phone_pd_id order by calday range between 28*2-1 preceding and 28*1 preceding),0) as dlv_cnt_lag2,
           coalesce(sum(dlv_cnt) over (partition by user_phone_pd_id order by calday range between 28*3-1 preceding and 28*2 preceding),0) as dlv_cnt_lag3
    from niksm_temp_b2b_tier4_user_datefrom_raw raw
)
select user_phone_pd_id,
       min(calday)::date as datefrom
from t0
where least(dlv_cnt_lag1, dlv_cnt_lag2, dlv_cnt_lag3) >= 2  -- К1
   or dlv_cnt_lag1 >= 5                                     -- К2
group by user_phone_pd_id
-- distributed by (user_phone_pd_id)
;

-- alter table snb_delivery.niksm_b2b_tier4_user_datefrom add constraint niksm_b2b_tier4_user_datefrom_pk primary key (user_phone_pd_id);
-- grant all on snb_delivery.niksm_b2b_tier4_user_datefrom to "robot-sam-bridges";
-- comment on table snb_delivery.niksm_b2b_tier4_user_datefrom is 'Дата (moscow_order_dt), с которой клиент считается СМБ (Тир 4)';
