drop table if exists temp_niksm_contract_manager;
create temporary table temp_niksm_contract_manager as
select contract_id,
       lk.lk_client_id as corp_client_id,
       manager_metagroup, manager_group, lead_name, manager_name, manager_login,
       case when
           manager_group <> 'B2B платформа'
           then 'Delivery' else 'Taxi' end as contract_crm,
       market_segment
from (
    select contract_id,
           manager_metagroup, manager_group,
           lead_name, manager_name, manager_login,
           market_segment,
           row_number() over (partition by contract_id order by src) as rn
    from (
        select contract_id,
               manager_metagroup,
               manager_group,
               teamlead_name as lead_name,
               manager_name, manager_login,
               market_segment,
               1 as src
        from snb_b2b.amo_contracts_info
        union all
        select contract_id,
               'Израиль' as manager_metagroup,
               manager_group, lead_name, manager_name, manager_login,
               market_segment,
               2 as src
        from snb_b2b.niksm_b2b_contracts_info_sf
    ) crm0
) crm
  left join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = crm.contract_id
where rn = 1;

-- drop table if exists snb_delivery.niksm_contract_manager;
-- create table snb_delivery.niksm_contract_manager as            -- !! DISTRIBUTED BY
truncate table snb_delivery.niksm_contract_manager;
insert into snb_delivery.niksm_contract_manager
    (contract_id, corp_client_id, manager_metagroup, manager_group, lead_name, manager_name, manager_login, contract_crm, market_segment)
--
select contract_id, corp_client_id, manager_metagroup, manager_group, lead_name, manager_name, manager_login, contract_crm, market_segment
from temp_niksm_contract_manager
-- DISTRIBUTED BY (contract_id)
;
-- alter table snb_delivery.niksm_contract_manager add constraint niksm_contract_manager_pk primary key (contract_id);
-- grant all on snb_delivery.niksm_contract_manager to "robot-sam-bridges", "robot-corploader";
-- comment on table snb_delivery.niksm_contract_manager is 'Тир (группа менеджеров), тимлид и менеджер для номера контракта. Ключ - contract_id';
