-- Ищем ключ в snb_b2b.voytekh_pd2_deal_field
select *
from snb_b2b.voytekh_pd2_deal_field
where which_crm = 6
  and lower(name) like '%ndd%'
order by name, which_crm;

-- Цель - грамотно добавить ключ в niksm_b2b_deal_field
select *
from snb_b2b.niksm_b2b_deal_field
order by attribute_name, which_crm;

--Проверка заполненности: какой % в voytekh_pd2_deal_history содержит заполненное поле
with keys as (
    select which_crm, key, name
    from snb_b2b.voytekh_pd2_deal_field
    where true
      and which_crm = 6
      and lower(name) like '%ndd%'
)
select o.which_crm,
       name,
       sum(case when (o.custom_fields ->> keys.key) is not null then 1. else 0. end) as cnt,
       round(sum(case when (o.custom_fields ->> keys.key) is not null then 1. else 0. end) / count() * 100,2) || '%' as prc
from snb_b2b.voytekh_pd2_deal_history as o
  join keys
    on o.which_crm = keys.which_crm
where true
  and record_date = current_date
--   and o.which_crm = 8
group by o.which_crm,
         name
;

-- Проверка значений поля в voytekh_pd2_deal_history
with keys as (
    select which_crm, key, name
    from snb_b2b.voytekh_pd2_deal_field
    where true
      and which_crm = 6
      and lower(name) like '%ndd%'
)
select o.which_crm,
       keys.name,
--        id,
       custom_fields ->> keys.key as new_field
       , count() as cnt
from snb_b2b.voytekh_pd2_deal_history as o
  join keys
    on o.which_crm = keys.which_crm
where true
  and record_date = current_date
--   and o.which_crm = 0
  and (custom_fields ->> keys.key) is not null
group by 1,2,3
-- limit 50
;

--====================================================================================================================--
-- Добавляем ключи в niksm_b2b_deal_field

-- Вариант №1 - VALUES
insert into snb_b2b.niksm_b2b_deal_field (attribute_name, which_crm, key, with_dict, array_flg)
values ('Market segment', 5, '60d803d64af12b5fe955671511fe816f81b5fb8d', true, false);

-- Вариант №2 - из voytekh_pd2_deal_field
insert into snb_b2b.niksm_b2b_deal_field (attribute_name, which_crm, key, with_dict, array_flg)
select name as attribute_name,
       which_crm,
       key,
       true as with_dict,
       false as array_flg
from snb_b2b.voytekh_pd2_deal_field
where true
  and which_crm = 6
  and lower(name) like '%ndd%'
  and not name = 'Потенциал объемов NDD'
order by attribute_name, which_crm;

--====================================================================================================================--

alter table snb_b2b.niksm_b2b_deals_info
    add ndd_potential integer,
    add ndd_pipeline_stage text,
    add ndd_integration_status text;

grant all on snb_b2b.niksm_b2b_deal_field to "robot-sam-bridges", "robot-corploader";

-- сделки
SELECT id,
       custom_fields ->> '3341b9466f34977fc2ec29c1d7afcd8dfa6d8bb9' as "№ договора"
from snb_b2b.voytekh_pd2_deal_history
where which_crm = 8
  and record_date = current_date
  and (custom_fields ->> '3341b9466f34977fc2ec29c1d7afcd8dfa6d8bb9') is not null
limit 100;

-- наименования стадий
select *
from snb_b2b.voytekh_pd_stage
-- where which_crm = 6
order by pd_id;

select * from snb_b2b.voytekh_pd_pipeline;

select * from snb_b2b.niksm_b2b_deals_info limit 10;

------------------------------------------------------------------------------------------------------------------------
-- drop table snb_b2b.niksm_b2b_deal_field;
-- create table snb_b2b.niksm_b2b_deal_field as
select case when name in ('Contract №','№ договора') then '№ договора'
        when name in ('Канал привлечения') then 'Канал привлечения'
        end as attribute_name,
       which_crm,
       key,
       name in ('Канал привлечения') as with_dict
from snb_b2b.voytekh_pd2_deal_field
where true
  and name in ('Contract №','№ договора','Канал привлечения')
order by attribute_name, which_crm;




select * from snb_b2b.niksm_b2b_deal_field;

select which_crm, count() from snb_b2b.niksm_b2b_deals_info
where record_date <> current_date
group by which_crm
order by which_crm;

------------------------------------------------------------------------------------------------------------------------
select count() from snb_b2b.niksm_b2b_deals_info;
select count() from snb_b2b.voytekh_pd2_deal_history where record_date = current_date;
select * from snb_b2b.niksm_b2b_orgs_info where website is not null limit 50;


select *
from snb_taxi.niksm_b2b_deal_field
where attribute_name = 'Теги'
;

select id as deal_id,
       (dlh.custom_fields ->> '337a6c18a796bb71765a6d51467511b75a6fefa1') as tags
from snb_b2b.voytekh_pd2_deal_history as dlh
where which_crm = 6
  and (dlh.custom_fields ->> '337a6c18a796bb71765a6d51467511b75a6fefa1') is not null
  and (dlh.custom_fields ->> '337a6c18a796bb71765a6d51467511b75a6fefa1') like '%,%'
limit 10;

select *
from snb_b2b.niksm_b2b_deals_info
where which_crm = 6
limit 20;
