-- Ищем ключ в snb_b2b.voytekh_pd2_org_field
select *
from snb_b2b.voytekh_pd2_org_field
where true
--   and which_crm = 6
--   and name like 'ИНН%'
order by name, which_crm;

-- Цель - грамотно добавить ключ в niksm_b2b_org_field
select *
from snb_b2b.niksm_b2b_org_field
order by attribute_name, which_crm;

--Проверка заполненности: какой % в voytekh_pd2_org содержит заполненное поле
with keys as (
    select which_crm, key
    from snb_b2b.voytekh_pd2_org_field
    where true
      and which_crm in (6,8)
      and name in ('Кредитный рейтинг','Credit rating')
)
select o.which_crm,
--        id, name,
       sum(case when (o.custom_fields ->> keys.key) is not null then 1. else 0. end) as cnt,
       round(sum(case when (o.custom_fields ->> keys.key) is not null then 1. else 0. end) / count() * 100,2) || '%' as prc
from snb_b2b.voytekh_pd2_org as o
  join keys
    on o.which_crm = keys.which_crm
where true
--   and o.which_crm = 8
group by o.which_crm;

-- Проверка значений поля в voytekh_pd2_org
with keys as (
    select which_crm, key
    from snb_b2b.voytekh_pd2_org_field
    where true
      and which_crm in (6,8)
      and name in ('Кредитный рейтинг','Credit rating')
)
select o.which_crm,
       id,
       name,
       custom_fields ->> keys.key as new_field
from snb_b2b.voytekh_pd2_org as o
  join keys
    on o.which_crm = keys.which_crm
where true
--   and o.which_crm = 0
  and (custom_fields ->> keys.key) is not null
limit 20;

-- Заполненность всех полей в custom_fields
select
--        o.id,
--        o.name,
       f.name,
       sum(case when (o.custom_fields ->> f.key) is not null then 1. else 0. end) as cnt,
       round(sum(case when (o.custom_fields ->> f.key) is not null then 1. else 0. end) / count() * 100,2) || '%' as prc
from snb_b2b.voytekh_pd2_org as o
  join snb_b2b.voytekh_pd2_org_field as f using(which_crm)
where which_crm = 8
group by 1
order by name;

--====================================================================================================================--
-- Добавляем ключи в niksm_b2b_org_field

-- Вариант №1 - VALUES
insert into snb_b2b.niksm_b2b_org_field (attribute_name, which_crm, key, with_dict)
 VALUES (
        'География',
         6,
         'e7480ce35afd1074394d66643d39937cd806187d',
         true
        );

-- Вариант №1 - из voytekh_pd2_org_field
insert into snb_b2b.niksm_b2b_org_field
select 'Кредитный рейтинг' as attribute_name,
       which_crm,
       key,
       true as with_dict,
       false as array_flg
from snb_b2b.voytekh_pd2_org_field
where true
  and which_crm in (6,8)
  and name in ('Кредитный рейтинг','Credit rating')
order by attribute_name, which_crm;

--
select * from snb_b2b.niksm_b2b_org_field order by attribute_name, which_crm;
--====================================================================================================================--

create table snb_b2b.niksm_b2b_org_field
(
    attribute_name varchar(256) not null,
    which_crm      integer      not null,
    key            varchar(128),
    with_dict      boolean,
    array_flg      boolean default false,
    constraint niksm_pd_org_field_pk
        primary key (attribute_name, which_crm)
);
grant all on snb_b2b.niksm_b2b_org_field to "robot-sam-bridges", "robot-corploader";

select 'nik' as src, count() from snb_b2b.niksm_b2b_orgs_info
union all
select 'voytekh' as src, count() from snb_b2b.voytekh_pd2_org;

------------------------------------------------------------------------------------------------------------------------

-- alter table snb_b2b.niksm_b2b_orgs_info add geography_key text;

select * from snb_b2b.niksm_b2b_orgs_info limit 10;

select which_crm,
       count()
       , round(count() filter (where inn is not null)*100./count(),1) || '%'
-- from snb_b2b.niksm_b2b_orgs_info
from snb_b2b.niksm_b2b_deals_info
group by which_crm
order by 1;

select which_crm, count()
from snb_b2b.voytekh_pd2_org
group by which_crm
order by 1;

select inn, array_agg(distinct which_crm order by which_crm) as crms
from snb_b2b.niksm_b2b_orgs_info
where inn is not null
  and inn <> ''
group by 1 order by 1;

select column_name, data_type
from information_schema.columns
where table_name = 'niksm_b2b_orgs_info';
