with tt as (
    select cn_ntrc.org_id
         , max(cn_ntrc.deal_title) as deal_title
         , fctd.order_id
         , sum(fctd.taxi_order_lcy_cost)                         as gmv
         , min(utc_created_dttm)                                 as time_c
         , case when (max(min(utc_created_dttm)) over(partition by cn_ntrc.org_id))=min(utc_created_dttm) then 1 else 0 end next_flg
         , lead(min(utc_created_dttm),1,'2021-10-01'::timestamp)
           over (partition by cn_ntrc.org_id order by min(utc_created_dttm)) as time_lag
         , max(max(case when cn_hst.is_active is not null then 1 else 0 end))  over(partition by cn_ntrc.org_id) as deactiv_contr
         , '2021-10-01'::date- (min(min(utc_created_dttm)) over(partition by cn_ntrc.org_id))::date as cnt_date_deliv

    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
            left join snb_b2b.niksm_b2b_corp_contracts_hist as cn_hst on cn_hst.contract_external_id= cn_ntrc.contract_id
               and cn_hst.snapshot_date='2022-02-14'  and cn_hst.is_active=0
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  --between '2021-01-01' and '2022-02-15'
      --'2021-02-01' and '2021-09-01'
      '2021-03-01' and '2021-10-01'
      --'2021-04-01' and '2021-11-01'
    --and cn_ntrc.org_id  in (43131, 34524)
    group by cn_ntrc.org_id, fctd.order_id
    having sum(fctd.taxi_order_lcy_cost)>0
)

, t12 as (
select org_id, deal_title, gmv, time_lag-time_c as time_delta
       , ceil(count()over (partition by org_id)*0.5) row_qntl_50
       , ceil(count()over (partition by org_id)*0.7) row_qntl_70
       , ceil(count()over (partition by org_id)*0.9) row_qntl_90
       , ceil(count()over (partition by org_id)*0.95) row_qntl_95
       , row_number() over (partition by org_id order by time_lag-time_c) as row_n
       , count()over (partition by org_id) cnt_row
       , ceil(count()over ()*0.5) row_qntl_50_all
       , ceil(count()over ()*0.7) row_qntl_70_all
       , ceil(count()over ()*0.9) row_qntl_90_all
       , ceil(count()over ()*0.95) row_qntl_95_all
       , row_number() over (order by time_lag-time_c) as row_n_all
       , count()over () cnt_row_all
       , sum(gmv) over(partition by org_id order by time_lag-time_c
            rows between UNBOUNDED PRECEDING and CURRENT ROW) gmv_cumul
from tt
where next_flg =0
)
, t2 as (
   select org_id, deal_title, gmv,  time_delta
       ,  row_qntl_50
       ,  row_qntl_70
       ,  row_qntl_90
       ,  row_qntl_95
       ,  row_n
       ,  cnt_row
       ,  ceil((0.9+0.1*(
           coalesce((sum(date_part('day',time_delta)) over(partition by org_id))
                        /nullif((10*sum(case when row_n>=row_qntl_90 then date_part('day',time_delta) else 0 end) over(partition by org_id)),0),1)
               -0.1))*cnt_row) as row_qntl_ext
       ,  row_qntl_50_all
       ,  row_qntl_70_all
       ,  row_qntl_90_all
       ,  row_qntl_95_all
       ,  row_n_all
       ,  cnt_row_all
       ,  ceil((0.9+0.1*(
            coalesce((sum(date_part('day',time_delta)) over())
                        /nullif((10*sum(case when row_n>=row_qntl_90 then date_part('day',time_delta) else 0 end) over()),0),1)
               -0.1))*cnt_row)  as row_qntl_ext_all
       ,  gmv_cumul
    from t12


)
--    select * from   t2
-- where row_qntl_50_all=row_n_all;
, base_qntl as (
select  org_id, max(deal_title) deal_title
       , max(case when row_qntl_50=row_n then date_part('epoch', time_delta)  end) as time_delta_50
       , max(case when row_qntl_70=row_n then date_part('epoch', time_delta)  end) as time_delta_70
       , max(case when row_qntl_90=row_n then date_part('epoch', time_delta)  end) as time_delta_90
       , max(case when row_qntl_95=row_n then date_part('epoch', time_delta)  end) as time_delta_95
       , max(case when row_qntl_ext=row_n then date_part('epoch', time_delta)  end) as time_delta_ext

       , max(case when row_qntl_50=row_n then gmv_cumul  end) as gmv_cumul_50
       , max(case when row_qntl_70=row_n then gmv_cumul  end) as gmv_cumul_70
       , max(case when row_qntl_90=row_n then gmv_cumul  end) as gmv_cumul_90
       , max(case when row_qntl_95=row_n then gmv_cumul  end) as gmv_cumul_95
       , max(case when row_qntl_ext=row_n then gmv_cumul  end) as gmv_cumul_ext
       , max(row_n) cnt_row

       , max(max(case when row_qntl_50_all=row_n_all then date_part('epoch', time_delta)  end)) over() as time_delta_50_all
       , max(max(case when row_qntl_70_all=row_n_all then date_part('epoch', time_delta)  end)) over() as time_delta_70_all
       , max(max(case when row_qntl_90_all=row_n_all then date_part('epoch', time_delta)  end)) over() as time_delta_90_all
       , max(max(case when row_qntl_95_all=row_n_all then date_part('epoch', time_delta)  end)) over() as time_delta_95_all
       , max(max(case when row_qntl_ext_all=row_n_all then date_part('epoch', time_delta)  end)) over() as time_delta_ext_all

from t2
group by  org_id
    )
--   select * from   base_qntl;
    -- поиск в семестве распределений квантилей
, b1 as (
    select time_delta_50, time_delta_70, time_delta_90,time_delta_95, time_delta_ext
         , ceil(count() over () * 0.9) as cnt
         , row_number() over (order by time_delta_50) as row_n_50
         , row_number() over (order by time_delta_70) as row_n_70
         , row_number() over (order by time_delta_90) as row_n_90
         , row_number() over (order by time_delta_95) as row_n_95
         , row_number() over (order by time_delta_ext) as row_n_ext

    from base_qntl
--     where cnt_row >= 5
)
, qntl_apr as (
    select
           max(case when cnt=row_n_50 then time_delta_50  end) as time_delta_50_all
        ,max(case when cnt=row_n_70 then time_delta_70  end) as time_delta_70_all
        ,max(case when cnt=row_n_90 then time_delta_90  end) as time_delta_90_all
        ,max(case when cnt=row_n_95 then time_delta_95  end) as time_delta_95_all
        ,max(case when cnt=row_n_ext then time_delta_ext  end) as time_delta_ext_all
    from b1
)
, fin as (
    select test.org_id
         , test.deal_title
         , test.order_id
         , test.time_c                                                                                            as date_order
         , base_qntl.cnt_row
         , test.deactiv_contr
         , test.cnt_date_deliv
         , date_part('epoch', test.time_lag - test.time_c)                                                        as time_next_order
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_50) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_50_all) over()))                                                   as time_limit_50
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_70) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_70_all) over()))                                                   as time_limit_70
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_90) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_90_all) over()))                                                   as time_limit_90
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_95) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_95_all) over()))                                                   as time_limit_95
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_ext) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_ext_all) over()))                                                 as time_limit_ext

         , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_50) end,
               greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_50_all) over()))                                                   as qntl_50_flg
         , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_70) end,
               greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_70_all) over()))                                             as qntl_70_flg
         , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_90) end,
               greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_90_all) over()))                                                   as qntl_90_flg
         , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_95) end,
               greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_95_all) over()))                                                   as qntl_95_flg

         , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_ext) end,
               greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_ext_all) over()))                                                   as qntl_ext_flg

         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_50) end,
                    greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_50_all) over())) - date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl_50
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_70) end,
                    greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_70_all) over())) - date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl_70
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_90) end,
                    greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_90_all) over())) - date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl_90
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_95) end,
                    greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_95_all) over())) - date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl_95
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_ext) end,
                    greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_ext_all) over())) - date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl_ext
    from tt test
             left join base_qntl on base_qntl.org_id = test.org_id --and base_qntl.cnt_row >= 5
              cross join qntl_apr
    where test.next_flg = 1
)
-- select *
-- from fin;
--
   , chck  as (
    select cn_ntrc.org_id
         , min(utc_created_dttm)                                 as date_control
         , count(distinct fctd.order_id ) as cnt_control_deliv
    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  between --'2021-08-01' and '2021-11-01'
      --'2021-09-01' and '2021-12-01'
      '2021-10-01' and '2022-01-01'
      --'2021-11-01' and '2022-02-01'
      --and fctd.utc_created_dttm not between '2021-12-16' and '2022-01-12'

     -- and cn_ntrc.org_id  in (43131, 34524)
    group by cn_ntrc.org_id
    having sum(fctd.taxi_order_lcy_cost)>0
)

select fin.*, chck.date_control, chck.date_control is not null as client_activ, chck.cnt_control_deliv
     , date_part('epoch', chck.date_control -fin.date_order) as time_control
from fin
left join chck on chck.org_id=fin.org_id
;

-----------------------
-------------------------



with tt as (
    select cn_ntrc.org_id
         , max(cn_ntrc.deal_title) as deal_title
         , fctd.order_id
         , sum(fctd.taxi_order_lcy_cost)                         as gmv
         , min(utc_created_dttm)                                 as time_c
         , case when (max(min(utc_created_dttm)) over(partition by cn_ntrc.org_id))=min(utc_created_dttm) then 1 else 0 end next_flg
         , lead(min(utc_created_dttm),1,'2021-10-01'::timestamp)
           over (partition by cn_ntrc.org_id order by min(utc_created_dttm)) as time_lag
         , max(max(case when cn_hst.is_active is not null then 1 else 0 end))  over(partition by cn_ntrc.org_id) as deactiv_contr
         , '2021-10-01'::date- (min(min(utc_created_dttm)) over(partition by cn_ntrc.org_id))::date as cnt_date_deliv

    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
            left join snb_b2b.niksm_b2b_corp_contracts_hist as cn_hst on cn_hst.contract_external_id= cn_ntrc.contract_id
               and cn_hst.snapshot_date='2021-09-30'  and cn_hst.is_active=0
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  between --'2021-01-01' and '2022-02-15'
      --'2021-02-01' and '2021-09-01'
      '2021-03-01' and '2021-10-01'
      --'2021-04-01' and '2021-11-01'
    --and cn_ntrc.org_id  in (43131, 34524)
    group by cn_ntrc.org_id, fctd.order_id
    having sum(fctd.taxi_order_lcy_cost)>0
)

, t12 as (
select org_id, deal_title, gmv, time_lag-time_c as time_delta
       , row_number() over (partition by org_id order by time_lag-time_c) as row_n
       , row_number() over (order by time_lag-time_c) as row_n_all
       , count()over (partition by org_id) cnt_row
       , count()over () cnt_row_all
       , sum(gmv) over(partition by org_id order by time_lag-time_c
            rows between UNBOUNDED PRECEDING and CURRENT ROW) gmv_cumul
       ,generate_series(50,100,1) as series_qntl
from tt
where next_flg =0
)
, t13 as (
    select org_id
         , deal_title
         , gmv
         , time_delta
         , row_n
         , row_n_all
         , cnt_row
         , cnt_row_all
         , gmv_cumul
         , 'qntl_' || series_qntl                as series_qntl
         , ceil(cnt_row * series_qntl / 100)     as row_qntl
         , ceil(cnt_row_all * series_qntl / 100) as row_all_qntl
    from t12
)
,base_qntl as (
select
         org_id, series_qntl
       , max(deal_title) deal_title
       , max(case when row_qntl=row_n then date_part('epoch', time_delta)  end) as time_delta_qntl
       , max(case when row_qntl=row_n then gmv_cumul  end) as gmv_cumul_qntl
       , max(cnt_row)cnt_row
       , max(cnt_row_all) cnt_row_all
       , max(max(case when row_all_qntl=row_n_all then date_part('epoch', time_delta)  end)) over(partition by series_qntl) as time_delta_all_qntl

from t13
group by  org_id,series_qntl
    )
, b1 as (
    select series_qntl, time_delta_qntl
         , ceil(count() over (partition by series_qntl) * 0.9) as cnt
         , row_number() over (partition by series_qntl order by time_delta_qntl) as row_n_qntl


    from base_qntl
--     where cnt_row >= 5
)
, qntl_apr as (
    select series_qntl,
           max(case when cnt=row_n_qntl then time_delta_qntl  end) as time_delta_all_qntl
    from b1
    group by series_qntl
)

, fin as (
    select test.org_id
         , test.deal_title
         , test.order_id
         , test.time_c                                                                                            as date_order
         , base_qntl.cnt_row
         , test.deactiv_contr
         , test.cnt_date_deliv
         , date_part('epoch', test.time_lag - test.time_c)                                                        as time_next_order
         , qntl_apr.series_qntl

          , coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))                                                   as time_limit_qntl
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl)))  as time_limit_qntl_minday
        , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))                                                   as qntl_flg
        , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl)))    as qntl_flg_minday



         , greatest(
                 coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))- date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))),
                0)                                                                                                as time_to_qntl_minday
    from tt test
             cross join qntl_apr
             left join base_qntl on base_qntl.org_id = test.org_id  and qntl_apr.series_qntl=base_qntl.series_qntl
             --and base_qntl.cnt_row >= 5
    where test.next_flg = 1
)

 , chck  as (
    select cn_ntrc.org_id
         , min(utc_created_dttm)                                 as date_control
         , count(distinct fctd.order_id ) as cnt_control_deliv
    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  between --'2021-08-01' and '2021-11-01'
      --'2021-09-01' and '2021-12-01'
      '2021-10-01' and '2022-01-01'
      --'2021-11-01' and '2022-02-01'
      --and fctd.utc_created_dttm not between '2021-12-16' and '2022-01-12'

     -- and cn_ntrc.org_id  in (43131, 34524)
    group by cn_ntrc.org_id
    having sum(fctd.taxi_order_lcy_cost)>0
)

select fin.*, chck.date_control, chck.date_control is not null as client_activ, chck.cnt_control_deliv
     , date_part('epoch', chck.date_control -fin.date_order) as time_control
from fin
left join chck on chck.org_id=fin.org_id
;

-------------------------------------------------------------------------------------------------------------

drop table if exists tt_1
create temporary table tt_1 as
--with tt_1 as (
    select bal.person_inn client_id
         ,max(client_name) client_name
         ,max(contract_id) contract_id
         ,max(manager_login) manager_login
         ,max(manager_name) manager_name
         ,max(manager_group) manager_group
         ,max(market_segment) market_segment
         --, max(cn_ntrc.deal_title) as deal_title
         , fctd.order_id
         , sum(fctd.taxi_order_lcy_cost)                         as gmv
         , min(utc_created_dttm)                                 as time_c
         , case when (max(min(utc_created_dttm)) over(partition by bal.person_inn))=min(utc_created_dttm) then 1 else 0 end next_flg
         , lead(min(utc_created_dttm),1,'2022-02-24'::timestamp)
           over (partition by bal.person_inn order by min(utc_created_dttm)) as time_lag
         , max(max(case when cn_hst.is_active is not null then 1 else 0 end))  over(partition by bal.person_inn) as deactiv_contr
         , '2022-02-24'::date- (min(min(utc_created_dttm)) over(partition by bal.person_inn))::date as cnt_date_deliv
         , sum(max(1))over (partition by bal.person_inn) cnt_del

    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
        left join snb_b2b.niksm_b2b_balance_contract_ext_info bal on bal.contract_external_id = cn_ntrc.contract_id
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
            left join snb_b2b.niksm_b2b_corp_contracts_hist as cn_hst on cn_hst.contract_external_id= cn_ntrc.contract_id
               and cn_hst.snapshot_date='2022-02-24'  and cn_hst.is_active=0
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  between --'2021-01-01' and '2022-02-15'
      --'2021-02-01' and '2021-09-01'
      '2021-03-01' and '2022-02-24'
      --'2021-04-01' and '2021-11-01'
    --and cn_ntrc.org_id  in (43131, 34524)
    group by bal.person_inn, fctd.order_id
    having sum(fctd.taxi_order_lcy_cost)>0
     distributed by (client_id, order_id);
--)
 analyse  tt_1 ;

with tt as (
select client_id
         ,max(client_name) client_name
         ,max(contract_id) contract_id
         ,max(manager_login) manager_login
         ,max(manager_name) manager_name
         ,max(manager_group) manager_group
         ,max(market_segment) market_segment
         ,sum(gmv) gmv
         ,time_lag::date as time_lag
         ,time_c::date as time_c
         ,max(deactiv_contr)  deactiv_contr
         ,max(cnt_date_deliv) cnt_date_deliv
         ,max(next_flg)next_flg
         ,max(cnt_del)cnt_del
from tt_1
    group by client_id,time_lag::date,time_c::date
)

, t12 as (
select client_id
         ,client_name
         ,contract_id
         ,manager_login
         ,manager_name
         ,manager_group
         ,market_segment
         ,gmv
         ,cnt_del
         ,time_lag::timestamp-time_c::timestamp as time_delta
       , row_number() over (partition by client_id order by time_lag-time_c) as row_n
       , row_number() over (order by time_lag-time_c) as row_n_all
       , count()over (partition by client_id) cnt_row
       , count()over () cnt_row_all
       , sum(gmv) over(partition by client_id order by time_lag-time_c
            rows between UNBOUNDED PRECEDING and CURRENT ROW) gmv_cumul
       ,99 as series_qntl
       --,generate_series(90,99,1) as series_qntl
from tt
where next_flg =0
)
, t13 as (
    select client_id
         ,client_name
         ,contract_id
         ,manager_login
         ,manager_name
         ,manager_group
         ,market_segment
         , cnt_del
         , gmv
         , time_delta
         , row_n
         , row_n_all
         , cnt_row
         , cnt_row_all
         , gmv_cumul
         , 'qntl_' || series_qntl                as series_qntl
         , ceil(cnt_row * series_qntl / 100)     as row_qntl
         , ceil(cnt_row_all * series_qntl / 100) as row_all_qntl
    from t12
)
,base_qntl as (
select
         client_id, series_qntl
         ,max(client_name) client_name
         ,max(contract_id) contract_id
         ,max(manager_login) manager_login
         ,max(manager_name) manager_name
         ,max(manager_group) manager_group
         ,max(market_segment) market_segment
     , max(cnt_del) cnt_del
       , max(case when row_qntl=row_n then date_part('epoch', time_delta)  end) as time_delta_qntl
       , max(case when row_qntl=row_n then gmv_cumul  end) as gmv_cumul_qntl
       , max(cnt_row)cnt_row
       , max(cnt_row_all) cnt_row_all
       , max(max(case when row_all_qntl=row_n_all then date_part('epoch', time_delta)  end)) over(partition by series_qntl) as time_delta_all_qntl

from t13
group by  client_id,series_qntl
    )
, b1 as (
    select series_qntl, time_delta_qntl
         , ceil(count() over (partition by series_qntl) * 0.9) as cnt
         , row_number() over (partition by series_qntl order by time_delta_qntl) as row_n_qntl


    from base_qntl
--     where cnt_row >= 5
)
, qntl_apr as (
    select series_qntl,
           max(case when cnt=row_n_qntl then time_delta_qntl  end) as time_delta_all_qntl
    from b1
    group by series_qntl
)

, fin as (
    select test.client_id
         ,test.client_name
         ,test.contract_id
         ,test.manager_login
         ,test.manager_name
         ,test.manager_group
         ,test.market_segment
         , test.order_id
         , test.time_c                                                                                            as date_order
         , base_qntl.cnt_del
         , test.deactiv_contr
         , test.cnt_date_deliv
         , date_part('epoch', test.time_lag - test.time_c)                                                        as time_next_order
         , qntl_apr.series_qntl

          , coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))                                                   as time_limit_qntl
         , coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl)))  as time_limit_qntl_minday
        , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))                                                   as qntl_flg
        , date_part('epoch', test.time_lag - test.time_c) >
           coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl)))    as qntl_flg_minday



         , greatest(
                 coalesce(case when base_qntl.cnt_row >= 5 then base_qntl.time_delta_qntl end,
             max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))- date_part('epoch', test.time_lag - test.time_c),
                0)                                                                                                as time_to_qntl
         , greatest(
                coalesce(case when base_qntl.cnt_row >= 5 then greatest(date_part('epoch','1 day'::interval),base_qntl.time_delta_qntl) end,
             greatest(date_part('epoch','1 day'::interval),max(qntl_apr.time_delta_all_qntl) over(partition by qntl_apr.series_qntl))),
                0)                                                                                                as time_to_qntl_minday
    from tt_1 test
             cross join qntl_apr
             left join base_qntl on base_qntl.client_id = test.client_id  and qntl_apr.series_qntl=base_qntl.series_qntl
             --and base_qntl.cnt_row >= 5
    where test.next_flg = 1
)

 , chck  as (
    select   bal.person_inn client_id
         , utc_created_dttm::date                                as date
         , count(distinct fctd.order_id ) as cnt_deliv
    from snb_b2b.niksm_b2b_contracts_info cn_ntrc
         left join snb_b2b.niksm_b2b_balance_contract_ext_info bal on bal.contract_external_id = cn_ntrc.contract_id
             left join taxi_cdm_logistic.fct_delivery fctd on fctd.taxi_corp_contract_id = cn_ntrc.contract_id
    where 1 = 1
      --and cn_ntrc.manager_group = 'Тир 3'
      and fctd.utc_created_dttm  between --'2021-08-01' and '2021-11-01'
      --'2021-09-01' and '2021-12-01'
      '2022-01-01' and '2022-02-24'
      --'2021-11-01' and '2022-02-01'
      --and fctd.utc_created_dttm not between '2021-12-16' and '2022-01-12'

     -- and cn_ntrc.org_id  in (43131, 34524)
    group by bal.person_inn,utc_created_dttm::date
    having sum(fctd.taxi_order_lcy_cost)>0
)

select fin.*, chck.date, chck.cnt_deliv
from fin
left join chck on chck.client_id=fin.client_id
;
