import pandas as pd

from business_models.startrek import StartrekWrapper

from projects.common.tools import run_sql

FILENAME = 'ozon_analitics.xlsx'
TICKET_ID = 'LOGDATA-267'


def main():
    df1 = run_sql('result_1.sql')
    df2 = run_sql('result_2.sql')

    print(f'Writing to {FILENAME}...')
    with pd.ExcelWriter(FILENAME) as writer:
        df1.to_excel(writer, sheet_name='data_table', index=False, encoding='utf-8')
        df2.to_excel(writer, sheet_name='data_multi_points', index=False, encoding='utf-8')

    print(f'Sending to {TICKET_ID}...')
    st = StartrekWrapper()
    st.comment(TICKET_ID, text='Обновленные данные по Ozon', attachments=FILENAME)


if __name__ == '__main__':
    main()
