drop table analyst.gorbunov_yd_logdata267;
create table analyst.gorbunov_yd_logdata267 as
select date_trunc('week',utc_order_dt)::date as calweek,
       case when dmo.order_source_address = 'Россия, Москва, 2-й Хорошёвский проезд, 7с1' then 'Россия, Москва, 2-й Хорошёвский проезд, 7с1А' else
           coalesce(a_comb.grouped_address, dmo.order_source_address) end as order_source_address,
       (avg(extract(epoch from utc_start_waiting_dttm - utc_order_dttm)) filter ( where  success_order_flg))/60 as avg_arrival_time,
       (sum(plan_travel_distance_km) filter ( where  success_order_flg))/sum(n_deliveries_visited) as travel_distance_km,
       sum(n_deliveries_visited)/sum(n_deliveries_total) as CR,
       sum(n_deliveries_total) as n_total,
--        (sum(n_deliveries_total) filter ( where success_order_flg)) as success_order,
       sum(n_deliveries_visited) as deliveries_cnt
from snb_taxi.logdata_dm_order_v as dmo
  left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and dmo.utc_order_dt >= date_trunc('week',current_date-21)
  and logistic_tariff_flag
--   and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '1122918/20'
group by 1,2;
select * from analyst.gorbunov_yd_logdata267 where  order_source_address = 'Россия, Санкт-Петербург, проспект Обуховской Обороны, 295АС';

-- точка точка
drop table analyst.gorbunov_yd_logdata267_point_point;
create table analyst.gorbunov_yd_logdata267_point_point as
select date_trunc('week',utc_order_dt)::date as calweek,
       case when dmo.order_source_address = 'Россия, Москва, 2-й Хорошёвский проезд, 7с1' then 'Россия, Москва, 2-й Хорошёвский проезд, 7с1А' else
           coalesce(a_comb.grouped_address, dmo.order_source_address) end as order_source_address,
       count(n_deliveries_visited) as point_point_cnt, --число точек
       sum(order_cost) as pp_cost,
       sum(order_cost)/count(n_deliveries_visited) as pp_stop_cost
from snb_taxi.logdata_dm_order_v as dmo
left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and n_deliveries_total = 1
  and logistic_tariff_flag
  and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '1122918/20'
  and dmo.utc_order_dt >= date_trunc('week',current_date-21)
group by 1,2;
select * from analyst.gorbunov_yd_logdata267_point_point;

-- мультиточки
drop table analyst.gorbunov_yd_logdata267_multi_points;
create table analyst.gorbunov_yd_logdata267_multi_points as
select date_trunc('week',utc_order_dt)::date as calweek,
       case when dmo.order_source_address = 'Россия, Москва, 2-й Хорошёвский проезд, 7с1' then 'Россия, Москва, 2-й Хорошёвский проезд, 7с1А' else
           coalesce(a_comb.grouped_address, dmo.order_source_address) end as order_source_address,
       sum(order_cost) as mp_cost,
       sum(order_cost)/sum(n_deliveries_visited) as mp_stop_cost,
       count(n_deliveries_visited) as multi_point_cnt,
       sum(n_deliveries_visited) as multi_point_sum
from snb_taxi.logdata_dm_order_v as dmo
left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and n_deliveries_total > 1
  and logistic_tariff_flag
  and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '1122918/20'
  and dmo.utc_order_dt >= date_trunc('week',current_date-21)
group by 1,2;
select * from analyst.gorbunov_yd_logdata267_multi_points;

drop table analyst.gorbunov_yd_logdata267_result_1;
create table analyst.gorbunov_yd_logdata267_result_1 as
select t1.*, t2.point_point_cnt, t2.pp_stop_cost, t3.mp_stop_cost, t3.multi_point_cnt, t3.multi_point_sum
from analyst.gorbunov_yd_logdata267 as t1
left join analyst.gorbunov_yd_logdata267_point_point as t2
    on t1.calweek = t2.calweek and t1.order_source_address = t2.order_source_address
left join analyst.gorbunov_yd_logdata267_multi_points as t3
    on t1.calweek = t3.calweek and t1.order_source_address = t3.order_source_address;

grant select on analyst.gorbunov_yd_logdata267_multi_points to public;
grant select on analyst.gorbunov_yd_logdata267_point_point to public;
grant select on analyst.gorbunov_yd_logdata267 to public;
grant select on analyst.gorbunov_yd_logdata267_result_1 to public;
