 select dmo.utc_order_dt,
       dmo.city,
       coalesce(a_comb.grouped_address, dmo.order_source_address) as order_source_address,
       order_cost,
       n_deliveries_visited, --число точек
       order_cost/n_deliveries_visited as stop_cost
from snb_taxi.logdata_dm_order_v as dmo
left join snb_taxi.niksm_b2b_a_points_combination as a_comb
    on a_comb.raw_address = dmo.order_source_address
    and a_comb.corp_client_id = dmo.corp_client_id
where true
  and n_deliveries_visited > 1
  and logistic_tariff_flag
  and dmo.success_order_flg
  and not dmo.fake_order_flg
  and not dmo.mqc_order_flg
  and corp_contract_id = '1122918/20'
  and success_order_flg
  and dmo.utc_order_dt >= date_trunc('week',current_date-21)
order by dmo.utc_order_dt, order_source_address;

grant select on analyst.gorbunov_yd_logdata267_result_2  to public;