

drop table if exists fct_order;
create temporary table fct_order as
    select corp_client_id,corp_contract_id,order_id,
           delivery_point_cnt,
           utc_order_created_dttm
    from taxi_cdm_marketplace.fct_order

    where utc_order_created_dttm >= '2021-12-01'
    and success_order_flg
;

-- drop table if exists snb_b2b.partners_sales_slice_yd;
-- create table  snb_b2b.partners_sales_slice_yd as
truncate  table  snb_b2b.partners_sales_slice_yd;
insert into snb_b2b.partners_sales_slice_yd
with partner_table as (
    select city, partner, manager_login
    from (values
   ('Ставрополь','Интелтелеком Юг','mulika-pp'),
('Пермь','ИП Грецкий','grebenkina-pp'),
('Пермь','Пермь Трансавто','pesterev-pp'),
('Пермь','Пермь Трансавто','busyreva-pp'),
('Уфа','ИП Рахимова','rahimov-pp'),
('Ставрополь','Интелтелеком Юг','lebedinsk-pp'),
('Пермь','ИП Фалехутдинов','kuznetsov-pp'),
('Казань','ИП Мартынов','pp-martynova'),
('Уфа','ИП Рахимова','rakhimova-pp'),
('Пермь','ИП Фалехутдинов','falehutdin-pp'),
('Уфа','ООО Альфа-Парк','husainov-pp'),
('Екатеринбург','ИМ Малинин','hmelkov-pp'),
('Сочи','ООО "Темп"','suhoruchko-pp'),
('Сочи','ООО "Темп"','baryanova-pp'),
('Пермь','ИП Грецкий','shmakova-pp'),
('Пермь','ИП Грецкий','gretsky-pp'),
('Пермь','ИП Грецкий','pp-kuznetsova'),
('Пермь','ИП Грецкий','rudakov-pp'),
('Уфа','ООО Альфа-Парк','sultangil-pp'),
('Уфа','ООО Альфа-Парк','mullayanov-pp'),
('Уфа','ООО Альфа-Парк','kinzagulov-pp'),
('Санкт-Петербург','АБ ГРУПП','baryshnik-pp'),
('Зеленоград ','ИП Золотухин','solovyov-pp'),
('Орехово-Зуево','ИП Платков ','nazarov-pp'),
('Волгоград','Каскад Доставка','kochegin-pp'),
('Волгоград','Каскад Доставка','lesnikov-pp'),
('Казань','ИП Мартынов','martynov-pp'),
('Казань','ИП Мартынов','bilalov-pp'),
('Ставрополь','Интелтелеком Юг','paltseva-kk'),
('Ставрополь','Интелтелеком Юг','seredyagin-pp'),
('Уфа','ООО Альфа Парк','sultonova-pp'),
('Санкт-Петербург','АБ ГРУПП','krinicin-pp'),
('Екатеринбург','ИМ Малинин','nizhnik-pp'),
('Екатеринбург','ИМ Малинин','shypova-pp'),
('Екатеринбург','ИМ Малинин','vershinina-pp'),
('Орехово-Зуево','ИП Платков ','maplatkov-pp'),
('МО','ООО Дакс Драйв','shpak-pp'),
('Уфа','ООО Альфа Парк','asadullina-pp'),
('Ступино','ИП Кудрявцев','mihalev-pp'),
('Уфа','ООО Альфа Парк','agishev-pp'),
('Уфа','ООО Альфа Парк','gareev-pp'),
('Раменское','ЦД Хоттабыч','pilipzova-pp')
    ) as t(city, partner, manager_login)
)
     , dh as (
    select dih.deal_id,dih.which_crm,
           max(dih.snapshot_date)snapshot_date,
           (dih.status='open' and dih_old.status='lost') as restart_deal
    from snb_b2b.niksm_b2b_deals_info_hist dih
      left join snb_b2b.niksm_b2b_deals_info_hist dih_old
        on dih.deal_id = dih_old.deal_id
        and dih.which_crm = dih_old.which_crm
        and dih.snapshot_date=dih_old.snapshot_date+1
     where dih.status='open'
       and dih_old.status='lost'
     group by  dih.deal_id,dih.which_crm,  (dih.status='open' and dih_old.status='lost')
)
 , tasks_deal as (
select responsible_user_id,
sum(1) as cnt_task
from delivery_ods_amocrm.task
where entity_type = 'leads'
and completed_flg
and ((utc_updated_dttm at time zone 'UTC') at time zone 'Europe/Moscow')::date=current_date-1
group by responsible_user_id
)

, ld_inf as (select manager_login
                  , manager_name
                  , max((td.responsible_user_id is not null)::int) as status_active
                  , coalesce(dh.snapshot_date - 1, aml.utc_lead_created_dttm::date)                                   as created_date
                  , coalesce(aml.corp_client_id, lk_client_id)                                                        as corp_client_id
                  , aml.lead_id
                  , max(1)                                                                                            as cnt_deal_all
                  , max(case
                            when coalesce(dh.snapshot_date - 1, aml.utc_lead_created_dttm::date) = current_date - 1
                                then 1
                            else 0 end)                                                                               as cnt_deal_yd
                  , max(case
                            when aml.contract_id is not null
                                or (pipeline_name = 'ФЕНИКС' and pipeline_status_name in
                                                                 ('ПЛАТЕЖНЫЕ ДАННЫЕ ПОДТВЕРЖДЕНЫ', 'ОБУЧЕНИЕ ПРОЙДЕНО',
                                                                  'СОВЕРШЕНА ПЕРВАЯ ДОСТАВКА', 'РАЗВИТИЕ'))
                                then 1
                            else 0 end)                                                                                  cnt_contract_all
                  , sum(delivery_point_cnt)                                                                           as dlv_cnt_all
                  , sum(case
                            when utc_order_created_dttm::date = current_date - 1 then delivery_point_cnt
                            else 0 end)                                                                               as dlv_cnt_yd

             from snb_b2b.amo_leads_info aml
                      left join tasks_deal td on td.responsible_user_id=aml.responsible_user_id
                      left join dh on dh.deal_id = aml.lead_id
                      left join snb_b2b.niksm_b2b_lk_contract_info lk on lk.contract_external_id = aml.contract_id
                      left join fct_order fd on fd.corp_client_id = coalesce(aml.corp_client_id, lk_client_id)
                     and fd.utc_order_created_dttm>='2021-12-01'::date
             where manager_group = 'Партнерские продажи'
             group by manager_login, manager_name, coalesce(dh.snapshot_date - 1, aml.utc_lead_created_dttm::date)
                    , aml.lead_id, coalesce(aml.corp_client_id, lk_client_id)  )

select manager_login , manager_name
, max(status_active) as status_active
, sum(cnt_deal_all) as cnt_deal_all
, sum(cnt_deal_yd) cnt_deal_yd
, sum(cnt_contract_all) cnt_contract_all
, sum(case when dlv_cnt_all>0 then cnt_contract_all else 0 end) cnt_cntrct_dl_all
, sum(dlv_cnt_all)dlv_cnt_all
, sum(dlv_cnt_yd)dlv_cnt_yd
, current_date-1 as report_date
from ld_inf
group by manager_login , manager_name
;