drop table if exists dl_bal;
create temporary table dl_bal as
with partner_table as (
    select city, partner, manager_login
    from (values
   ('Ставрополь','Интелтелеком Юг','mulika-pp'),
('Пермь','ИП Грецкий','grebenkina-pp'),
('Пермь','Пермь Трансавто','pesterev-pp'),
('Пермь','Пермь Трансавто','busyreva-pp'),
('Уфа','ИП Рахимова','rahimov-pp'),
('Ставрополь','Интелтелеком Юг','lebedinsk-pp'),
('Пермь','ИП Фалехутдинов','kuznetsov-pp'),
('Казань','ИП Мартынов','pp-martynova'),
('Уфа','ИП Рахимова','rakhimova-pp'),
('Пермь','ИП Фалехутдинов','falehutdin-pp'),
('Уфа','ООО Альфа-Парк','husainov-pp'),
('Екатеринбург','ИМ Малинин','hmelkov-pp'),
('Сочи','ООО "Темп"','suhoruchko-pp'),
('Сочи','ООО "Темп"','baryanova-pp'),
('Пермь','ИП Грецкий','shmakova-pp'),
('Пермь','ИП Грецкий','gretsky-pp'),
('Пермь','ИП Грецкий','pp-kuznetsova'),
('Пермь','ИП Грецкий','rudakov-pp'),
('Уфа','ООО Альфа-Парк','sultangil-pp'),
('Уфа','ООО Альфа-Парк','mullayanov-pp'),
('Уфа','ООО Альфа-Парк','kinzagulov-pp'),
('Санкт-Петербург','АБ ГРУПП','baryshnik-pp'),
('Зеленоград ','ИП Золотухин','solovyov-pp'),
('Орехово-Зуево','ИП Платков ','nazarov-pp'),
('Волгоград','Каскад Доставка','kochegin-pp'),
('Волгоград','Каскад Доставка','lesnikov-pp'),
('Казань','ИП Мартынов','martynov-pp'),
('Казань','ИП Мартынов','bilalov-pp'),
('Ставрополь','Интелтелеком Юг','paltseva-kk'),
('Ставрополь','Интелтелеком Юг','seredyagin-pp'),
('Уфа','ООО Альфа Парк','sultonova-pp'),
('Санкт-Петербург','АБ ГРУПП','krinicin-pp'),
('Екатеринбург','ИМ Малинин','nizhnik-pp'),
('Екатеринбург','ИМ Малинин','shypova-pp'),
('Екатеринбург','ИМ Малинин','vershinina-pp'),
('Орехово-Зуево','ИП Платков ','maplatkov-pp'),
('МО','ООО Дакс Драйв','shpak-pp'),
('Уфа','ООО Альфа Парк','asadullina-pp'),
('Ступино','ИП Кудрявцев','mihalev-pp'),
('Уфа','ООО Альфа Парк','agishev-pp'),
('Уфа','ООО Альфа Парк','gareev-pp'),
('Раменское','ЦД Хоттабыч','pilipzova-pp')
    ) as t(city, partner, manager_login)
)
, deals_info as (
      select *,
             case when (user_group_name = 'Партнерские продажи' and contract_id is not null) or
                       (phoenix_flg and corp_client_id is not null)  then 1 else 0 end pr_cntr,
             max(case when user_group_name = 'Партнерские продажи' then 1 else 0 end)
                 over (partition by company_id) as pr_dial
      from snb_b2b.amo_leads_info
      where crm_source in ('yandexdelivery')
)
, dl_inf as (
      select company_name as org_name,
             max(manager_login) over (partition by company_id) as manager_login,
             max(city) over (partition by company_id) as city,
             case when user_group_name = 'Партнерские продажи' then 'ПАРТНЕРСКИЕ ПРОДАЖИ' end as channel,
             case when phoenix_flg then 'ФЕНИКС' end  as pipeline_name,
             contract_id,
             coalesce(corp_client_id,ctf.lk_client_id) as  corp_client_id,
             utc_lead_created_dttm as add_time,
            lead_id as lead_id,
            price as potential

      from deals_info
      left join snb_b2b.niksm_b2b_lk_contract_info ctf on ctf.contract_external_id=deals_info.contract_id
      where pr_dial = 1
        and pr_cntr = 1
  )

 --  select * from dl_inf;
, tt as (
 select  dln.contract_id as contract_id,
        case when pipeline_name ='ФЕНИКС' then dln.add_time else blnc.start_dt end as start_dt,
        case when pipeline_name ='ФЕНИКС' then null else blnc.finish_dt end as finish_dt,
       dln.org_name,
       blnc.payment_type,
       dln.manager_login,
       partner_table.partner,
       blnc.manager,
       blnc.currency,
       dln.city,
       dln.potential,
       'https://yandexdelivery.amocrm.ru/leads/detail/'||dln.lead_id as deal_id,
       dbt.invoice_payments_sum,
       dbt.debt_sum,
        coalesce(dln.pipeline_name,dln.channel )as channel,
        dln.corp_client_id,
       generate_series('2021-12-01', current_date, '1 mon'::interval) as month_d
from dl_inf dln
    left join  snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = dln.contract_id
  left join   partner_table on partner_table.manager_login=dln.manager_login and partner_table.city=dln.city
  left join snb_b2b.voytekh_corporate_contracts_and_debts dbt
     on dln.contract_id = dbt.contract
)

select * from tt;
--------------------------------------------
drop table if exists fct_order;
create temporary table fct_order as
-- with fct_order as (
    select fctm.corp_client_id,corp_contract_id,order_id,
           delivery_point_cnt,gmv_amt, currency_rate,
           net_inflow_total_amt as net_inflow_amt,
           utc_order_created_dttm
    from taxi_cdm_marketplace.fct_order_metric fctm
    join (select corp_client_id from dl_bal group by corp_client_id) as dl_inf on fctm.corp_client_id=dl_inf.corp_client_id
    where utc_order_created_dttm >= '2021-12-01'
-- )
;
----------------------------------------------
-- ,fct_order2 as (
--     select coalesce(ord_fenix.corp_client_id,corp_contract_id) as join_id
--            ,order_id,delivery_point_cnt,gmv_amt, currency_rate, net_inflow_amt, utc_order_created_dttm
--     from fct_order
--     left join ord_fenix on fct_order.order_id=ord_fenix.taxi_order_id
--     )
drop table if exists partner_upd;
create temporary table partner_upd as
select contract_id,
       month_d::date,
       channel,
       max(start_dt) as start_dt,
       1 as cnt_contract,
       --start_dt,
            case when sum(coalesce(fct.gmv_amt*fct.currency_rate, 0))>0 then 'Act'
            when sum((coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)),0)=0)::integer) over ( partition by contract_id order by month_d rows BETWEEN  2 PRECEDING and current row )<3
                 and max(case when finish_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end)=0 then 'No_act'
            else 'Outflow' end as status,
       max((date_trunc('month', current_date -1)=month_d)::integer) as current_month,
       max(tt.org_name) as org_name,
       max(tt.payment_type) as payment_type,
       max(tt.manager_login) as manager_login,
       max(tt.partner) as partner,
       max(tt.manager) as manager,
       max(tt.currency) as currency,
       max(tt.city) as city,
       coalesce(max(tt.invoice_payments_sum) ,0)as invoice_payments_sum,
       coalesce(max(tt.debt_sum),0) as debt_sum,
       max(case when start_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end) pr_new,
       max(case when finish_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end) pr_finish,

       coalesce(sum(coalesce(fct.delivery_point_cnt,0)),0) as cnt_delivery,
       coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)),0) as gmv_rub,
       coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)/(case when channel='ФЕНИКС' then 1 else 1.2 end) ),0) as gmv_rub_net,
       coalesce(sum(coalesce(fct.net_inflow_amt*fct.currency_rate, 0)),0)as net_inflow_rub,
       sum(case when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '3 mon'::interval then 0.15
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '3 mon'::interval and start_dt+ '6 mon'::interval then 0.1
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '9 mon'::interval then 0.05
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '9 mon'::interval and start_dt+ '12 mon'::interval then 0.03
            else 0 end*coalesce( coalesce(fct.gmv_amt*fct.currency_rate,0)/(case when channel='ФЕНИКС' then 1 else 1.2 end),0)) as commissions_rub,
       min(case when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '3 mon'::interval then 0.15
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '3 mon'::interval and start_dt+ '6 mon'::interval then 0.1
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '9 mon'::interval then 0.05
                when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '9 mon'::interval and start_dt+ '12 mon'::interval then 0.03
            else 0 end) as commissions_rate
       ,tt.corp_client_id
       ,max(tt.potential) as potential
       ,max(deal_id) deal_id
from dl_bal tt
-- left join fct_order2 fct
--     on  coalesce(tt.contract_id,tt.corp_client_id)=fct.join_id
left join fct_order fct
    on  tt.corp_client_id=fct.corp_client_id
           and fct.utc_order_created_dttm between month_d and month_d+'1 mon'::interval and fct.utc_order_created_dttm>='2021-12-01'::date
where date_trunc('month',start_dt)<=month_d and date_trunc('month',coalesce(finish_dt, current_date))>=month_d
group by contract_id,tt.corp_client_id,
       month_d,channel
;
-- drop table if exists snb_b2b.partners_sales_month;
-- create table  snb_b2b.partners_sales_month as
truncate  table  snb_b2b.partners_sales_month;
insert into snb_b2b.partners_sales_month
select *
from partner_upd;

--
--
-- with partner_table as (
--     select city, partner, manager_login
--     from (values
-- ('Волгоград','Каскад Доставка','kochegin-pp'),
-- ('Казань','ИП Мартынов','martynov-pp'),
-- ('Казань','ИП Мартынов','bilalov-pp'),
-- ('Пермь','ИП Фалехутдинов','kuznetsov-pp'),
-- ('Пермь','ИП Грецкий','shmakova-pp'),
-- ('Пермь','ИП Грецкий','gretsky-pp'),
-- ('Ставрополь','Интелтелеком Юг','paltseva-kk'),
-- ('Ставрополь','Интелтелеком Юг','seredyagin-pp'),
-- ('Уфа','ИП Рахимова','rakhimova-pp')
--
--     ) as t(city, partner, manager_login)
-- )
-- , dl_inf as (
--     select
--    org_name,
--    max(manager_login) over(partition by org_name)  manager_login,
--    max(city) over(partition by org_name) city,
--    case when channel = 'ПАРТНЕРСКИЕ ПРОДАЖИ' then channel end as channel,
--    case when pipeline_name =  'ФЕНИКС' then pipeline_name end as pipeline_name,
--    max(contract_id)  over(partition by org_name) contract_id_pr,
--   contract_id,
--   corp_client_id,
--   add_time,
--   max(case when channel = 'ПАРТНЕРСКИЕ ПРОДАЖИ' then 1 else 0 end) over(partition by org_name) as channel_pr
--    from  snb_b2b.niksm_b2b_deals_info
-- where which_crm = 6
--       and (channel in ('ПАРТНЕРСКИЕ ПРОДАЖИ') or pipeline_name in ('ФЕНИКС'))
-- )
-- , tt as (
--  select  dln.contract_id as contract_id,
--         case when channel ='ПАРТНЕРСКИЕ ПРОДАЖИ' then blnc.start_dt else dln.add_time end  start_dt,
--         case when channel ='ПАРТНЕРСКИЕ ПРОДАЖИ' then blnc.finish_dt end finish_dt,
--        dln.org_name,
--        blnc.payment_type,
--        dln.manager_login,
--        partner_table.partner,
--        blnc.manager,
--        blnc.currency,
--        dln.city,
--        dbt.invoice_payments_sum,
--        dbt.debt_sum,
--         coalesce(dln.channel,dln.pipeline_name )as channel,
--         dln.corp_client_id,
--        generate_series('2021-12-01', current_date, '1 mon'::interval) as month_d
-- from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
--   join dl_inf dln
--     on blnc.contract_external_id = dln.contract_id_pr
--   left join   partner_table on partner_table.manager_login=dln.manager_login and partner_table.city=dln.city
--   left join snb_b2b.voytekh_corporate_contracts_and_debts dbt
--      on dln.contract_id = dbt.contract
-- where channel_pr=1   -- поменять на признак владельца
-- )
-- --  select* from tt;
-- , ord_fenix as (
--     select clm.corp_client_id,
--            taxi_order_id
--     from delivery_ods_cargo_claims.claim clm
--              join tt on tt.corp_client_id = clm.corp_client_id
--     where clm.utc_created_dttm > '2021-12-01'
--       and clm.status_code = 'delivered_finish'
--       and clm.corp_client_id is not null
--       and tt.contract_id is null
--     group by clm.corp_client_id,
--            taxi_order_id
-- )
-- ,fct_order as (
--     select corp_client_id,corp_contract_id,order_id,
--     delivery_point_cnt,gmv_amt, currency_rate, net_inflow_amt, utc_order_created_dttm
--     from taxi_cdm_marketplace.fct_order_metric
--     where utc_order_created_dttm >= '2021-12-01'
-- )
-- ,fct_order2 as (
--     select coalesce(corp_contract_id,ord_fenix.corp_client_id) as join_id
--            ,order_id,delivery_point_cnt,gmv_amt, currency_rate, net_inflow_amt, utc_order_created_dttm
--     from fct_order
--     left join ord_fenix on fct_order.order_id=ord_fenix.taxi_order_id
--     )
--
-- -- select * from fct_order2
-- -- where join_id in ('3164743/22','2944177/21','2841494/21','3100573/22','3164730/22','3100572/22','2854572/21','3107052/22','3100586/22','2854633/21','2943788/21','2828499/21','2938668/21','3108313/22','3114198/22','3049251/22'
-- -- ,'9dc82729027a46f0a382df14b9c6da0e');
-- select contract_id,
--        month_d::date,
--        channel,
--        max(start_dt) as start_dt,
--        1 as cnt_contract,
--        --start_dt,
--             case when sum(coalesce(fct.gmv_amt*fct.currency_rate, 0))>0 then 'Act'
--             when sum((coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)),0)=0)::integer) over ( partition by contract_id order by month_d rows BETWEEN  2 PRECEDING and current row )<3
--                  and max(case when finish_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end)=0 then 'No_act'
--             else 'Outflow' end as status,
-- --        case when sum(coalesce(fct.gmv_amt*fct.currency_rate, fct2.gmv_amt*fct2.currency_rate))>0 then 'Act'
-- --             when sum((coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, fct2.gmv_amt*fct2.currency_rate)),0)=0)::integer) over ( partition by contract_id order by month_d rows BETWEEN  2 PRECEDING and current row )<3
-- --                  and max(case when finish_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end)=0 then 'No_act'
-- --             else 'Outflow' end as status,
--        max((date_trunc('month', current_date -1)=month_d)::integer) as current_month,
--        max(tt.org_name) as org_name,
--        max(tt.payment_type) as payment_type,
--        max(tt.manager_login) as manager_login,
--        max(tt.partner) as partner,
--        max(tt.manager) as manager,
--        max(tt.currency) as currency,
--        max(tt.city) as city,
--        coalesce(max(tt.invoice_payments_sum) ,0)as invoice_payments_sum,
--        coalesce(max(tt.debt_sum),0) as debt_sum,
--        max(case when start_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end) pr_new,
--        max(case when finish_dt between month_d and  month_d+'1 mon'::interval then 1 else 0 end) pr_finish,
--        --date_trunc('month', utc_order_created_dttm::date) as month ,
--        --utc_order_created_dttm,
--
--        coalesce(sum(coalesce(fct.delivery_point_cnt,0)),0) as cnt_delivery,
--        coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)),0) as gmv_rub,
--        coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, 0)/(case when channel='ФЕНИКС' then 1 else 1.2 end) ),0) as gmv_rub_net,
--        coalesce(sum(coalesce(fct.net_inflow_amt*fct.currency_rate, 0)),0)as net_inflow_rub,
--        sum(case when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '6 mon'::interval then 0.1
--             when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '12 mon'::interval then 0.05
--             else 0 end*coalesce( coalesce(fct.gmv_amt*fct.currency_rate,0)/(case when channel='ФЕНИКС' then 1 else 1.2 end),0)) as commissions_rub,
--        min(case when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '6 mon'::interval then 0.1
--             when coalesce(fct.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '12 mon'::interval then 0.05
--             else 0 end) as commissions_rate
--        ,tt.corp_client_id
-- --
-- --        coalesce(sum(coalesce(fct.delivery_point_cnt,fct2.delivery_point_cnt)),0) as cnt_delivery,
-- --        coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, fct2.gmv_amt*fct2.currency_rate)),0) as gmv_rub,
-- --        coalesce(sum(coalesce(fct.gmv_amt*fct.currency_rate, fct2.gmv_amt*fct2.currency_rate)/1.2),0) as gmv_rub_net,
-- --        coalesce(sum(coalesce(fct.net_inflow_amt*fct.currency_rate, fct2.net_inflow_amt*fct2.currency_rate)),0)as net_inflow_rub,
-- --        sum(case when coalesce(fct.utc_order_created_dttm,fct2.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '6 mon'::interval then 0.1
-- --             when coalesce(fct.utc_order_created_dttm,fct2.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '12 mon'::interval then 0.05
-- --             else 0 end*coalesce( coalesce(fct.gmv_amt,fct2.gmv_amt)  * coalesce(fct.currency_rate,fct2.currency_rate)/1.2,0)) as commissions_rub,
-- --        min(case when coalesce(fct.utc_order_created_dttm,fct2.utc_order_created_dttm,current_date)  between start_dt and start_dt+ '6 mon'::interval then 0.1
-- --             when coalesce(fct.utc_order_created_dttm,fct2.utc_order_created_dttm,current_date)  between start_dt+ '6 mon'::interval and start_dt+ '12 mon'::interval then 0.05
-- --             else 0 end) as commissions_rate
--
--
-- from tt
-- -- left join fct_order  fct
-- --     on  tt.contract_id=fct.corp_contract_id
-- --            and fct.utc_order_created_dttm between month_d and month_d+'1 mon'::interval and fct.utc_order_created_dttm>='2021-12-01'::date
-- left join fct_order2  fct
--     on  coalesce(tt.contract_id,tt.corp_client_id)=fct.join_id
--            and fct.utc_order_created_dttm between month_d and month_d+'1 mon'::interval and fct.utc_order_created_dttm>='2021-12-01'::date
-- where date_trunc('month',start_dt)<=month_d and date_trunc('month',coalesce(finish_dt, current_date))>=month_d
-- group by contract_id,tt.corp_client_id,
--        month_d,channel
-- ;
--
--
-- -- select  corp_client_id,  taxi_order_id, utc_created_dttm
-- -- from delivery_ods_cargo_claims.claim
-- -- where utc_created_dttm >'2022-01-01'
-- -- and corp_client_id='9dc82729027a46f0a382df14b9c6da0e';
