with first_data as (
    select date_trunc('day', snapshot_dttm::date)                                                   as date,
           corp_client_id,
           count(distinct case when is_removed = False and is_disabled = False then yandex_uid end) as cnt_employes
    from snb_b2b.niksm_cargo_corp_employees
    group by 1, 2
),

     cnt_emp as (
         select date,
                count(distinct case when cnt_employes > 1 then corp_client_id end) as cnt_client_with_employes,
                sum(case when cnt_employes > 1 then cnt_employes end)              as sum_employes
         from first_data
         where cnt_employes > 0
         group by 1
),

     cnt_all_client_phoenix as (
         select date_trunc('day', contact_phone_created) as date,
                count(distinct corp_client_id)           as cnt_client_all
         from snb_delivery.ferenec_funnel_phoenix_nrvn
         where card_created is not null
         group by 1)
select cap.*,
       sum(cap.cnt_client_all) over (order by cap.date) as rolling_client_all,
       cnt_emp.cnt_client_with_employes,
       cnt_emp.sum_employes
from cnt_all_client_phoenix as cap
left join cnt_emp using(date)