--truncate table snb_b2b.ferenec_funnel_phoenix_nrvn;
create table snb_b2b.ferenec_funnel_phoenix_nrvn_tmp as
--insert into snb_b2b.ferenec_funnel_phoenix_nrvn
with event_1 as
         (
             select item_id,
                    contact_phone_pd_id,
                    to_timestamp(created) at time zone 'Europe/Moscow' as created,
                    coalesce(substring(utm_data from '\[\[utm_source, ([^\]]+)\].*\]$'), 'organic') as utm_source,
                    substring(utm_data from '\[utm_medium, ([^\]]+)\].*\]$') as utm_medium,
                    substring(utm_data from '\[utm_campaign, (.*)\]\]$') as utm_campaign
             from snb_taxi.ferenec_raw_first_step_phoenix
             where kind = 'initial_form_request'
         ),
     event_2 as
         (
             select item_id,
                    corp_client_id,
                    to_timestamp(created) at time zone 'Europe/Moscow' as created
             from snb_taxi.ferenec_raw_first_step_phoenix
             where phoenix_step = 'company_created_form'
         ),
     event_2_2 as (
         select item_id
         from snb_taxi.ferenec_raw_first_step_phoenix
         where kind = 'phoenix_ticket_updated' and phoenix_step = 'company_info_form'
     ),
         raw_event_3 as
         (
             select item_id,
                    deal_id,
                    org_id,
                    to_timestamp(created) at time zone 'Europe/Moscow'     as created,
                    max(to_timestamp(created) at time zone 'Europe/Moscow') over (partition by item_id) as last_created
             from snb_taxi.ferenec_raw_first_step_phoenix
             where kind = 'pipedrive_account_created'
         ),
     event_3 as
         (
             select item_id,
                    deal_id,
                    org_id,
                    created
             from raw_event_3
             where last_created = created
         ),
    amo_crm as (
        select lead_id,
               company_id,
               external_event_id,
               utc_lead_created_dttm,
               pd_deal_id,
               pd_org_id
        from snb_b2b.amo_leads_info
        where True
            and phoenix_flg
    ),
     event_4 as (
         select item_id,
                phoenix_step                                       as card,
                to_timestamp(created) at time zone 'Europe/Moscow' as created
         from snb_taxi.ferenec_raw_first_step_phoenix
         where phoenix_step = 'card_bound_form'
     ),
     partition_fct_order as (
         select c.corp_client_id,
                cargo_ref_id,
                l.utc_created_dttm + interval '3 hours' as utc_order_created_dttm,
                min(l.utc_created_dttm + interval '3 hours') over (partition by l.corp_client_id) as utc_first_order_dttm,
                row_number() over (partition by c.corp_client_id order by l.utc_created_dttm) as rnb
         from delivery_ods_cargo_claims.claim c
         inner join delivery_ods_cargo_claims.claim_status_log l using (claim_id)
         where l.utc_created_dttm >= '2021-11-01'
           and c.utc_created_dttm >= '2021-11-01'
           and new_claim_status = 'accepted'
           and c.corp_client_id is not null
           and l.corp_client_id is not null
           and status_code in ('delivered_finish')
           and c.corp_client_id in (select distinct corp_client_id from snb_taxi.ferenec_raw_first_step_phoenix)
     ),
     order_all_agregation as (
         select corp_client_id,
                min(utc_first_order_dttm)                                                      as utc_first_order_dttm,
                bool_or(rnb = 2) as flg_second_deliveries,
                bool_or(rnb = 10) as flg_10_deliveries,
                max(case when rnb  = 2 then utc_order_created_dttm end) as dttm_second_deliveries,
                max(case when rnb  = 10 then utc_order_created_dttm end) as dttm_tenth_deliveries
         from partition_fct_order
         group by corp_client_id
    ),
     raw_funnel as (
         select e1.contact_phone_pd_id,              -- first_step
                e1.item_id as item_id,
                e1.created as contact_phone_created, -- first_step
                e1.utm_source as utm_source,
                e1.utm_medium as utm_medium,
                e1.utm_campaign as utm_campaign,
                e2.corp_client_id,
                e2.created as corp_client_id_created,
                e3.deal_id::int,
                e3.org_id::int,
                case when a1.lead_id is not null
                    then a1.lead_id
                    else a2.lead_id end as lead_id,
                case when a1.company_id is not null
                    then a1.company_id
                    else a2.company_id end as company_id,
                case when a1.external_event_id is not null
                    then a1.utc_lead_created_dttm
                    else e3.created  end as crm_created,
                e4.card,
                e4.created as card_created,
                o.utc_first_order_dttm as first_order,
                o.flg_second_deliveries as flg_second_deliveries,
                o.flg_10_deliveries as flg_10_deliveries,
                o.dttm_second_deliveries as dttm_second_deliveries,
                o.dttm_tenth_deliveries as dttm_tenth_deliveries
         from event_1 as e1
                  left join event_2_2 as e22
                            on e1.item_id = e22.item_id
                  left join event_2 as e2
                            on e22.item_id = e2.item_id and e2.created > e1.created
                  left join event_3 as e3
                            on e1.item_id = e3.item_id and e3.created > e1.created
                  left join amo_crm as a1
                            on e1.item_id = a1.external_event_id
                  left join amo_crm as a2
                            on e3.deal_id::int = a2.pd_deal_id and e3.org_id::int = a2.pd_org_id
                  left join event_4 as e4
                            on e2.item_id = e4.item_id and e4.created > e1.created
                  left join order_all_agregation as o
                            on o.corp_client_id = e2.corp_client_id  and o.utc_first_order_dttm >= e1.created
     )
select contact_phone_pd_id, item_id, contact_phone_created, utm_source, utm_medium, utm_campaign, corp_client_id, corp_client_id_created,
       deal_id, org_id,
       lead_id, company_id,
       crm_created,
       card, card_created, first_order,
       flg_second_deliveries, flg_10_deliveries, dttm_second_deliveries, dttm_tenth_deliveries
from raw_funnel
where contact_phone_created >= '2021-11-13';

--select 2+2;

--drop table snb_b2b.ferenec_funnel_phoenix_nrvn CASCADE;
--
 create view snb_delivery.ferenec_funnel_phoenix_nrvn_tmp as
    (select * from snb_b2b.ferenec_funnel_phoenix_nrvn_tmp);