truncate table snb_delivery.ferenec_funnel_phoenix;
--create table snb_delivery.ferenec_funnel_phoenix as
insert into snb_delivery.ferenec_funnel_phoenix
with event_1 as (
    select item_id,
           contact_phone_pd_id,
           min(created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow') as created
    from snb_delivery.ferenec_raw_first_step_phoenix
    where contact_phone_pd_id is not null
    group by 1, 2
),

     calendar as (
         select calday::timestamp as contact_phone_created
         from snb_delivery.logdata_calendar
            where calday between '2022-01-01' and current_date
     ),

     event_utm as (
         select item_id,
                utm_campaign,
                utm_medium,
                utm_source,
                utm_content,
                utm_term,
                 contact_phone_pd_id as contact_phone_pd_id
         from snb_delivery.ferenec_raw_first_step_phoenix
         where True
           and utm_source is not null
     ),
     event_coutry as (
         select country,
                city,
                item_id,
                min(created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow') as created
         from snb_delivery.ferenec_raw_first_step_phoenix
         where kind = 'company_info_form_request'
         group by 1, 2, 3
     ),
     event_2 as (
         select item_id,
                corp_client_id,
                min(created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow') as created
         from snb_delivery.ferenec_raw_first_step_phoenix
         where kind = 'company_created_notification'
         group by 1, 2
     ),
     event_crm_raw as (
         select item_id,
                deal_id,
                org_id,
                created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow' as created,
             max(created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow') over (partition by item_id) as last_created
         from snb_delivery.ferenec_raw_first_step_phoenix
         where item_id is not null
     ),
     event_crm as (
         select item_id,
                deal_id,
                org_id,
                created
         from event_crm_raw
         where last_created = created
     ),
     amo_crm as (
        select lead_id,
               company_id,
               external_event_id,
               utc_lead_created_dttm,
               pd_deal_id,
               pd_org_id
        from snb_b2b.amo_leads_info
        where True
            and phoenix_flg
    ),
     event_3 as (
         select item_id,
                yandex_uid                                                    as y_uid,
                kind                                                           as card,
                min(created::timestamp at time zone 'UTC' at time zone 'Europe/Moscow') as created
         from snb_delivery.ferenec_raw_first_step_phoenix
         where kind = 'card_bound_notification'
         group by 1, 2, 3
     ),
     partition_claim as (
         select c.corp_client_id,
                cargo_ref_id,
                l.utc_created_dttm + interval '3 hours'                                           as utc_order_created_dttm,
                min(l.utc_created_dttm + interval '3 hours')
                over (partition by l.corp_client_id)                                              as utc_first_order_dttm,
                row_number() over (partition by c.corp_client_id order by l.utc_created_dttm)     as rnb
         from delivery_ods_cargo_claims.claim c
                  inner join delivery_ods_cargo_claims.claim_status_log l using (claim_id)
         where l.utc_created_dttm >= '2021-10-01'
           and c.utc_created_dttm >= '2021-10-01'
           and new_claim_status = 'accepted'
           and c.corp_client_id is not null
           and l.corp_client_id is not null
           and status_code in ('delivered_finish')
           and c.corp_client_id in (select distinct corp_client_id from snb_delivery.ferenec_raw_first_step_phoenix)
     ),
     claim_all_agregation as (
         select corp_client_id,
                min(utc_first_order_dttm)                               as utc_first_order_dttm,
                bool_or(rnb = 2)                                        as flg_second_deliveries,
                bool_or(rnb = 10)                                       as flg_10_deliveries,
                max(case when rnb = 2 then utc_order_created_dttm end)  as dttm_second_deliveries,
                max(case when rnb = 10 then utc_order_created_dttm end) as dttm_tenth_deliveries
         from partition_claim
         group by corp_client_id
     ),
     raw_funnel as (
         select e1.item_id                                                                as item_id,
                e1.contact_phone_pd_id                                                    as contact_phone_pd_id,
                e1.created                                                                as contact_phone_created,
                case when eu.utm_source is not null then eu.utm_source else 'organic' end as utm_source,
                eu.utm_medium                                                             as utm_medium,
                eu.utm_campaign                                                           as utm_campaign,
                eu.utm_term                                                               as utm_term,
                eu.utm_content                                                            as utm_content,
                e2.corp_client_id                                                         as corp_client_id,
                ec.created                                                                as corp_client_id_created,
                ec.country                                                                as country,
                ec.city                                                                   as city,
                crm.org_id                                                                as org_id,
                crm.deal_id                                                               as deal_id,
                case when a1.lead_id is not null
                    then a1.lead_id
                    else a2.lead_id end                                                   as lead_id,
                case when a1.company_id is not null
                    then a1.company_id
                    else a2.company_id end                                                as company_id,
                case when a1.external_event_id is not null
                    then a1.utc_lead_created_dttm
                    else e3.created  end                                                  as crm_created,
                e3.created                                                                as card_created,
                e3.y_uid,
                o.utc_first_order_dttm                                                    as first_order,
                o.flg_second_deliveries                                                   as flg_second_deliveries,
                o.flg_10_deliveries                                                       as flg_10_deliveries,
                o.dttm_second_deliveries                                                  as dttm_second_deliveries,
                o.dttm_tenth_deliveries                                                   as dttm_tenth_deliveries
         from event_1 as e1
                  left join event_utm as eu
                            on e1.item_id = eu.item_id and e1.contact_phone_pd_id = eu.contact_phone_pd_id
                  left join event_2 as e2
                            on e1.item_id = e2.item_id and e1.created <= e2.created
                  left join event_coutry as ec
                            on e2.item_id = ec.item_id
                  left join event_crm as crm
                            on e1.item_id = crm.item_id
                  left join amo_crm as a1
                            on e1.item_id = a1.external_event_id
                  left join amo_crm as a2
                            on crm.deal_id::int = a2.pd_deal_id and crm.org_id::int = a2.pd_org_id
                  left join event_3 as e3
                            on e3.item_id = e2.item_id and e2.created <= e3.created
                  left join claim_all_agregation as o
                            on o.corp_client_id = e2.corp_client_id and o.utc_first_order_dttm >= e1.created)
select contact_phone_pd_id,
       item_id,
       contact_phone_created,
       utm_source,
       utm_medium,
       utm_campaign,
       utm_content,
       utm_term,
       corp_client_id,
       corp_client_id_created,
       deal_id,
       org_id,
       country,
       city,
       crm_created,
       lead_id,
       company_id,
       y_uid,
       card_created,
       first_order,
       flg_second_deliveries,
       flg_10_deliveries,
       dttm_second_deliveries,
       dttm_tenth_deliveries
from raw_funnel
where contact_phone_created >= '2021-10-01'
union all
select null as contact_phone_pd_id,
       null as item_id,
       contact_phone_created,
       null utm_source,
       null utm_medium,
       null utm_campaign,
       null utm_term,
       null utm_content,
       null corp_client_id,
       null corp_client_id_created,
       null deal_id,
       null org_id,
       null country,
       null city,
       null crm_created,
       null lead_id,
       null company_id,
       null y_uid,
       null card_created,
       null first_order,
       null flg_second_deliveries,
       null flg_10_deliveries,
       null dttm_second_deliveries,
       null dttm_tenth_deliveries
from calendar;

--select 2+2;

--drop table snb_b2b.ferenec_funnel_phoenix_nrvn CASCADE;

-- create view snb_delivery.ferenec_funnel_phoenix_nrvn as
--     (select * from snb_b2b.ferenec_funnel_phoenix_nrvn);

grant all on snb_delivery.ferenec_funnel_phoenix to "robot-log-analytics";

grant all on snb_delivery.ferenec_funnel_phoenix to "robot-taxi-stat";