use hahn;

pragma yson.DisableStrict;
pragma yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

--drop table `//home/taxi-delivery/analytics/production/b2b/phoenix/raw_for_funnel_phoenix`;

insert into `//home/taxi-delivery/analytics/production/b2b/phoenix/raw_for_funnel_phoenix` with truncate
select item_id,
    created,
    due,
    order_key,
    queue,
    Yson::ConvertToString(Yson::ParseJson(payload).data.form_pd.contact_phone_pd_id) as contact_phone_pd_id,
    Yson::ConvertToString(Yson::ParseJson(payload).data.fail_reason.code) as fail_code,
    Yson::ConvertToString(Yson::ParseJson(payload).data.phoenix_step) as phoenix_step,
    Yson::ConvertToString(Yson::ParseJson(payload).data.corp_client_id) as corp_client_id,
    Yson::ConvertToInt64(Yson::ParseJson(payload).data.pipedrive_account.deal_id)  as deal_id,
    Yson::ConvertToInt64(Yson::ParseJson(payload).data.pipedrive_account.org_id) as org_id,
    Yson::ConvertToString(Yson::ParseJson(payload).kind) as kind,
    Yson::ConvertToDict(Yson::ParseJson(payload).data.form_data.utm_parameters) as utm_data
from hahn.`//home/taxi/production/replica/postgres/processing/events`
where scope = 'cargo'
and queue in (
    'crm_flow_phoenix',  -- основной процесс регистрации
    'crm_flow_phoenixpipe'  -- процесс взаимодействия с пайпом
)
--and created >= '1634892659.212385'
ORDER BY item_id, created;

--drop table `//home/taxi-delivery/analytics/production/b2b/phoenix/phoenix_employees`;

insert into `//home/taxi-delivery/analytics/production/b2b/phoenix/phoenix_employees` with truncate
select corp_client_id,
 BOOL_OR(name = 'Owner'),
  count(DISTINCT name) as cndt_name,
  count(DISTINCT yandex_uid) as cndt_yandex_uid
FROM `//home/taxi/production/replica/postgres/cargo_corp/employees`
where name <> 'Robot for Yandex Balance' and name <> 'Robot for token for API'
and is_disabled = False
and is_removed = False
group by corp_client_id;