use hahn;

pragma yson.DisableStrict;
pragma yt.Pool='taxi-delivery';
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;

--drop table `//home/taxi-delivery/analytics/production/b2b/phoenix/raw_for_funnel_phoenix`;

insert into `//home/taxi-delivery/analytics/production/b2b/phoenix/raw_for_funnel_phoenix` with truncate
select
    Yson::ConvertToString(doc.item_id) as item_id,
    Yson::ConvertToString(doc.created) as created,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.city) as city,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.country) as country,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.phoenix_step) as phoenix_step_str,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.potential_capacity) as potential_capacity,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.corp_client_id) as corp_client_id,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_source)  as utm_source,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_medium)  as utm_medium,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_campaign)  as utm_campaign,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_content)  as utm_content,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_term)  as utm_term,
    Yson::LookupString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_pd,'contact_phone_pd_id') as contact_phone_pd_id,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.pipedrive_account.org_id) as org_id,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.pipedrive_account.deal_id) as deal_id,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).kind) as kind,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.yandex_uid) as yandex_uid
from range(`//home/delivery-dwh/raw/processing/cargo_phoenix_event`, '2021') as pe
where TRUE
