with proc_0 as (
    select *,
           case when kind = 'initial_form_request' then 1
                when phoenix_step = 'company_created_form' then 2
                when kind = 'pipedrive_account_created' then 3
                when phoenix_step = 'card_bound_form' then 4
               end as stage_id,
           row_number() over (partition by item_id,
               case when kind = 'initial_form_request' then 1
                when phoenix_step = 'company_created_form' then 2
                when kind = 'pipedrive_account_created' then 3
                when phoenix_step = 'card_bound_form' then 4
               end
               order by created desc    -- последний по created
               ) as rn
    from snb_taxi.ferenec_raw_first_step_phoenix
)
, proc as (
    select item_id,
           -- 1
           to_timestamp(max(case when stage_id = 1 then created end)) at time zone 'Europe/Moscow' as contact_phone_created,
           -- 2
           to_timestamp(max(case when stage_id = 2 then created end)) at time zone 'Europe/Moscow' as corp_client_id_created,
           max(case when stage_id = 2 then corp_client_id end) as corp_client_id,
           -- 3
           to_timestamp(max(case when stage_id = 3 then created end)) at time zone 'Europe/Moscow' as crm_created,
           max(case when stage_id = 3 then org_id end) as org_id,
           max(case when stage_id = 3 then deal_id end) as deal_id,
           -- 4
           to_timestamp(max(case when stage_id = 4 then created end)) at time zone 'Europe/Moscow' as card_created
    from proc_0
    where stage_id is not null
      and rn = 1
    group by item_id
)
, dlv0 as (
    select corp_client_id,
           utc_order_created_dttm,
           (min(utc_order_created_dttm) over (partition by corp_client_id)) as utc_first_order_dttm
    from taxi_cdm_marketplace.fct_order
    where utc_order_created_dttm >= '2021-09-01'
      and success_order_flg
      and corp_order_flg
      and (tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
        or (tariff_class_code = 'ubernight' and utc_order_created_dttm >= '2021-09-01'))
      and not mqc_order_flg
      and not fake_order_flg
)
, dlv as (
    select corp_client_id,
           min(utc_first_order_dttm)                                                      as utc_first_order_dttm,
           sum((utc_order_created_dttm < utc_first_order_dttm + interval '1 month')::int) as cnt_first_month_order,
           bool_or(utc_order_created_dttm >= utc_first_order_dttm + interval '1 month')   as second_month_order
    from dlv0
    group by corp_client_id
)
select item_id, contact_phone_created, corp_client_id_created, corp_client_id, crm_created, org_id, deal_id, card_created,
       utc_first_order_dttm, cnt_first_month_order, second_month_order
from proc left join dlv using (corp_client_id);