--drop table if exists snb_delivery.phoenix_dashboard_delivery;
--create table snb_delivery.phoenix_dashboard_delivery as
truncate table snb_delivery.phoenix_dashboard_delivery;
insert into snb_delivery.phoenix_dashboard_delivery
with client_creation as (
    select corp_client_id,
           min(corp_client_id_created at time zone 'Europe/Moscow')::date as corp_client_id_created
    from snb_delivery.ferenec_funnel_phoenix
    where corp_client_id is not null
    group by corp_client_id
    having min(corp_client_id_created) >= '2021-12-01'
),
     utm as (
         select distinct corp_client_id, utm_source, utm_medium, utm_campaign
         from snb_delivery.ferenec_funnel_phoenix
         where corp_client_id is not null
     ),
     country as (
         select distinct corp_client_id, country
         from snb_delivery.ferenec_funnel_phoenix
         where country is not null
     )
        ,
     statlog as (
         select claim_id,
                (min(utc_created_dttm) at time zone 'UTC' at time zone 'Europe/Moscow')::date as day_order
         from delivery_ods_cargo_claims.claim_status_log l
                  join client_creation e on e.corp_client_id = l.corp_client_id
         where utc_created_dttm >= '2021-11-06'
      and new_claim_status = 'accepted'
         group by claim_id
     )
        ,
     claims as (
         select c.corp_client_id,
                date_trunc('day', utc_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')                                                 as day_order,
                api_source_type,
                fcm.currency_code as currency_code,
                fcm.tariff_class_code                                                          as tariff_class_code,
                count(distinct claim_id)    ::bigint                                                   as cnt_all_claims,
                count(distinct case when status_code = 'delivered_finish' then claim_id end)::bigint as cnt_delivered_finish,
                sum(fcm.gmv_amt)::double precision as sum_gmv_amt,
                sum(fcm.net_inflow_total_amt)::double precision as sum_net_inflow_total_amt
         from delivery_ods_cargo_claims.claim c
                  --join statlog using (claim_id)
                    left join taxi_cdm_marketplace.fct_order_metric fcm on fcm.order_id = c.taxi_order_id
         where true
           and c.utc_created_dttm >= '2021-11-06'
      and True
         and fcm.utc_order_created_dttm >= '2021-11-01'
         group by 1, 2, 3, 4, 5
     )
select corp_client_id,
       corp_client_id_created,
       day_order,
       api_source_type,
       tariff_class_code,
       currency_code,
       cnt_all_claims,
       cnt_delivered_finish,
       sum_gmv_amt,
       sum_net_inflow_total_amt,
       country,
       utm_source,
       utm_medium,
       utm_campaign
from client_creation
         left join claims using (corp_client_id)
         left join utm using (corp_client_id)
         left join country using (corp_client_id)

