truncate table snb_delivery.phoenix_dashboard_histogram_corp_client;
insert into snb_delivery.phoenix_dashboard_histogram_corp_client
--create table snb_delivery.phoenix_dashboard_histogram_corp_client as
with event_2 as
         (
             select
                    corp_client_id,
                    corp_client_id_created,  utm_source, utm_medium, utm_campaign
             from snb_delivery.ferenec_funnel_phoenix
             where corp_client_id is not null
         ),
partition_fct_order as (
         select c.corp_client_id,  utm_source, utm_medium, utm_campaign,
                cargo_ref_id,
                corp_client_id_created,
                status_code,
                l.utc_created_dttm + interval '3 hours' as msс_order_created_dttm
         from delivery_ods_cargo_claims.claim c
         inner join delivery_ods_cargo_claims.claim_status_log l using (claim_id)
         inner join event_2 e on e.corp_client_id = c.corp_client_id
         where l.utc_created_dttm >= '2021-11-06'
           and c.utc_created_dttm >= '2021-11-06'
           and  corp_client_id_created >= '2021-12-01'
           and new_claim_status = 'accepted'
           and c.corp_client_id is not null
           and l.corp_client_id is not null
           --and status_code = 'delivered_finish'
           --and c.api_source_type = 'phoenix_web'
),
delivery as (
    select corp_client_id,  utm_source, utm_medium, utm_campaign,
           cargo_ref_id,
           corp_client_id_created,
           msс_order_created_dttm,
           bool_or(status_code = 'delivered_finish') as delivered_finish
from partition_fct_order
group by 1, 2, 3, 4, 5, 6, 7)

select corp_client_id,  utm_source, utm_medium, utm_campaign,
       corp_client_id_created,
       date_trunc('week', msс_order_created_dttm) as week_order,
       count (distinct cargo_ref_id) as cnt_all_claims,
       count (distinct case when delivered_finish then cargo_ref_id end) as cnt_delivered_finish
from delivery
group by 1, 2, 3, 4, 5, 6
order by 1, 2, 3, 4, 5, 6