--create table snb_delivery.phoenix_dashboard_step_by_step as
truncate table snb_delivery.phoenix_dashboard_step_by_step;
insert into snb_delivery.phoenix_dashboard_step_by_step
with event_step as (
    select item_id, contact_phone_created as created,  '1. contact phone'::text as step
    from snb_delivery.ferenec_funnel_phoenix

union all

select item_id, corp_client_id_created as created, '2. company info'::text as step
from snb_delivery.ferenec_funnel_phoenix
where corp_client_id_created is not null

union all

select item_id, card_created as created, '3. payment'::text as step
from snb_delivery.ferenec_funnel_phoenix
where card_created is not null

union all

select item_id, first_order as created, '4. first_order'::text as step
from snb_delivery.ferenec_funnel_phoenix
where first_order is not null

union all

select item_id, dttm_second_deliveries as created, '5. second_order'::text as step
from snb_delivery.ferenec_funnel_phoenix
where dttm_second_deliveries is not null

union all

select item_id, dttm_tenth_deliveries as created, '6. tenth_order'::text as step
from snb_delivery.ferenec_funnel_phoenix
where dttm_tenth_deliveries is not null)

select es.*,
       fp.utm_source as utm_source,
       fp.utm_medium as utm_medium,
       fp.utm_campaign as utm_campaign,
       fp.country as country,
       fp.utm_content as utm_content,
       fp.utm_term as utm_term
from event_step as es
left join snb_delivery.ferenec_funnel_phoenix as fp
    on es.item_id = fp.item_id;

--drop table snb_delivery.phoenix_dashboard_step_by_step;