use hahn;

pragma yson.DisableStrict;
--pragma yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

--drop table `//home/taxi-delivery/analytics/production/b2b/phoenix/raw_for_funnel_phoenix`;

--insert into `//home/taxi-delivery/analytics/production/b2b/phoenix/tmp_raw_for_funnel_phoenix` with truncate
select select
    Yson::ConvertToString(doc.item_id) as item_id,
    Yson::ConvertToString(doc.created) as created,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.city) as city,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.country) as country,
    Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.phoenix_step as phoenix_step_str,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.potential_capacity) as potential_capacity,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.corp_client_id) as corp_client_id,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_source)  as utm_source,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_medium)  as utm_medium,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.utm_parameters.utm_campaign)  as utm_campaign,
    Yson::LookupString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_pd,'contact_phone_pd_id') as contact_phone_pd_id,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.pipedrive_account.org_id) as org_id,
    Yson::ConvertToInt64(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.pipedrive_account.deal_id) as deal_id,
    Yson::ParseJson(Yson::ConvertToString(doc.payload)).kind as kind,
    Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(doc.payload)).data.form_data.yandex_uid) as yandex_uid

from `//home/taxi-dwh/raw/processing/cargo_phoenix_event/2022`
)
--and created >= '1634892659.212385'
ORDER BY item_id, created;

--drop table `//home/taxi-delivery/analytics/production/b2b/phoenix/phoenix_employees`;

-- insert into `//home/taxi-delivery/analytics/production/b2b/phoenix/phoenix_employees` with truncate
-- select corp_client_id,
--  BOOL_OR(name = 'Owner'),
--   count(DISTINCT name) as cndt_name,
--   count(DISTINCT yandex_uid) as cndt_yandex_uid
-- FROM `//home/taxi/production/replica/postgres/cargo_corp/employees`
-- where name <> 'Robot for Yandex Balance' and name <> 'Robot for token for API'
-- and is_disabled = False
-- and is_removed = False
-- group by corp_client_id;