--LOGDATA-2232
drop table if exists finish_measure;
create temporary table finish_measure as
with dlv_raw as (
    select corp_contract_id,
           msk_order_created_dt,
           sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order
    where utc_order_created_dttm >= '2021-12-31'
      and msk_order_created_dt between '2022-01-01' and current_date-1
      and delivery_point_cnt > 0
      and corp_contract_id is not null
    group by 1, 2
)
-- , dlv_cntr as (
--     select corp_contract_id,
--            msk_order_created_dt as calday,
--            sum(deliveries_cnt) as deliveries_cnt
--     from dlv_raw
--     group by 1,2
-- )
, blnc as (
    select contract_external_id,
           case when contract_type = 'Договор-оферта' then min_payment_date_v2
                when payment_type = 'предоплата' then start_dt
                else least(signed_dt, faxed_dt, booked_dt)
            end as activated_dt
    from snb_b2b.niksm_b2b_balance_contract_ext_info
    where case when contract_type = 'Договор-оферта' then min_payment_date_v2
                when payment_type = 'предоплата' then start_dt
                else least(signed_dt, faxed_dt, booked_dt)
            end >= '2022-01-01'
)
   , dlv_cntr as (
    select contract_external_id as contract_id,
           max(activated_dt) as calday,
--            coalesce(msk_order_created_dt,activated_dt) as calday,
           1::int as new_contract_activation,
--            max(case when coalesce(msk_order_created_dt, activated_dt)=activated_dt and contract_external_id is not null then 1 else 0 end) as new_contract_activation,
  sum(case when msk_order_created_dt between  activated_dt and activated_dt+6
           then deliveries_cnt else 0 end) as deliveries_cnt_7d,
  sum(case when msk_order_created_dt between  activated_dt and activated_dt+29
                    then deliveries_cnt else 0 end) as deliveries_cnt_30d

--            sum(case when msk_order_created_dt between  activated_dt and activated_dt+30
--                     then deliveries_cnt else 0 end) as deliveries_cnt
    from blnc
    left join dlv_raw  on dlv_raw.corp_contract_id = blnc.contract_external_id
    group by 1
)


, un_base as (
    select corp_contract_id as contract_id,
           msk_order_created_dt as calday,
           0::int as new_contract_activation,
           0::bigint as new_contract_deliveries,
           0::bigint as new_contract_deliveries_30d,
           deliveries_cnt
    from dlv_raw
    union all
    select  contract_id,
            calday,
            new_contract_activation,
            coalesce(deliveries_cnt_7d, 0::bigint) new_contract_deliveries,
--     sum(coalesce(deliveries_cnt_7d, 0::bigint)) over(partition by contract_id  order by calday::date range between CURRENT ROW and 6 FOLLOWING) new_contract_deliveries,
             coalesce(deliveries_cnt_30d, 0::bigint) new_contract_deliveries_30d,
--             sum(coalesce(deliveries_cnt_30d, 0::bigint)  over(partition by contract_id order by calday::date range between CURRENT ROW and 30 FOLLOWING) new_contract_deliveries_30d,
--          coalesce(deliveries_cnt, 0::bigint) as new_contract_deliveries,
           0::bigint as deliveries_cnt
    from dlv_cntr


)
, cntr_act_dlv as (
    select contract_id,
           calday,
           sum(new_contract_activation) as new_contract_activation,
           sum(new_contract_deliveries) as new_contract_deliveries,
           sum(deliveries_cnt)          as deliveries_cnt,
           sum(new_contract_deliveries_30d) as new_contract_deliveries_30d
    from un_base
    group by 1, 2
)

--   select *
--   from  cntr_act_dlv
-- where contract_id='3008440/22'
--  ;
, tasks_deal as (
select entity_id                                                                  as deal_id,
                  task_type_id,
                  case
                      when task_type_id = 1 then 'Связаться'
                      when task_type_id = 2 then 'Встреча'
                      when task_type_id = 2486197 then 'Эл. почта'
                      when task_type_id = 2486200 then 'На контроле'
                      when task_type_id = 2486203 then 'Задание'
                      when task_type_id = 2486206 then 'Ждем договор'
                      when task_type_id = 2486209 then 'Передать контакт'
                      when task_type_id = 2486212 then 'Чек доставок'
                      when task_type_id = 2486215 then 'Контроль оплаты'
                      when task_type_id = 2486218 then 'Проверка скоринг'
                      when task_type_id = 2486221 then 'Отток'
                      when task_type_id = 2486224 then 'Гигфильтры в CRM'
                      when task_type_id = 2501971 then 'Холодный звонок'
                      when task_type_id = 2503027 then 'Арбитраж'
                      else 'others' end                                                      as task_type_name,
                  ((utc_updated_dttm at time zone 'UTC') at time zone 'Europe/Moscow')::date as calday,
                  (utc_created_dttm at time zone 'UTC') at time zone 'Europe/Moscow'         as created_at,
                  (utc_updated_dttm at time zone 'UTC') at time zone 'Europe/Moscow'         as updated_at,
                  (utc_deadline_dttm at time zone 'UTC') at time zone 'Europe/Moscow'        as deadline_at,
                  task_id                                                                    as id,
                  responsible_user_id,
                  1 as cnt_task

           from delivery_ods_amocrm.task
           where entity_type = 'leads'
             and completed_flg
             and task_type_id in (1, 2,2486197 )

-- select
-- (data -> 0 ->> 'entity_id')::bigint                                                           as deal_id,
-- case
--     when data -> 0 ->> 'task_type_id' = '1' then 'Связаться'
--     when data -> 0 ->> 'task_type_id' = '2' then 'Встреча'
--     when data -> 0 ->> 'task_type_id' = '2486197' then 'Эл. почта'
--     when data -> 0 ->> 'task_type_id' = '2486200' then 'На контроле'
--     when data -> 0 ->> 'task_type_id' = '2486203' then 'Задание'
--     when data -> 0 ->> 'task_type_id' = '2486206' then 'Ждем договор'
--     when data -> 0 ->> 'task_type_id' = '2486209' then 'Передать контакт'
--     when data -> 0 ->> 'task_type_id' = '2486212' then 'Чек доставок'
--     when data -> 0 ->> 'task_type_id' = '2486215' then 'Контроль оплаты'
--     when data -> 0 ->> 'task_type_id' = '2486218' then 'Проверка скоринг'
--     when data -> 0 ->> 'task_type_id' = '2486221' then 'Отток'
--     when data -> 0 ->> 'task_type_id' = '2486224' then 'Гигфильтры в CRM'
--     when data -> 0 ->> 'task_type_id' = '2501971' then 'Холодный звонок'
--     when data -> 0 ->> 'task_type_id' = '2503027' then 'Арбитраж'
--     else 'others' end                                                              as task_type_name,
-- data -> 0 -> 'task_type_id'                                                        as task_type_id,
-- to_timestamp((data->0->>'updated_at')::bigint) at time zone 'UTC',
-- ((to_timestamp((data->0->>'updated_at')::bigint) at time zone 'UTC') at time zone 'Europe/Moscow')::date as calday,
-- (to_timestamp((data->0->>'created_at')::bigint) at time zone 'UTC') at time zone 'Europe/Moscow'         as created_at,
-- (to_timestamp((data->0->>'updated_at')::bigint) at time zone 'UTC') at time zone 'Europe/Moscow'         as updated_at,
-- (to_timestamp((data->0->>'complete_till')::bigint) at time zone 'UTC') at time zone 'Europe/Moscow'        as deadline_at,
-- data -> 0 ->> 'id'                                                                  as id,
--   (data->0->>'responsible_user_id')::bigint as responsible_user_id,
--            1 as cnt_task
--
--            from snb_b2b.voytekh_amo_tasks
--            where data -> 0 ->> 'entity_type' = 'leads'
--            and (data -> 0 ->> 'completed_flg')::boolean=true
--            and (data -> 0 ->> 'task_type_id')::bigint in (1, 2,2486197)
)

, fin as (select crm.manager_metagroup,
                 crm.manager_group,
                 crm.manager_login,
                 crm.user_name as manager_name,
                 calday,
--                  new_contract_flg,
--                  case when new_contract_flg=1 then cntr_act_dlv.contract_id  else null end as contract_id,
                 date_trunc('week', calday)::date  as calweek,
                 date_trunc('month', calday)::date as calmonth,
                 sum(case
                         when pipeline_name in ('ХОЛОД','ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ') then new_contract_activation
                         else 0 end)               as new_contract_activation,
                 sum(case
                         when pipeline_name in ('ХОЛОД','ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ') then new_contract_deliveries
                         else 0 end)               as new_contract_deliveries,
               sum(case
                         when pipeline_name in ('ХОЛОД','ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ') then new_contract_deliveries_30d
                         else 0 end)               as new_contract_deliveries_30d,
                 sum(deliveries_cnt)               as deliveries_cnt,
                 null                              as cnt_meetings,
                 null                              as cnt_calls,
                 null                              as cnt_emails
          from snb_b2b.amo_leads_info crm
                  left join cntr_act_dlv
                        on cntr_act_dlv.contract_id = crm.contract_id
          where true
          group by 1, 2, 3, 4, 5

          union all
            select
            null as manager_metagroup,
            null  as manager_group,
            resp.user_login as manager_login,
            null as manager_name,
            calday,
--             0::int as new_contract_flg,
--             null::text as contract_id,
            date_trunc('week', calday)::date  as calweek,
            date_trunc('month', calday)::date as calmonth,
            null  as new_contract_activation,
            null  as new_contract_deliveries,
            null  as  new_contract_deliveries_30d,
            null as deliveries_cnt,
            sum(case when task_type_name = 'Встреча' then cnt_task else 0 end)   as cnt_meetings,
            sum(case when task_type_name = 'Связаться' then cnt_task else 0 end) as cnt_calls,
            sum(case when task_type_name = 'Эл. почта' then cnt_task else 0 end) as cnt_emails
            from  snb_b2b.amo_leads_info aml
            join tasks_deal as tt on tt.deal_id = aml.lead_id
            join delivery_ods_amocrm.user resp on tt.responsible_user_id=resp.user_id
--             left join ( select manager_metagroup,
--                                 manager_group,
--                                 manager_login,
--                                 manager_name
--                                     from snb_b2b.amo_leads_info
--                                      group by 1,2,3,4) aml_m on resp.user_login=aml_m.manager_login
            where aml.pipeline_name in ('ХОЛОД','ПОДКЛЮЧЕНИЕ', 'ЗАПУСК И РАЗВИТИЕ')
            group by 1,2,3,4,5)

select max(manager_metagroup) manager_metagroup,max(manager_group) manager_group,manager_login, max(manager_name)manager_name ,
                 calday, calweek, calmonth,
-- new_contract_flg, contract_id,
                 sum(new_contract_activation) as new_contract_activation,
sum(new_contract_deliveries) as new_contract_deliveries,
sum(new_contract_deliveries_30d) as new_contract_deliveries_30d,
sum(deliveries_cnt) as deliveries_cnt,
sum(cnt_meetings) as  cnt_meetings,
sum(cnt_calls) as  cnt_calls,
sum(cnt_emails) as  cnt_emails
from fin
 where calday>='2022-01-01'
--    and  manager_login='zolotarev-i'
--  and calday between '2022-05-01' and '2022-05-31'
group by 3,5,6,7
       ;
drop table if exists snb_b2b.sales_manager_action_report;
create table snb_b2b.sales_manager_action_report as
-- truncate table snb_b2b.sales_manager_action_report;
-- insert into  snb_b2b.sales_manager_action_report
with finish_manager as (
        select
           coalesce(resp.manager_metagroup,aml_m.manager_metagroup) manager_metagroup,
           coalesce(resp.manager_group,aml_m.manager_group) as manager_group,
           resp.manager_login,
           coalesce(resp.manager_name,aml_m.manager_name) as manager_name ,
 calday, calweek, calmonth,
new_contract_activation,
 new_contract_deliveries,
 new_contract_deliveries_30d,
deliveries_cnt,
 cnt_meetings,
cnt_calls,
cnt_emails
       from finish_measure resp
       left join (
           select user_login as manager_login,user_name as manager_name,usr.user_group_name, manager_group, manager_metagroup
            from delivery_ods_amocrm.user usr
            left join (
            select user_group_name
                 , max(manager_group) manager_group
                 , max(manager_metagroup)manager_metagroup
            from snb_b2b.amo_leads_info
            group by user_group_name
            ) aml on aml.user_group_name=usr.user_group_name
       ) aml_m on resp.manager_login=aml_m.manager_login
--        left join (select manager_metagroup, manager_group,
--                                 manager_login,
--                                 manager_name,user_name,
--                                 row_number() over (partition by manager_login order by utc_lead_created_dttm desc) as rn
--                                     from snb_b2b.amo_leads_info
--                                     ) aml_m on resp.manager_login=aml_m.manager_login and rn=1
--        left join (select login as manager_login, 'Тир 3' as manager_metagroup, 'Телемаркетинг' as manager_group
--                     from snb_b2b.voytekh_manager_v2
--                     where true
--                       and json_typeof(ancestors) = 'array'
--                       and array(select json_array_elements_text(ancestors)) && array ['outstaff_2289_dep60996_dep82934_dep83164']
--  )tm on resp.manager_login=tm.manager_login
)
, manager_table_date as (select manager_metagroup,
                                manager_group,
                                manager_login,
                                manager_name,
                                calday,
                                calweek,
                                calmonth,
                                new_contract_activation,
                                new_contract_deliveries,
                                 new_contract_deliveries_30d,
                                deliveries_cnt,
                                cnt_meetings,
                                cnt_calls,
                                cnt_emails,
                                'current' as flg_per
                         from finish_manager
                         union all
                         select manager_metagroup,
                                manager_group,
                                manager_login,
                                manager_name,
                                calday + 7                            as calday,
                                date_trunc('week', calday + 7)::date  as calweek,
                                date_trunc('month', calday + 7)::date as calmonth,
                                new_contract_activation,
                                new_contract_deliveries,
                                 new_contract_deliveries_30d,
                                deliveries_cnt,
                                cnt_meetings,
                                cnt_calls,
                                cnt_emails,
                                'last_week'                           as flg_per
                         from finish_manager

                         union all
                         select manager_metagroup,
                                manager_group,
                                manager_login,
                                manager_name,
                                (calday + interval '1 mon')::date                            as calday,
                                date_trunc('week', (calday + interval '1 mon')::date)::date  as calweek,
                                date_trunc('month', (calday + interval '1 mon')::date)::date as calmonth,
                                new_contract_activation,
                                new_contract_deliveries,
                                 new_contract_deliveries_30d,
                                deliveries_cnt,
                                cnt_meetings,
                                cnt_calls,
                                cnt_emails,
                                'last_month'                                                 as flg_per
                         from finish_manager
                         )
select *
from manager_table_date
where calday<=current_date-1
;
----------------------------------------------------------