--LOGDATA-2444
drop table if exists tasks_data;
create temporary table tasks_data as
with tasks_deal as (
select entity_id                                                                  as deal_id,
                  task_type_id,
                  case
                      when task_type_id = 1 then 'Связаться'
                      when task_type_id = 2 then 'Встреча'
                      when task_type_id = 2486197 then 'Эл. почта'
                      when task_type_id = 2486200 then 'На контроле'
                      when task_type_id = 2486203 then 'Задание'
                      when task_type_id = 2486206 then 'Ждем договор'
                      when task_type_id = 2486209 then 'Передать контакт'
                      when task_type_id = 2486212 then 'Чек доставок'
                      when task_type_id = 2486215 then 'Контроль оплаты'
                      when task_type_id = 2486218 then 'Проверка скоринг'
                      when task_type_id = 2486221 then 'Отток'
                      when task_type_id = 2486224 then 'Гигфильтры в CRM'
                      when task_type_id = 2501971 then 'Холодный звонок'
                      when task_type_id = 2503027 then 'Арбитраж'
                      else 'others' end                                                      as task_type_name,
                  case when completed_flg then
                  ((utc_updated_dttm at time zone 'UTC') at time zone 'Europe/Moscow')::date
                      else ((utc_deadline_dttm at time zone 'UTC') at time zone 'Europe/Moscow')::date  end as calday,
                  (utc_created_dttm at time zone 'UTC') at time zone 'Europe/Moscow'         as created_at,
                  (utc_updated_dttm at time zone 'UTC') at time zone 'Europe/Moscow'         as updated_at,
                  (utc_deadline_dttm at time zone 'UTC') at time zone 'Europe/Moscow'        as deadline_at,
                  task_id                                                                    as id,
                  responsible_user_id,
                  completed_flg,
                  1 as cnt_task
           from delivery_ods_amocrm.task
           where entity_type = 'leads'
--              and completed_flg
--              and task_type_id in (1, 2,2486197 )
)
select      resp.user_login as manager_login, max(resp.user_name) as user_name,
            calday,
            date_trunc('week', calday)::date  as calweek,
            date_trunc('month', calday)::date as calmonth,
            sum(case when task_type_name = 'Встреча' and completed_flg then cnt_task else 0 end)   as cnt_meetings,
            sum(case when task_type_name = 'Связаться' and completed_flg then cnt_task else 0 end) as cnt_calls,
            sum(case when task_type_name = 'Эл. почта' and completed_flg then cnt_task else 0 end) as cnt_emails,
            sum(case when deadline_at>updated_at then cnt_task else 0 end) as cnt_overdue
            from  snb_b2b.amo_leads_info aml
            join tasks_deal as tt on tt.deal_id = aml.lead_id
            join delivery_ods_amocrm.user resp on tt.responsible_user_id=resp.user_id
            where aml.lead_deleted_flg=false
group by resp.user_login,calday
;
------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------

drop table if exists ndd_deliveries;
CREATE TEMPORARY TABLE ndd_deliveries as
select corp_contract_id,
       'NDD'::varchar as tariff_class_code,
       first_day as calday,
       count (distinct request_id) as deliveries_cnt
from
    (
        select distinct
            request_id,
            lk.corp_contract_id,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from snb_delivery.logdata_ndd_requests_datamart a
          left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
            on a.delivery_region = geo.geobase_id
          left join snb_b2b.dbcorp_client_info lk
            on lk.corp_client_id = a.corp_client_id
        where true
          and mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
          and tech_event_instant_ddtm::date <= current_date-1
          and (delivery_country = 'Россия' or delivery_country is null)
    ) ndd
group by 1,3;

drop table if exists points;
CREATE TEMPORARY TABLE points as
select claim_id,
       count(distinct point_id) as deliveries_cnt
from delivery_ods_cargo_claims.claim_point
where utc_created_dttm >='2021-01-01'
  and point_type = 'destination'
  and visit_status = 'visited'
group by claim_id
distributed by (claim_id);

drop table if exists sdd_deliveries;
CREATE TEMPORARY TABLE sdd_deliveries as
select lk.corp_contract_id,
       'SDD'::varchar as tariff_class_code,
       msk_order_created_dt::date as calday,
       sum(deliveries_cnt) as deliveries_cnt
from delivery_ods_cargo_claims.claim
  join points
    on points.claim_id = claim.claim_id
  join taxi_cdm_marketplace.fct_order
    on fct_order.order_id = claim.taxi_order_id
  join snb_b2b.dbcorp_client_info lk
    on claim.corp_client_id = lk.corp_client_id
where true
  and claim.utc_created_dttm >= '2021-01-01'
  and fct_order.utc_order_created_dttm >= '2021-01-01'
  and tariff_class_code = 'night'
  and msk_order_created_dt >='2021-01-01'
group by 1,3;

drop table if exists main_deliveries;
CREATE TEMPORARY TABLE main_deliveries as
select corp_contract_id,
       tariff_class_code,
       msk_order_created_dt::date as calday,
       sum(delivery_point_cnt) as deliveries_cnt
from taxi_cdm_marketplace.fct_order
where true
  and delivery_point_cnt > 0
  ---- 30 days
  and utc_order_created_dttm >='2021-01-01'
  and msk_order_created_dt >='2021-01-01'
  and tariff_class_code <> 'night'
group by 1,2,3;

drop table if exists deliveries;
CREATE TEMPORARY TABLE deliveries as
with raw as (
    select corp_contract_id, tariff_class_code, calday,deliveries_cnt from ndd_deliveries
    union all
    select corp_contract_id, tariff_class_code, calday, deliveries_cnt from sdd_deliveries
    union all
    select corp_contract_id, tariff_class_code, calday, deliveries_cnt from main_deliveries
)
select corp_contract_id,calday,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('courier','express') ) as deliveries_express_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('SDD') ) as deliveries_sdd_cnt,
       sum(deliveries_cnt) filter ( where tariff_class_code in ('NDD') ) as deliveries_ndd_cnt
      , min(case when sum(deliveries_cnt) >0  and corp_contract_id is not null then calday end) over(partition by corp_contract_id) as first_delivery_dt
from raw
group by corp_contract_id,calday
distributed by (corp_contract_id,calday);
-----------------------------------------------


drop table if exists lead_date;
CREATE TEMPORARY TABLE lead_date as
with bal_contr  as (
select bc.*, row_number() over (partition by contract_eid order by dt desc) as rn
from snb_b2b.balance_contracts bc
)
, fin as (select amlh.msk_snapshot_dt - 1                                                                      as calday
               , amlh.lead_id
               , amlh.company_name
               , amlh.manager_login
               , amlh.user_name
               , amlh.pipeline_name
               , amlh.pipeline_status_name
               , amlh.loss_reason_name
               , amlh.channel
               , amlh.market_segment
               , amlh.price
               , amlh.utc_lead_created_dttm::date                                                              as lead_created_dt
               , amlh.contract_id
               , bal_contr.dt                                                                                  as contract_created_dt
             ,coalesce(((amlh.msk_snapshot_dt - 1)=(max(case
                         when amlh.pipeline_name = 'ПОДКЛЮЧЕНИЕ' and amlh.lead_status = 'open' and
                              (coalesce(amlh_yd.pipeline_name, 'ХОЛОД') = 'ХОЛОД' or amlh_yd.lead_status = 'lost')
                             then amlh.msk_snapshot_dt-1 end)
--                          else amlh.utc_lead_created_dttm::date end)
                 over (partition by amlh.lead_id)))::int,0) as create_ld_flg
--                , case
--                      when amlh.pipeline_name = 'ПОДКЛЮЧЕНИЕ' and amlh.lead_status = 'open' and
--                           (coalesce(amlh_yd.pipeline_name, 'ХОЛОД') = 'ХОЛОД' or amlh_yd.lead_status = 'lost')
--                          then 1
--                      else 0 end                                                                                as create_ld_flg
               , case
                     when amlh.pipeline_name = 'ЗАПУСК И РАЗВИТИЕ' and amlh.lead_status = 'open' and
                          (coalesce(amlh_yd.pipeline_name, 'ХОЛОД') in ('ХОЛОД', 'ПОДКЛЮЧЕНИЕ') or
                           amlh_yd.lead_status = 'lost')
                         then 1
                     else 0 end                                                                                as create_contr_flg
               , max(case
                         when amlh.pipeline_name = 'ПОДКЛЮЧЕНИЕ' and amlh.lead_status = 'open' and
                              (coalesce(amlh_yd.pipeline_name, 'ХОЛОД') = 'ХОЛОД' or amlh_yd.lead_status = 'lost')
                             then amlh.msk_snapshot_dt-1 end)
--                          else amlh.utc_lead_created_dttm::date end)
                 over (partition by amlh.lead_id)                                                              as create_lead_dt
               , coalesce(amlh_mn.manager_login, amlh.manager_login)                                           as manager_login_mnth
               , coalesce(amlh_mn.user_name, amlh.user_name)                                                   as user_name_mnth
               , dl.first_delivery_dt
               , dl.deliveries_cnt
               , dl.deliveries_express_cnt
               , dl.deliveries_sdd_cnt
               , dl.deliveries_ndd_cnt
--      , amlh.msk_snapshot_dt-1=utc_lead_created_dttm::date as create_ld_flg
               , amlh.msk_snapshot_dt - 1 = first_delivery_dt                                                  as first_dlv_flg
--      , amlh.msk_snapshot_dt-1=bal_contr.dt as create_contr_flg
               , sum(amlh.price)
                 over ( partition by amlh.company_id,amlh.msk_snapshot_dt - 1)                                 as potention_comp
--       , case when amlh.pipeline_name=amlh_yd.pipeline_name and  amlh.pipeline_status_name=amlh_yd.pipeline_status_name then null else 1 end change_status_flg
--       , min((current_date - amlh.msk_snapshot_dt-1) * (case when amlh.pipeline_name=amlh_yd.pipeline_name and
--                 amlh.pipeline_status_name=amlh_yd.pipeline_status_name then null else 1 end)) over (partition by amlh.lead_id) as time_change_status
               ,
--               ((current_date - amlh.msk_snapshot_dt - 1) =
--                   (min(current_date - amlh.msk_snapshot_dt - 1) over (partition by amlh.lead_id)))::int*
         (min((current_date - amlh.msk_snapshot_dt - 1) * (case
                                                                when amlh.pipeline_name = amlh_yd.pipeline_name
                                                                    and amlh.pipeline_status_name =
                                                                        amlh_yd.pipeline_status_name then null
                                                                else 1 end))
           over (partition by amlh.lead_id))                                                                   as time_change_status
--                , max(case
--                          when amlh.pipeline_name = 'ПОДКЛЮЧЕНИЕ' and amlh.lead_status = 'open' and
--                               (coalesce(amlh.pipeline_name, 'ХОЛОД') = 'ХОЛОД' or amlh_yd.lead_status = 'lost')
--                              then 1
--                          else 0 end)
--                  over (partition by amlh.lead_id,date_trunc('month', amlh.msk_snapshot_dt - 1)::date)          as create_ld_flg_m
--                , case
--                      when amlh.pipeline_status_name = 'Закрыто и не реализовано' then 'Проигранно'
--                      when amlh.pipeline_status_name = 'Закрыто и не реализовано' then 'Проигранно'


          from (select tt.*,
                       (lag(msk_snapshot_dt, 1)
                        over (partition by tt.lead_id order by msk_snapshot_dt)) as msk_snapshot_yd
                from snb_b2b.amo_leads_info_hist tt) AS amlh
                   left join snb_b2b.amo_leads_info_hist AS amlh_yd
                             on amlh.lead_id = amlh_yd.lead_id and amlh.msk_snapshot_yd = amlh_yd.msk_snapshot_dt
                   left join snb_b2b.amo_leads_info_hist amlh_mn
                             on amlh.lead_id = amlh_mn.lead_id
                                 and date_trunc('month', amlh.msk_snapshot_dt - 1)::date = amlh_mn.msk_snapshot_dt
                   left join bal_contr on bal_contr.contract_eid = amlh.contract_id and rn = 1
                   left join deliveries dl
                             on dl.corp_contract_id = amlh.contract_id and dl.calday = amlh.msk_snapshot_dt - 1
-- where msk_snapshot_dt=current_date
          where amlh.lead_deleted_flg = false)

    select calday, lead_id, company_name
         , manager_login, user_name
         , pipeline_name, pipeline_status_name, loss_reason_name,channel
         , market_segment, price
         , lead_created_dt, contract_id
         , contract_created_dt
         , create_ld_flg
         , create_contr_flg
         , create_lead_dt
         , manager_login_mnth
         , user_name_mnth
         , first_delivery_dt
         , deliveries_cnt
         , deliveries_express_cnt
         , deliveries_sdd_cnt
         , deliveries_ndd_cnt
         , first_dlv_flg
         , potention_comp
         , time_change_status
         , max(coalesce(create_ld_flg,0))  over (partition by lead_id,date_trunc('month',calday)::date)   as create_ld_flg_m
         , case  when pipeline_status_name = 'Закрыто и не реализовано' then 'Проигранно'
             when (max(first_dlv_flg::int) over(partition by lead_id order by calday rows between UNBOUNDED PRECEDING AND CURRENT ROW))=1
                         then 'Есть доставки'
             when (max(create_contr_flg::int) over(partition by lead_id order by calday rows between UNBOUNDED PRECEDING AND CURRENT ROW))=1
                         then 'Заключен договор'
                    else 'Переговоры' end as status_convertion
        , case  when pipeline_status_name = 'Закрыто и не реализовано' then 4
             when (max(first_dlv_flg::int) over(partition by lead_id order by calday rows between UNBOUNDED PRECEDING AND CURRENT ROW))=1
                         then 1
             when (max(create_contr_flg::int) over(partition by lead_id order by calday rows between UNBOUNDED PRECEDING AND CURRENT ROW))=1
                         then 2
                    else 3 end as status_convertion_order
         ,case when pipeline_name in ('ХОЛОД') then 1
            when pipeline_name in ('ПОДКЛЮЧЕНИЕ') then 2
            when pipeline_name in ('ЗАПУСК И РАЗВИТИЕ') then 3
            when pipeline_name in ('ФЕНИКС') then 4
            when pipeline_name in ('САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ') then 5
            when pipeline_name in ('DEBT-BRUT','DEBT-LONGIN', 'ДОГОВОРЫ ЯНДЕКС ТАКСИ'
                ,'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ', 'РАСТОРГНУТЫЕ ДОГОВОРЫ') then 7
            else 6 end as pipeline_name_order
    ,case when pipeline_status_name in ('ИДЕЯ (БАЗА ДЛЯ ПРОРАБОТКИ)') then 1
                when pipeline_status_name in ('НАЙТИ КОНТАКТЫ') then 2
                when pipeline_status_name in ('ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ') then 3
                when pipeline_status_name in ('ИЗУЧИТЬ И ЗАБРАТЬ') then 4
                when pipeline_status_name in ('ДОГОВОРИТЬСЯ О ПРЕЗЕНТАЦИИ') then 5
                when pipeline_status_name in ('ПРОВЕСТИ ПРЕЗЕНТАЦИЮ') then 7
                when pipeline_status_name in ('ПЕРЕГОВОРЫ') then 8
                when pipeline_status_name in ('ПРИНЯТО РЕШЕНИЕ') then 9
                when pipeline_status_name in ('ЖДЕМ ДОГОВОР') then 10
                when pipeline_status_name in ('СТАРТ') then 11
                when pipeline_status_name in ('РАЗГОН') then 12
                when pipeline_status_name in ('НОВЫЕ') then 13
                when pipeline_status_name in ('РАЗВИТИЕ') then 14
                when pipeline_status_name in ('УДЕРЖАНИЕ') then 15
                when pipeline_status_name in ('КОНТАКТНЫЕ ДАННЫЕ ПОЛУЧЕНЫ') then 16
                when pipeline_status_name in ('ДАННЫЕ О КОМПАНИИ ПОЛУЧЕНЫ') then 17
                when pipeline_status_name in ('ПЛАТЕЖНЫЕ ДАННЫЕ ПОДТВЕРЖДЕНЫ') then 18
                when pipeline_status_name in ('ОБУЧЕНИЕ ПРОЙДЕНО') then 19
                when pipeline_status_name in ('СОВЕРШЕНА ПЕРВАЯ ДОСТАВКА') then 20
                when pipeline_status_name in ('РАЗВИТИЕ') then 21
                when pipeline_status_name in ('ВАЛИДАЦИЯ') then 22
                when pipeline_status_name in ('БЕЗ МЕНЕДЖЕРА') then 23
                when pipeline_status_name in ('КАНДИДАТЫ НА ВЫХОД') then 24
                when pipeline_status_name in ('ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ') then 25
                when pipeline_status_name in ('Успешно реализовано') then 26
                when pipeline_status_name in ('НА УДАЛЕНИЕ') then 27
                when pipeline_status_name in ('ДОГОВОР ПЕРЕЗАКЛЮЧЕН') then 28
                when pipeline_status_name in ('РАСТОРГНУТ ПО ИНИЦИАТИВЕ КЛИЕНТА') then 29
                when pipeline_status_name in ('РАСТОРГНУТ ПО ИНИЦИАТИВЕ ЯНДЕКСА') then 30
                when pipeline_status_name in ('ОТКЛЮЧЕНА ДОСТАВКА дог. ЯНДЕКС.ТАКСИ') then 31
                when pipeline_status_name in ('Договор не подписан/не акцептован') then 32
                when pipeline_status_name in ('ВРЕМЕННОЕ ХРАНИЛИЩЕ') then 33
                when pipeline_status_name in ('ПЕРЕГОВОРЫ') then 34
                when pipeline_status_name in ('РЕСТРУКТУРИЗАЦИЯ') then 35
                when pipeline_status_name in ('НАЗВАНА ДАТА') then 36
                when pipeline_status_name in ('СКАН-ПРЕДСУД') then 37
                when pipeline_status_name in ('ОРИГИНАЛ ПРЕДСУД') then 38
                when pipeline_status_name in ('ГОСПОШЛИНА В СУД') then 39
                when pipeline_status_name in ('СУД') then 40
                when pipeline_status_name in ('ИСПОЛНИТЕЛЬНОЕ ПРОИЗВОДСТВО') then 41
                when pipeline_status_name in ('ЮЛ ЗАКРЫТО') then 42
                when pipeline_status_name in ('НЕТ КОНТАКТА') then 43
                when pipeline_status_name in ('СПИСАТЬ ДОЛГ') then 44
                when pipeline_status_name in ('ФРОД') then 45
                when pipeline_status_name in ('МАЛЕНЬКИЙ ДОЛГ') then 46
                when pipeline_status_name in ('В ПРОЦЕССЕ ЛИКВИДАЦИИ') then 47
                when pipeline_status_name in ('ЛИД') then 48
                when pipeline_status_name in ('НАЧАЛ ВЗАИМОДЕЙСТВИЕ') then 49
                when pipeline_status_name in ('ВЗЯЛ В РАБОТУ') then 50
                when pipeline_status_name in ('ВЫЯВЛЕН ЛПР') then 51
                when pipeline_status_name in ('ПРЕДОСТАВЛЕНО КП') then 52
                when pipeline_status_name in ('ПРОДАЖА') then 53
                when pipeline_status_name in ('ПРОШЁЛ РЕГИСТРАЦИЮ') then 54
                when pipeline_status_name in ('ПЕРЕДАН В КЛИЕНТСКИЙ СЕРВИС') then 55
                when pipeline_status_name in ('ПРОШЁЛ ОБУЧЕНИЕ') then 56
                when pipeline_status_name in ('ОБУЧЕНИЕ') then 57
                when pipeline_status_name in ('ЗАКАЗ РАЗМЕЩЕН') then 58
                when pipeline_status_name in ('ЗАКРЫТА ПЕРВАЯ СДЕЛКА') then 59
                when pipeline_status_name in ('АДАПТАЦИЯ') then 60
                when pipeline_status_name in ('Проведена первая встреча') then 61
                when pipeline_status_name in ('Представлено КП') then 62
                when pipeline_status_name in ('Подписан NDA') then 63
                when pipeline_status_name in ('Прошел СБ') then 64
                when pipeline_status_name in ('Зарегистрирован в АП') then 65
                when pipeline_status_name in ('Обучение') then 66
                when pipeline_status_name in ('Согласование договора') then 67
                when pipeline_status_name in ('Договор подписан') then 68
                when pipeline_status_name in ('Формирование отчетности') then 69
                when pipeline_status_name in ('ROADMAP агента') then 70
                when pipeline_status_name in ('Передал первых лидов') then 71
                when pipeline_status_name in ('Успех') then 72
                when pipeline_status_name in ('В РАБОТЕ') then 73
                when pipeline_status_name in ('Закрыто и не реализовано') then 99
                else 100 end as pipeline_status_name_order
from fin
distributed by (lead_id,calday);
analyze lead_date;



drop table if exists snb_b2b.sales_metrics_data;
CREATE TABLE snb_b2b.sales_metrics_data as
with data_tb as (
    select calday,manager_login, max(user_name)user_name
           , pipeline_name, pipeline_status_name,loss_reason_name
           , channel
           , market_segment
           , create_lead_dt
           , manager_login_mnth
           , max(user_name_mnth) user_name_mnth
           , case when abs(potention_comp)<=100 then '1-100'
                when abs(potention_comp)<=300 then '101-300'
                when abs(potention_comp)<=500 then '301-500'
                when abs(potention_comp)<=1000 then '501-1000'
                when abs(potention_comp)<=3000 then '1001-3000'
                when abs(potention_comp)<=5000 then '3001-5000'
                 else '5000+' end as potention_group
           , create_ld_flg_m
           ,status_convertion
           , status_convertion_order
           , pipeline_name_order
           , pipeline_status_name_order

           ,sum(price) as potention
           , count(distinct lead_id) as cnt_lead
           , count(distinct case  when create_ld_flg::boolean then lead_id end) as cnt_lead_create
           , count(distinct case  when first_dlv_flg::boolean then lead_id end) as cnt_lead_first_dlv
           , count(distinct case  when create_contr_flg::boolean then lead_id end) as cnt_lead_create_contr
           , sum(deliveries_cnt)deliveries_cnt
     , sum(deliveries_express_cnt) deliveries_express_cnt
     , sum(deliveries_sdd_cnt)deliveries_sdd_cnt
     , sum(deliveries_ndd_cnt) deliveries_ndd_cnt
     , sum(time_change_status)time_change_status
     , null as cnt_meetings
      , null as cnt_calls
      , null as cnt_emails
      , null as cnt_overdue
    from lead_date
group by calday,manager_login
           , pipeline_name, pipeline_status_name,loss_reason_name,channel, market_segment
    , create_lead_dt , manager_login_mnth , case when abs(potention_comp)<=100 then '1-100'
                when abs(potention_comp)<=300 then '101-300'
                when abs(potention_comp)<=500 then '301-500'
                when abs(potention_comp)<=1000 then '501-1000'
                when abs(potention_comp)<=3000 then '1001-3000'
                when abs(potention_comp)<=5000 then '3001-5000'
                 else '5000+' end
    ,create_ld_flg_m
    ,status_convertion
           , status_convertion_order
           , pipeline_name_order
           , pipeline_status_name_order

union all
select calday, manager_login, max(user_name) user_name
     ,null as pipeline_name
     ,null as pipeline_status_name
     ,null as loss_reason_name
     ,null as channel
     ,null as market_segment
     ,null as create_lead_dt
     ,null as manager_login_mnth
     ,null as user_name_mnth
     ,null as potention_group
     ,null as create_ld_flg_m
     ,null as status_convertion
    ,null as status_convertion_order
    ,null as pipeline_name_order
    ,null as pipeline_status_name_order
            , null as potention
           , null as  cnt_lead
           , null as  cnt_lead_create
           , null as  cnt_lead_first_dlv
           , null as  cnt_lead_create_contr
           , null as deliveries_cnt
     , null as deliveries_express_cnt
     , null as deliveries_sdd_cnt
     , null as deliveries_ndd_cnt
     , null as  time_change_status
           , sum(cnt_meetings)   as cnt_meetings
           , sum(cnt_calls) as cnt_calls
           , sum(cnt_emails) as cnt_emails
           , sum(cnt_overdue) as cnt_overdue
from tasks_data
group by calday, manager_login)

select calday, data_tb.manager_login, data_tb.user_name
     , manager_metagroup, manager_group
     , pipeline_name, pipeline_status_name,loss_reason_name,channel, market_segment
     , create_lead_dt, manager_login_mnth,user_name_mnth
     , potention_group
     , create_ld_flg_m
     , status_convertion
    , status_convertion_order
    , pipeline_name_order
    , pipeline_status_name_order
     , potention, cnt_lead, cnt_lead_create, cnt_lead_first_dlv, cnt_lead_create_contr
     , deliveries_cnt, deliveries_express_cnt, deliveries_sdd_cnt, deliveries_ndd_cnt
     , time_change_status
     , cnt_meetings, cnt_calls, cnt_emails, cnt_overdue
     , 1::int as flg_day
     ,(calday=(date_trunc('week',calday)::date+6) or calday=current_date-1)::int as flg_week
     ,(calday=((date_trunc('month',calday)+'1 month'::interval)::date-1) or calday=current_date-1)::int as flg_month

from data_tb
left join (select manager_login, max(manager_group)manager_group, max(manager_metagroup)manager_metagroup
           from snb_b2b.amo_leads_info group by manager_login) aml on data_tb.manager_login=aml.manager_login
;