import json
import time
import os

from business_models import hahn

from projects.common.clients.skorozvon import SkorozvonAPI
from projects.common.tools import flatten_dict

YT_TABLE_PATH = '//home/taxi-delivery/production/b2b/skorozvon'
YT_END_TIME_ATTRIBUTE = 'last_end_time'


def main():
    with open(os.path.expanduser('~/secret_data')) as f:
        secret_data = json.load(f)

    api = SkorozvonAPI(
        api_key=secret_data['api_key'],
        client_id=secret_data['client_id'],
        client_secret=secret_data['client_secret'],
        login=secret_data['login'],
        tvm_secret=os.environ.get('TVM_SECRET'),
    )
    yt = hahn.yt

    start_time = yt.get_attribute(
        YT_TABLE_PATH, YT_END_TIME_ATTRIBUTE, default=0,
    )
    end_time = int(time.time())
    calls_iterator = iter(
        map(flatten_dict, api.iterate_calls_total(start_time, end_time)),
    )

    with yt.Transaction():
        yt.write_table(
            yt.TablePath(YT_TABLE_PATH, append=True), calls_iterator,
        )
        yt.set_attribute(YT_TABLE_PATH, YT_END_TIME_ATTRIBUTE, end_time)


if __name__ == '__main__':
    main()
