USE hahn;
PRAGMA yt.Pool = 'taxi-delivery';
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$INSERT_PATH = "//home/taxi-delivery/analytics/production/b2b/dash/touch";

$dttm_format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$users_data = (
    SELECT
    pd_id,
    cast(name as string) as name,
    SUBSTRING(cast(name as string), null, find(cast(name as string), ' ') ) as first_name,
    SUBSTRING(cast(name as string), find(cast(name as string), ' ')+ cast( 1 as Uint32) ) as last_name,
    cast (email as string) as email

    FROM `//home/taxi-delivery/analytics/production/b2b/voytekh_pd_user`
    WHERE which_crm = 6
);

$users =(
    SELECT
    pd_id,
    last_name || ' ' || first_name as user_name,
    substring(email, null, find(email, '@')) as manager_login
    FROM $users_data
);

$activities = (
SELECT
--FIND( note, 'Длительность: '),
--FIND( note, '<br>',FIND( note, 'Длительность: ')),
--FIND( note, '<br>',FIND( note, 'Длительность: ')) - FIND( note, 'Длительность: '),
if( FIND( note, 'Длительность: ') > 0,SUBSTRING(cast(note as string), FIND( note, 'Длительность: ') + LEN('Длительность: '), FIND( note, '<br>',FIND( note, 'Длительность: ')) - FIND( note, 'Длительность: ') - LEN('Длительность: ') ), null) as duration,
if(FIND( note, 'Длительность: ')>0,SUBSTRING(cast(note as string), FIND( note, 'Собеседник ') + LEN('Собеседник '), FIND( note, '<br>',FIND( note, 'Собеседник ')) - FIND( note, 'Собеседник ') - LEN('Собеседник ') ), null) as call_number,
if(find(note,'/taxi-biz/') > 0, SUBSTRING(cast(note as string), FIND( note, '/taxi-biz/') + LEN('/taxi-biz/'), FIND( note, '.wav',FIND( note, '/taxi-biz/')) - FIND( note, '/taxi-biz/') - LEN('/taxi-biz/') ), null) as wav_file,
if(FIND( note, 'Длительность: ')>0,SUBSTRING(cast(note as string), FIND( note, 'Направление: ') + LEN('Направление: '), FIND( note, '<br>',FIND( note, 'Направление: ')) - FIND( note, 'Направление: ') - LEN('Направление: ') ), null) as call_route,
if(note ILIKE '%success_call%', 'success_call', if(note ilike '%bad_call%', 'bad_call', null)) as call_status,
deal_id,
user_id,
note,
id,
SUBSTRING(marked_as_done_time, null, FIND(marked_as_done_time, 'T')) as done_dt

FROM `//home/taxi-delivery/analytics/production/b2b/voytekh_pd2_activity`
where

type = 'call'

);

$data  = (
SELECT
SUBSTRING(call_number,LEN(call_number) - cast(11 as uint32)) as call_number_norm,
done_dt,
duration,
deal_id,
user_id,
note,
id,
call_status,
call_route,
call_number,
wav_file

FROM $activities
);


$sum = (
SELECT
call_number_norm,
MAX_BY(deal_id, done_dt) as call_for_deal


FROM $data
WHERE deal_id is not null
GROUP BY call_number_norm
);

$cisco = (
SELECT
SUBSTRING(event_dttm, null, 19) as call_dttm,
SUBSTRING(event_dttm, null, 13) as call_dtth,
if(len(number_a)>10, SUBSTRING(number_a,LEN(number_a) - cast(11 as uint32)), number_a) as call_from,
if(len(number_b)>10, SUBSTRING(number_b,LEN(number_b) - cast(11 as uint32)), number_b) as call_to,
call_duration,
guid as cisco_guid,
call_link

FROM `//home/taxi-delivery/analytics/production/b2b/support/total_calls`
--LIMIT 1000

);

$calls_final_data = (

SELECT
call_dtth,
call_dttm,
call_from,
call_to,
call_link,
call_duration,
cisco_guid,
CAST((CASE WHEN call_for_deal IS NULL THEN deal_id ELSE call_for_deal END) AS STRING) AS deal_id,
done_dt,
duration,
user_id,
note,
id,
call_status,
call_route,
call_number,
wav_file,
user_name,
e.manager_login as manager_login,

FROM $cisco as a
LEFT JOIN $sum as b on a.call_to = b.call_number_norm
LEFT JOIN $data as d on a.cisco_guid = d.wav_file
LEFT JOIN $users as e on e.pd_id = d.user_id

);

$raw_data = (
    SELECT
    id,
    created,
    $dttm_format(DateTime::FromSeconds(DateTime::ToSeconds(cast(created as Datetime))+cast(10800 as uint32))) as event_date,
    SUBSTRING($dttm_format(DateTime::FromSeconds(DateTime::ToSeconds(cast(created as Datetime))+cast(10800 as uint32))), null, 13) as event_dtth,
    survey_id,
    yandexuid,
    lang,

    Yson::ConvertToInt64(answer.data.deal_id.question.id) as deal_id_question_id,
    Yson::ConvertToString(answer.data.deal_id.value) as deal_id_value,

    Yson::ConvertToInt64(answer.data.crm_step.question.id) as crm_step_question_id,
    Yson::ConvertToString(answer.data.crm_step.value[0].text) as crm_step_value,
    Yson::ConvertToString(answer.data.crm_step.value[0].slug) as crm_step_key,

    Yson::ConvertToInt64(answer.data.support.question.id) as support_question_id,
    Yson::ConvertToString(answer.data.support.value[0].text) as support_value,
    Yson::ConvertToString(answer.data.support.value[0].slug) as support_key,

    Yson::ConvertToInt64(answer.data.theme_id.question.id) as theme_id_question_id,
    Yson::ConvertToString(answer.data.theme_id.value[0].text) as theme_id_value,
    Yson::ConvertToString(answer.data.theme_id.value[0].slug) as theme_id_key,

    Yson::ConvertToInt64(answer.data.new_theme_id.question.id) as new_theme_id_question_id,
    Yson::ConvertToString(answer.data.new_theme_id.value[0].text) as new_theme_id_value,
    Yson::ConvertToString(answer.data.new_theme_id.value[0].slug) as new_theme_id_key,

    if(Yson::ConvertToInt64(answer.data.call_status_id.question.id) is not null or cast(Yson::ConvertToInt64(answer.data.call_status_id.question.id)  as string) != '', Yson::ConvertToInt64(answer.data.call_status_id.question.id), Yson::ConvertToInt64(answer.data.answer_choices_710770.question.id)) as call_status_id_question_id,
    if(Yson::ConvertToString(answer.data.call_status_id.value[0].text) is not null or cast(Yson::ConvertToString(answer.data.call_status_id.value[0].text) as string) != '', Yson::ConvertToString(answer.data.call_status_id.value[0].text), Yson::ConvertToString(answer.data.answer_choices_710770.value[0].text)) as call_status_id_value,
    if(Yson::ConvertToInt64(answer.data.call_status_id.value[0].slug) is not null or cast(Yson::ConvertToString(answer.data.call_status_id.value[0].slug) as string) != '', Yson::ConvertToString(answer.data.call_status_id.value[0].slug), Yson::ConvertToString(answer.data.answer_choices_710770.value[0].slug)) as call_status_id_key,

    --Yson::ConvertToInt64(answer.data.answer_choices_710770.question.id)
    --Yson::ConvertToString(answer.data.answer_choices_710770.value[0].text) as call_status_id_value,
    --Yson::ConvertToString(answer.data.answer_choices_710770.value[0].slug) as call_status_id_key,

    Yson::ConvertToInt64(answer.data.answer_choices_717324.question.id) as onboarding_type_question_id,
    Yson::ConvertToString(answer.data.answer_choices_717324.value[0].text) as onboarding_type_id_value,
    Yson::ConvertToString(answer.data.answer_choices_717324.value[0].slug) as onboarding_type_id_key,

    Yson::ConvertToInt64(answer.data.why_accidentally_registration.question.id) as why_accidentally_registration_question_id,
    Yson::ConvertToString(answer.data.why_accidentally_registration.value[0].text) as why_accidentally_registration_value,
    Yson::ConvertToString(answer.data.why_accidentally_registration.value[0].slug) as why_accidentally_registration_key,

    Yson::ConvertToInt64(answer.data.bad_debt_reason.question.id) as bad_debt_reason_question_id,
    Yson::ConvertToString(answer.data.bad_debt_reason.value[0].text) as bad_debt_reason_value,
    Yson::ConvertToString(answer.data.bad_debt_reason.value[0].slug) as bad_debt_reason_key,

    Yson::ConvertToInt64(answer.data.bad_debt_reason_other.question.id) as bad_debt_reason_other_question_id,
    Yson::ConvertToString(answer.data.bad_debt_reason_other.value) as bad_debt_reason_other_value,

    Yson::ConvertToInt64(answer.data.reg_stop_reasons_id.question.id) as reg_stop_reasons_id_question_id,
    Yson::ConvertToString(answer.data.reg_stop_reasons_id.value[0].text) as reg_stop_reasons_id_value,
    Yson::ConvertToString(answer.data.reg_stop_reasons_id.value[0].slug) as reg_stop_reasons_id_key,

    Yson::ConvertToInt64(answer.data.no_first_ride_id.question.id) as no_first_ride_id_question_id,
    Yson::ConvertToString(answer.data.no_first_ride_id.value[0].text) as no_first_ride_id_value,
    Yson::ConvertToString(answer.data.no_first_ride_id.value[0].slug) as no_first_ride_id_key,

    Yson::ConvertToInt64(answer.data.lk_problems_id.question.id) as lk_problems_id_question_id,
    Yson::ConvertToString(answer.data.lk_problems_id.value[0].text) as lk_problems_id_value,
    Yson::ConvertToString(answer.data.lk_problems_id.value[0].slug) as lk_problems_id_key,

    Yson::ConvertToInt64(answer.data.order_problem_id.question.id) as order_problem_id_question_id,
    Yson::ConvertToString(answer.data.order_problem_id.value[0].text) as order_problem_id_value,
    Yson::ConvertToString(answer.data.order_problem_id.value[0].slug) as order_problem_id_key,

    Yson::ConvertToInt64(answer.data.debt_status_id.question.id) as debt_status_id_question_id,
    Yson::ConvertToString(answer.data.debt_status_id.value[0].text) as debt_status_id_value,
    Yson::ConvertToString(answer.data.debt_status_id.value[0].slug) as debt_status_id_key,

    Yson::ConvertToInt64(answer.data.decrease_reason_id.question.id) as decrease_reason_id_question_id,
    Yson::ConvertToString(answer.data.decrease_reason_id.value[0].text) as decrease_reason_id_value,
    Yson::ConvertToString(answer.data.decrease_reason_id.value[0].slug) as decrease_reason_id_key,

    Yson::ConvertToInt64(answer.data.decrease_reason_client.question.id) as decrease_reason_client_id_question_id,
    Yson::ConvertToString(answer.data.decrease_reason_client.value[0].text) as decrease_reason_client_id_value,
    Yson::ConvertToString(answer.data.decrease_reason_client.value[0].slug) as decrease_reason_client_id_key,

    Yson::ConvertToInt64(answer.data.answer_choices_711359.question.id) as stop_reason_client_id_question_id,
    Yson::ConvertToString(answer.data.answer_choices_711359.value[0].text) as stop_reason_client_id_value,
    Yson::ConvertToString(answer.data.answer_choices_711359.value[0].slug) as stop_reason_client_id_key,

    Yson::ConvertToInt64(answer.data.answer_choices_711250.question.id) as delivery_reason_id_question_id,
    Yson::ConvertToString(answer.data.answer_choices_711250.value[0].text) as delivery_reason_id_value,
    Yson::ConvertToString(answer.data.answer_choices_711250.value[0].slug) as delivery_reason_id_key,

    Yson::ConvertToInt64(answer.data.price_reason_id.question.id) as price_reason_id_question_id,
    Yson::ConvertToString(answer.data.price_reason_id.value[0].text) as price_reason_id_value,
    Yson::ConvertToString(answer.data.price_reason_id.value[0].slug) as price_reason_id_key,

    Yson::ConvertToInt64(answer.data.rivals_id.question.id) as rivals_id_question_id,
    Yson::ConvertToString(answer.data.rivals_id.value[0].text) as rivals_id_value,
    Yson::ConvertToString(answer.data.rivals_id.value[0].slug) as rivals_id_key,

    Yson::ConvertToInt64(answer.data.answer_choices_711366.question.id) as rivals_2_id_question_id,
    Yson::ConvertToString(answer.data.answer_choices_711366.value[0].text) as rivals_2_id_value,
    Yson::ConvertToString(answer.data.answer_choices_711366.value[0].slug) as rivals_2_id_key,

    Yson::ConvertToInt64(answer.data.call_back_id.question.id) as call_back_id_question_id,
    Yson::ConvertToString(answer.data.call_back_id.value) as call_back_id_value,

    Yson::ConvertToInt64(answer.data.call_back_date_id.question.id) as call_back_date_id_question_id,
    Yson::ConvertToString(answer.data.call_back_date_id.value) as call_back_date_id_value,

    Yson::ConvertToInt64(answer.data.call_back_time_YT_id.question.id) as call_back_time_YT_id_question_id,
    Yson::ConvertToString(answer.data.call_back_time_YT_id.value) as call_back_time_YT_id_value,

    Yson::ConvertToInt64(answer.data.spam_check.question.id) as spam_check_question_id,
    Yson::ConvertToString(answer.data.spam_check.value) as spam_check_value,

    Yson::ConvertToInt64(answer.data.stop_calls_alert.question.id) as stop_calls_alert_question_id,
    Yson::ConvertToString(answer.data.stop_calls_alert.value) as stop_calls_alert_value,

    Yson::ConvertToInt64(answer.data.answer_long_text_710779.question.id) as comment_question_id,
    Yson::ConvertToString(answer.data.answer_long_text_710779.value) as comment_value,

    Yson::ConvertToInt64(answer.data.why_accidentally_registration_other.question.id) as why_accidentally_registration_other_question_id,
    Yson::ConvertToString(answer.data.why_accidentally_registration_other.value) as why_accidentally_registration_other_value,



    FROM `//home/forms/answers/forms_int/production/79837/data`

    WHERE Yson::ConvertToString(answer.data.deal_id.value) != "29803"
    AND Yson::ConvertToString(answer.data.deal_id.value) != "29083"
    /*WHERE Yson::ConvertToString(answer.data.deal_id.value) == "29803"*/
);

INSERT INTO $INSERT_PATH WITH TRUNCATE

SELECT

a.id as id,
event_date,
event_dtth,
deal_id_value,
crm_step_value,
support_value,
theme_id_value,
new_theme_id_value,
call_status_id_value,
onboarding_type_id_value,
reg_stop_reasons_id_value,
why_accidentally_registration_value,
why_accidentally_registration_other_value,
bad_debt_reason_value,
bad_debt_reason_other_value,
no_first_ride_id_value,
lk_problems_id_value,
order_problem_id_value,
debt_status_id_value,
decrease_reason_id_value,
decrease_reason_client_id_value,
stop_reason_client_id_value,
delivery_reason_id_value,
price_reason_id_value,
rivals_id_value,
rivals_2_id_value,
call_back_id_value,
call_back_date_id_value,
call_back_time_YT_id_value,
spam_check_value,
stop_calls_alert_value,
comment_value,
deal_id,
call_dtth,
call_dttm,
call_from,
call_to,
call_link,
call_duration,
call_status,
user_name,
manager_login,

CASE
    WHEN crm_step_value == 'Развитие' THEN 'Развитие'
    WHEN crm_step_value == 'Совершена первая доставка (До первого месяца)' THEN 'Совершена первая доставка'
    WHEN crm_step_value == 'Обучение пройдено (Первая доставка не совершена)' THEN 'Обучение пройдено'
    WHEN crm_step_value == 'Платежные данные подтверждены (Обучение не пройдено)' THEN 'Платежные данные подтверждены'
    WHEN crm_step_value == 'Данные о компании получены (Платежные данные не заполнены)' THEN 'Данные о компании получены'
    WHEN crm_step_value == 'Контактные данные получены (Данные о компании не заполнены)' THEN 'Контактные данные получены'
    -- WHEN __ THEN __
    ELSE ''
    END
    AS step_1,

CASE
    WHEN crm_step_value == 'Обучение пройдено (Первая доставка не совершена)' THEN 'Клиент не запустился'
    WHEN crm_step_value == 'Данные о компании получены (Платежные данные не заполнены)' THEN 'Клиент не закончил регистрацию'
    WHEN crm_step_value == 'Контактные данные получены (Данные о компании не заполнены)' THEN 'Клиент не закончил регистрацию'
    WHEN new_theme_id_value == 'Первый контакт' THEN 'Первый контакт'
    WHEN new_theme_id_value == 'Онбординг' THEN 'Онбординг'
    WHEN crm_step_value == 'Платежные данные подтверждены (Обучение не пройдено)' AND new_theme_id_value IS NULL THEN 'Онбординг'
    WHEN theme_id_value == 'Переход в Tier 3' THEN 'Переход в Tier 3'
    WHEN theme_id_value == 'Перевод в воронку "Самостоятельные клиенты"' THEN 'Переход в Tier 3'
    WHEN theme_id_value == 'Клиент снизил потребление' THEN 'Клиент снизил потребление'
    WHEN theme_id_value == 'Клиент перестал пользоваться' THEN 'Клиент перестал пользоваться'
    WHEN theme_id_value == 'Дебиторская задолженность' THEN 'Дебиторская задолженность'
    WHEN theme_id_value == 'Состояние баланса' THEN 'Состояние баланса'
    ELSE theme_id_value
    END
    AS step_2,

CASE
    WHEN call_status_id_value == 'Звонок состоялся' THEN 'Звонок состоялся'
    WHEN call_status_id_value == 'Бросили трубку' THEN 'Бросили трубку'
    WHEN call_status_id_value == 'Недозвон' THEN 'Недозвон'
    ELSE call_status_id_value
    END
    AS step_3,

CASE
    WHEN reg_stop_reasons_id_value IS NOT NULL THEN reg_stop_reasons_id_value
    WHEN why_accidentally_registration_value IS NOT NULL THEN why_accidentally_registration_value
    WHEN onboarding_type_id_value IS NOT NULL THEN onboarding_type_id_value
    WHEN no_first_ride_id_value IS NOT NULL THEN no_first_ride_id_value
    WHEN decrease_reason_id_value IS NOT NULL THEN decrease_reason_id_value
    WHEN (decrease_reason_id_value == 'Причина на стороне клиента' AND call_status_id_value in ('Недозвон','Бросили трубку')) THEN ''
    WHEN debt_status_id_value IS NOT NULL THEN debt_status_id_value
    ELSE ''
    END
    AS step_4,

CASE
    WHEN lk_problems_id_value IS NOT NULL THEN lk_problems_id_value
    WHEN order_problem_id_value IS NOT NULL THEN order_problem_id_value
    WHEN decrease_reason_client_id_value IS NOT NULL THEN decrease_reason_client_id_value
    WHEN stop_reason_client_id_value IS NOT NULL THEN stop_reason_client_id_value
    WHEN delivery_reason_id_value IS NOT NULL THEN delivery_reason_id_value
    WHEN (decrease_reason_id_value == 'Причина на стороне клиента' AND call_status_id_value in ('Недозвон','Бросили трубку')) THEN ''
    WHEN bad_debt_reason_value IS NOT NULL THEN bad_debt_reason_value
    ELSE ''
    END
    AS step_5,

CASE
    WHEN price_reason_id_value IS NOT NULL THEN price_reason_id_value
    ELSE ''
    END
    AS step_6,

CASE
    WHEN rivals_id_value IS NOT NULL THEN rivals_id_value
    WHEN rivals_2_id_value IS NOT NULL THEN rivals_2_id_value
    ELSE ''
    END
    AS step_7


FROM $raw_data as a
LEFT JOIN $calls_final_data as b on b.deal_id = a.deal_id_value and b.call_dtth = a.event_dtth

-- where SUBSTRING(event_date, null, 10) = "2022-01-12"

-- --WHERE theme_id_value == 'Переход в Tier 3'
-- --ORDER BY event_date DESC
-- limit 100
