-- Скрипт-обработчик CORPINVOICE
-- Для https://st.yandex-team.ru/LOGDATA-556
use hahn;
pragma SimpleColumns;

$HISTORY_START = '2020-10-01'; -- YYYY-MM-DD

$TYPES = '//home/startrek/tables/prod/yandex-team/common/types';
$CORPINVOICE = '//home/startrek/tables/prod/yandex-team/queue/CORPINVOICE/issues';
$LOGIN_UID_MAPPING = '//home/taxi-delivery/analytics/production/b2b/support/CORPINVOICE/login_uid_mapping';
$SAVE_TO = '//home/taxi-delivery/analytics/production/b2b/support/CORPINVOICE/issues';

$SLA_PAYMENT_PROCESSING_ID = 3132; -- Проведение выплаты
$SLA_REQUEST_COMPLAINT_ID = 3102; -- Запрос претензии
$SLA_FIRST_ID = 3043; -- First

$exctract_sla_data = ($list, $id) -> {
    return ListSkipWhile($list, ($x) -> {
        return Yson::YPathInt64($x, '/settings/id') != $id;
    })[0]
};

$sla_spent = ($sla_data) -> {
    -- Здесь делаю -1 на случай, если тикет не закончился,
    -- и -2, если в компенсации отказано и таймер на SLA просто не запустится
    $sec = case 
        when Yson::YPathString($sla_data, '/clockStatus') = 'STARTED' then -1
        when Yson::YPathString($sla_data, '/clockStatus') = 'NOT_STARTED' then -2
        when ((Yson::YPathString($sla_data, '/clockStatus') = 'STOPPED') or (Yson::YPathString($sla_data, '/clockStatus') = 'PAUSED')) then Yson::YPathInt64($sla_data, '/spent') / 1000
        else -9999
    end;
    return $sec;
};

$sla_violation_status = ($sla_data) -> {
    -- Здесь делаю CLOCK_STARTED на случай, если тикет не закончился,
    -- и CLOCK_DIDNT_START, если в компенсации отказано и таймер на SLA просто не запустится
    $status = case 
        when Yson::YPathString($sla_data, '/clockStatus') = 'STARTED' then 'CLOCK_STARTED'
        when Yson::YPathString($sla_data, '/clockStatus') = 'NOT_STARTED' then 'CLOCK_DIDNT_START'
        when ((Yson::YPathString($sla_data, '/clockStatus') = 'STOPPED') or (Yson::YPathString($sla_data, '/clockStatus') = 'PAUSED')) then Yson::YPathString($sla_data, '/violationStatus')
        else 'ERROR'
    end;
    return $status;
};

$dttm_format = DateTime::Format('%d.%m.%Y %H:%M:%S');
$format_dttm = ($dttm) -> {
    $index = cast(RFIND($dttm_format(DateTime::ParseIso8601($dttm)), '.') as Uint32);
    return substring($dttm_format(DateTime::ParseIso8601($dttm)), null, $index);
};

$processed_tickets_data = (
    select `type` as type_id
		, assignee as assignee_uid
        , author as author_uid
        , resolver as resolver_uid
    
        , cast(DateTime::FromMilliseconds(cast(created as Uint64)) as String) as created_dttm_utc
        , cast(DateTime::FromMilliseconds(cast(resolved as Uint64)) as String) as resolved_dttm_utc
        
        , $format_dttm(cast(DateTime::FromMilliseconds(cast(created as Uint64)) as String)) as created_dttm_utc_formatted 
        , $format_dttm(cast(DateTime::FromMilliseconds(cast(resolved as Uint64)) as String)) as resolved_dttm_utc_formatted 
        
        , key as ticket_id
    
        -- Если тип 51ff5feef2d2aaa5600cdb75, то это "Эпик" на запрос претензии
        , if(type = '51ff5feef2d2aaa5600cdb75', $sla_spent($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_PAYMENT_PROCESSING_ID)), -3) as sla_payment_processing_spent_sec
        , if(type = '51ff5feef2d2aaa5600cdb75', $sla_violation_status($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_PAYMENT_PROCESSING_ID)), 'NOT_APPLICABLE') as sla_payment_processing_violation_status

        -- Если тип 4f6b271330049b12e72e3f07, то это просто заявка, из которой компенсации может и не получиться
        , if(type = '4f6b271330049b12e72e3f07', $sla_spent($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_REQUEST_COMPLAINT_ID)), -3) as sla_request_complaint_spent_sec
        , if(type = '4f6b271330049b12e72e3f07', $sla_violation_status($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_REQUEST_COMPLAINT_ID)), 'NOT_APPLICABLE') as sla_request_complaint_violation_status

        , if(type = '4f6b271330049b12e72e3f07', $sla_spent($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FIRST_ID)), -3) as sla_first_spent_sec
        , if(type = '4f6b271330049b12e72e3f07', $sla_violation_status($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FIRST_ID)), 'NOT_APPLICABLE') as sla_first_violation_status
        , Yson::YPathString(localFields, '/607580bed082d8793a2c48eb--tier') as tier
        , Yson::YPathString(customFields, '/company') as corp_client
        , Yson::YPathString(customFields, '/numberOfContract') as corp_contract
        -- Тут ??, потому что в зависимости от типа разные схемы
        , cast(Yson::YPathString(customFields, '/hrInvoice/amount') as Double) ?? cast(Yson::YPathString(customFields, '/amountOfPayment/amount') as Double) as amount
        , Yson::YPathString(customFields, '/hrInvoice/unit') ?? Yson::YPathString(customFields, '/amountOfPayment/unit') as currency
        , case 
            when type = '51ff5feef2d2aaa5600cdb75' then 'epic'
            when type = '4f6b271330049b12e72e3f07' then 'not epic'
            -- На всякий случай, чтобы баги ловить
            else 'ERROR'
        end as epic_flg
        , case 
            -- Вроде все основные статусы выловил
            when status = '4f6b29673004ccc027df1e53' then 'closed'
            when status = '4f6b29673004ccc027df1e1c' then 'open'
            when status = '50916475e4b0cc551a5dcf55' then 'need info'
            when status = '5b64613b61a6a7001b63f3a7' then 'wait refund'
            when status = '552bc033e4b00931e4707ffc' then 'application submitted'
            -- На всякий случай, если не все
            else 'ERROR'
        end as status
    from $CORPINVOICE
    where created > DateTime::ToMilliseconds(cast($HISTORY_START as Date))
        -- Чистим компоненту "Такси"
        and '5fb672556337132364c34b39' not in Yson::ConvertToStringList(components)
        -- Чистим компоненту "Маркет"
        and '61015c88664b4a56175c6522' not in Yson::ConvertToStringList(components)
);

insert into $SAVE_TO with truncate
select t.*
	, types.key as type
    , assign.login ?? 'failed to find login' as assignee_login
    , author.login ?? 'failed to find login' as author_login
    , resolver.login ?? 'failed to find login' as resolver_login
without assign.uid
    , author.uid
    , resolver.uid
    , t.type_id
from $processed_tickets_data as t
left join $LOGIN_UID_MAPPING as assign on cast(t.assignee_uid as String)=assign.uid
left join $LOGIN_UID_MAPPING as author on cast(t.author_uid as String)=author.uid
left join $LOGIN_UID_MAPPING as resolver on cast(t.resolver_uid as String)=resolver.uid
left join $TYPES as types on (t.type_id=types.id);