import os

import pandas as pd
import numpy as np

import requests

import yt.wrapper as yt

if __name__ == '__main__':
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    
    RAW_TICKETS_PATH = '//home/startrek/tables/prod/yandex-team/queue/CORPSUPPORTBOT/issues'
    UID_LOGIN_PATH = '//home/taxi-delivery/analytics/production/b2b/support/CORPSUPPORTBOT/login_uid_mapping'
    
    raw_tickets = pd.DataFrame(list(yt.read_table(yt.TablePath(RAW_TICKETS_PATH))))
    
    uids = np.unique(raw_tickets[~raw_tickets['assignee'].isna()]['assignee'].astype(int).astype(str))
    uids_num = len(uids)
    
    STAFF_URL = 'https://staff-api.yandex-team.ru/v3/persons'
    OAUTH_TOKEN = os.environ.get('STAFF_SECRET')
    
    params = {
        "_fields" : "login,uid",
        "_limit" : uids_num, 
        "uid" : (',').join(uids)
    }
    headers = {
        'Authorization': f'OAuth {OAUTH_TOKEN}'
    }
    resp = requests.get(STAFF_URL, params=params, headers=headers)
    logins = resp.json()['result']
    
    schema = [
        {"name": "login", "type": "string"},
        {"name": "uid", "type": "string"}
    ]
    if yt.exists(UID_LOGIN_PATH):
        yt.remove(UID_LOGIN_PATH)
    yt.create("table", UID_LOGIN_PATH, attributes={"schema": schema})
    yt.write_table(
        yt.TablePath(UID_LOGIN_PATH, append=False),
        logins,
    )
