-- Скрипт-обработчик CORPSUPPORTBOT
-- Для https://st.yandex-team.ru/LOGDATA-556
use hahn;
pragma SimpleColumns;

$HISTORY_START = '2021-01-01'; -- YYYY-MM-DD

$CORPSUPPORTBOT = '//home/startrek/tables/prod/yandex-team/queue/CORPSUPPORTBOT/issues';
$LOGIN_UID_MAPPING = '//home/taxi-delivery/analytics/production/b2b/support/CORPSUPPORTBOT/login_uid_mapping';
$SAVE_TO = '//home/taxi-delivery/analytics/production/b2b/support/CORPSUPPORTBOT/issues';

$SLA_FULL_ID = 3020;
$SLA_FIRST_ID = 3019;

$exctract_sla_data = ($list, $id) -> {
    return ListSkipWhile($list, ($x) -> {
        return Yson::YPathInt64($x, '/settings/id') != $id;
    })[0]
};

$sla_spent = ($sla_data) -> {
    -- Здесь делаю -1 на случай, если тикет не закончился,
    -- и -2, если в компенсации отказано и таймер на SLA просто не запустится
    $sec = case 
        when Yson::YPathString($sla_data, '/clockStatus') = 'STARTED' then -1
        when Yson::YPathString($sla_data, '/clockStatus') = 'NOT_STARTED' then -2
        when ((Yson::YPathString($sla_data, '/clockStatus') = 'STOPPED') or (Yson::YPathString($sla_data, '/clockStatus') = 'PAUSED')) then Yson::YPathInt64($sla_data, '/spent') / 1000
        else -9999
    end;
    return $sec;
};

$sla_violation_status = ($sla_data) -> {
    -- Здесь делаю CLOCK_STARTED на случай, если тикет не закончился,
    -- и CLOCK_DIDNT_START, если в компенсации отказано и таймер на SLA просто не запустится
    $status = case 
        when Yson::YPathString($sla_data, '/clockStatus') = 'STARTED' then 'CLOCK_STARTED'
        when Yson::YPathString($sla_data, '/clockStatus') = 'NOT_STARTED' then 'CLOCK_DIDNT_START'
        when ((Yson::YPathString($sla_data, '/clockStatus') = 'STOPPED') or (Yson::YPathString($sla_data, '/clockStatus') = 'PAUSED')) then Yson::YPathString($sla_data, '/violationStatus')
        else 'ERROR'
    end;
    return $status;
};

$extract_corp_client = ($summary) -> {
    $start = Find($summary, '(') + 1;
    $end = Find($summary, ')');

    return Substring($summary, cast($start as Uint32), cast($end - $start as Uint32));
};

$dttm_format = DateTime::Format('%d.%m.%Y %H:%M:%S');
$format_dttm = ($dttm) -> {
    $index = cast(RFIND($dttm_format(DateTime::ParseIso8601($dttm)), '.') as Uint32);
    return substring($dttm_format(DateTime::ParseIso8601($dttm)), null, $index);
};

$processed_tickets_data = (
    select assignee as assignee_uid
        , author as author_uid
        , resolver as resolver_uid
    
        , cast(DateTime::FromMilliseconds(cast(created as Uint64)) as String) as created_dttm_utc
        , cast(DateTime::FromMilliseconds(cast(resolved as Uint64)) as String) as resolved_dttm_utc
    
        , $format_dttm(cast(DateTime::FromMilliseconds(cast(created as Uint64)) as String)) as created_dttm_utc_formatted
        , $format_dttm(cast(DateTime::FromMilliseconds(cast(resolved as Uint64)) as String)) as resolved_dttm_utc_formatted
    
        , Yson::YPathString(customFields, '/themeCorpBot') as theme
        , Yson::YPathDouble(customFields, '/testingStoryPoints') as csat
        , key as ticket_id
        , $sla_spent($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FULL_ID)) as sla_full_spent_sec
        , $sla_violation_status($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FULL_ID)) as sla_full_violation_status
        , $sla_spent($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FIRST_ID)) as sla_first_spent_sec
        , $sla_violation_status($exctract_sla_data(DictPayloads(Yson::ConvertToDict(sla)), $SLA_FIRST_ID)) as sla_first_violation_status
        , $extract_corp_client(summary) as corp_client
        , case 
            -- Вроде все основные статусы выловил
            when status = '4f6b29673004ccc027df1e53' then 'closed'
            when status = '4f6b29673004ccc027df1e1c' then 'open'
            when status = '50916475e4b0cc551a5dcf55' then 'need info'
            -- На всякий случай, если не все
            else 'in progress'
        end as status
    from $CORPSUPPORTBOT
    where created > DateTime::ToMilliseconds(cast($HISTORY_START as Date))
);

insert into $SAVE_TO with truncate
select t.*
    , assign.login ?? 'failed to find login' as assignee_login
    , author.login ?? 'failed to find login'as author_login
    , resolver.login ?? 'failed to find login' as resolver_login
without assign.uid
    , author.uid
    , resolver.uid
from $processed_tickets_data as t
left join $LOGIN_UID_MAPPING as assign on cast(t.assignee_uid as String)=assign.uid
left join $LOGIN_UID_MAPPING as author on cast(t.author_uid as String)=author.uid
left join $LOGIN_UID_MAPPING as resolver on cast(t.resolver_uid as String)=resolver.uid;
