-- Скрипт-обработчик тикетов из Chatterbox
-- Для https://st.yandex-team.ru/LOGDATA-556
use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$SUPPORT_TICKETS = '//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets';

$FIRST_LINE_TICKETS = '//home/taxi-delivery/analytics/production/b2b/support/Chatterbox/first_line_tickets';
$SECOND_LINE_TICKERS = '//home/taxi-delivery/analytics/production/b2b/support/Chatterbox/second_line_tickets';
$BOTH_LINES_TICKETS = '//home/taxi-delivery/analytics/production/b2b/support/Chatterbox/both_lines_tickets';

$FIRST_LINES = [
    'taxi_corp_cabinet_cargo',
    'corp_cargo_express_clients',
    'corp_cargo_kz_clients',
    'corp_cargo_new_clients_free',
    'delivery_b2b_mail',
    'delivery_corp_israel',
    'taxi_corp_cargo_express_clients_help'
];

$SECOND_LINES = [
    'delivery_b2b_2line'
];

$START_DATE = '2021-01-01';
$END_DATE = cast(CurrentUtcDate() as String); -- включительно, можно заменить на $END_DATE = 2021-09-05'; для конктреной даты

$dt_parse = DateTime::Parse('%Y-%m-%d');
$dt_format = DateTime::Format('%d.%m.%Y');
$dttm_format = DateTime::Format('%d.%m.%Y %H:%M:%S');

$format_dt = ($dt) -> {
    return $dt_format($dt_parse($dt));
};

$format_dttm = ($dttm) -> {
    $index = cast(RFIND($dttm_format(DateTime::ParseIso8601($dttm)), '.') as Uint32);
    return substring($dttm_format(DateTime::ParseIso8601($dttm)), null, $index);
};

$both_lines = (
    select assignee_id
        , autoreply_flg
        , category
        , chatterbox_ticket
        , city
        , country 
        , creation_dt as creation_dt_utc
        , creation_dttm as creation_dttm_utc
        , csat
        , csat_value
        , csat_value_5
        , line
        , sector
        , meta_category
        , queue
        , reopens
    
        , norm_timespent as norm_timespent_min
        , total_timespent as total_timespent_min
        , sla_full as sla_full_min
        , sla_reply as sla_reply_min
    
        , norm_timespent * 60 as norm_timespent_sec
        , total_timespent * 60 as total_timespent_sec
        , sla_full * 60 as sla_full_sec
        , sla_reply * 60 as sla_reply_sec
    
        , solved_dttm as solved_dttm_utc
        , source
        , startrek_ticket
        , status
        , tariff
        , tariff_zone
        , theme
        , theme_inter
        , theme_rus
        , ticket_id
        , ticket_link
        , case 
            when line in $FIRST_LINES then 'first line'
            when line in $SECOND_LINES then 'second line'
            else 'error'
          end as line_type
        , $format_dt(creation_dt) as creation_dt_formatted 
        , $format_dttm(creation_dttm) as creation_dttm_utc_formatted 
        , $format_dttm(solved_dttm) as solved_dttm_utc_formatted 
    from $SUPPORT_TICKETS
    where 1=1
        and (line in $FIRST_LINES OR line in $SECOND_LINES)
        and creation_dt between $START_DATE and $END_DATE
);

insert into $FIRST_LINE_TICKETS with truncate
select * 
from $both_lines
where line_type = 'first line';

insert into $SECOND_LINE_TICKERS with truncate
select * 
from $both_lines
where line_type = 'second line';

insert into $BOTH_LINES_TICKETS with truncate
select * from $both_lines;
