-- LOGDATA-556
use hahn;

$CALLS = '//home/taxi/production/replica/postgres/callcenter_stats/call_history';
$LOGIN_MAPPING = '//home/taxi/production/replica/postgres/callcenter_operators/operators_access';
$SAVE_TO = '//home/taxi-delivery/analytics/production/b2b/support/call_center';

$LINE = 'ru_taxi_corp_delivery_on_8';

$today = cast(CurrentUtcDate() as String);

$START_MONTH = '2021-04';
$end_month = substring($today, 0, 7);

$dttm_format_classic = DateTime::Format('%Y-%m-%d %H:%M:%S');
$dttm_format_support = DateTime::Format('%H:%M:%S %d.%m.%Y');

$dt_format_classic = DateTime::Format('%Y-%m-%d');
$dt_format_support = DateTime::Format('%d.%m.%Y');

$tm_format = DateTime::Format('%H:%M:%S');

$extract_time = ($ms, $format) -> {
    $datetime_object = Datetime::FromMilliseconds($ms);
    return $format($datetime_object);
};

insert into $SAVE_TO with truncate
select c.id as id
    , c.call_guid as call_guid
    , c.call_id as call_id
    , c.queue as queue
    , c.abonent_phone_id as abonent_phone_id
    , c.agent_id as agent_id

    , c.created_at * 1000 as created_ms 
    , $extract_time(c.created_at * 1000, $dttm_format_classic) as created_dttm
    , $extract_time(c.created_at * 1000, $dttm_format_support) as created_dttm_formatted
    , $extract_time(c.created_at * 1000, $dt_format_classic) as created_dt
    , $extract_time(c.created_at * 1000, $dt_format_support) as created_dt_formatted
    , $extract_time(c.created_at * 1000, $tm_format) as created_tm

    , c.queued_at_ms as queued_at_ms
    , $extract_time(c.queued_at_ms, $dttm_format_classic) as queued_at_dttm
    , $extract_time(c.queued_at_ms, $dttm_format_support) as queued_at_dttm_formatted
    , $extract_time(c.queued_at_ms, $dt_format_classic) as queued_at_dt
    , $extract_time(c.queued_at_ms, $dt_format_support) as queued_at_dt_formatted
    , $extract_time(c.queued_at_ms, $tm_format) as queued_at_tm

    , c.answered_at_ms as answered_at_ms
    , $extract_time(c.answered_at_ms, $dttm_format_classic) as answered_at_dttm
    , $extract_time(c.answered_at_ms, $dttm_format_support) as answered_at_dttm_formatted
    , $extract_time(c.answered_at_ms, $dt_format_classic) as answered_at_dt
    , $extract_time(c.answered_at_ms, $dt_format_support) as answered_at_dt_formatted
    , $extract_time(c.answered_at_ms, $tm_format) as answered_at_tm

    , c.completed_at_ms as completed_at_ms
    , $extract_time(c.completed_at_ms, $dttm_format_classic) as completed_at_dttm
    , $extract_time(c.completed_at_ms, $dttm_format_support) as completed_at_dttm_formatted
    , $extract_time(c.completed_at_ms, $dt_format_classic) as completed_at_dt
    , $extract_time(c.completed_at_ms, $dt_format_support) as completed_at_dt_formatted
    , $extract_time(c.completed_at_ms, $tm_format) as completed_at_tm

    , queued_at_ms / 1000 - created_at as created_to_queued_sec
    , answered_at_ms / 1000 - queued_at_ms / 1000 as queued_to_answered_sec
    , completed_at_ms / 1000 - answered_at_ms / 1000 as answered_to_completed_sec

    , c.endreason as endreason
    , c.transfered_to as transfered_to
    , c.called_number as called_number

    , m.yandex_login as yandex_login
    , m.staff_login as staff_login
    , m.callcenter_id as callcenter_id
    , m.state as state
    , m.working_domain as working_domain
    , m.supervisor_login as supervisor_login
    , m.timezone as timezone
without c.agent_id
from range($CALLS, $START_MONTH, $end_month) as c 
left join $LOGIN_MAPPING as m on c.agent_id = m.agent_id
where queue = $LINE;