use hahn; 

PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$SAVE_TO = '//home/taxi-delivery/analytics/production/b2b/support/Chatterbox/chatterbox_actions_extract';

$dttm_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$dttm_format = DateTime::Format('%d.%m.%Y %H:%M:%S');

$format_dttm = ($dttm) -> {
    $index = cast(RFIND($dttm_format($dttm_parse($dttm)), '.') as Uint32);
    return substring($dttm_format($dttm_parse($dttm)), null, $index);
};

$lines = (
    'taxi_kkd_ndd', 
    'taxi_kkd_ndd_only', 
    'delivery_corp_israel', 
    'corp_cargo_kz_clients', 
    'corp_cargo_express_clients', 
    'delivery_b2b_mail', 
    'taxi_corp_cabinet_cargo', 
    'taxi_corp_cargo_express_clients_help', 
    'delivery_b2b_2line',
    'delivery_b2b_3line', 
    'corp_cargo_cc_autoactions_fail', 
    'corp_cargo_new_clients_free'
);

$actions = (
    'assign',
    'dismiss',
    'defer',
    'communicate',
    'close',
    'comment',
    'forward',
    'export',
    'create',
    'reopen',
    'offer',
    'take',
    'reopen_to_offer',
    'move',
    'forward_messages',
    'manual_update_meta',
    'accept_task',
    'forward_task'
);

$start_day = CAST(DateTime::MakeDate(DateTime::MakeDate(CurrentUtcDate()) - DateTime::IntervalFromDays(190)) as String);

insert into $SAVE_TO WITH TRUNCATE 
select created_dt
    , created_dttm
    , ticket_id
    , login
    , (c.sector_name??a.line) || ' (' || a.line || ')' as sector
    , $format_dttm(created_dttm) as created_dttm_formatted
    , substring($format_dttm(created_dttm), 0, 10) as created_dt_formatted
    , case 
        when a.action = 'assign' then 'Назначил чат себе'
        when a.action = 'dismiss' then 'НТО'
        when a.action = 'defer' then 'Отложено'
        when a.action = 'communicate' then 'Только отправлено'
        when a.action = 'close' then 'Выполнен'
        when a.action = 'comment' then 'В ожидании'
        when a.action = 'forward' then 'Отправил в линию'
        when a.action = 'export' then 'Экспортировал'
        when a.action = 'create' then 'create'
        when a.action = 'reopen' then 'reopen'
        when a.action = 'offer' then 'Был предложен чат'
        when a.action = 'take' then 'Взял в работу'
        when a.action = 'reopen_to_offer' then 'reopen_to_offer'
        when a.action = 'move' then 'Переместил в линию'
        when a.action = 'forward_messages' then 'Передал в другой тип'
        when a.action = 'manual_update_meta' then 'Обновил данные тикета'
        when a.action = 'accept_task' then 'Принял чат'
        when a.action = 'forward_task' then 'Передал в другой тип'
        else 'other' 
    end as Action
from `//home/taxi-analytics/hickinbottom/support/dwh/private/chatterbox_history` as a
    -- LEFT JOIN //home/support-taxi/zendesk/config_lines as b
    -- ON a.line = b.line
left JOIN `home/taxi-analytics/hickinbottom/support/dwh/dds/mapping/sector` as c ON a.line = c.sector
WHERE 1=1
    and a.created_dt > $start_day 
    and a.line in $lines
    and a.action in $actions
