with tbl as (
    select t.ticket,
           t.created,
           t.appeal_flg,
           t.date_tiket_open,
           t.date_tiket_work,
           t.tm_open_flg,
           t.tm_work_flg,
           t.lead_confirmed_flg,
           t.links_tiket,
           t.cw_fixed_flg,
           t.start_cw_date,
           t.deal_id,
           t.open_deal_date,
           t.manager_call_date,
           t.time_telemarketing,
           t.telemarketing_sla,
           t.time_telemarketing_work,
           t.time_monitoring,
           t.monitoring_sla,
           t.time_manager,
           t.manager_sla,
           t.cw_fixed_flg = false and dh.status = 'lost' as reinstated_cw_flg,
           dlf.status = 'lost'                           as status_lost,
           dlf.lost_reason,
           dlf.contract_id,
           dlf.contract_type = 'ОФЕРТА'                  as contract_offerta_flg,
           dlf.manager_group,
           dlf.manager_login,
           dlf.manager_name,
           dlf.channel,
           dlf.tags,
           dlf.potential,
           dlf.corp_client_id,
           dlf.add_date,
           dlf.pipeline_id=18 as phinics_flg,
           sum(case
                   when utc_order_created_dttm between dlf.add_date and dlf.add_date + 30
                       then delivery_point_cnt end)      as cnt_del_30,
           sum(delivery_point_cnt) > 0                   as del_flag

    from snb_b2b.alextitov_logdata994_data t
             left join snb_b2b.niksm_b2b_deals_info_hist dh
                       on dh.deal_id = t.deal_id and dh.snapshot_date = t.start_cw_date::date
             left join snb_b2b.niksm_b2b_deals_info dlf on dlf.deal_id = t.deal_id
             left join taxi_cdm_marketplace.fct_order as fct_cntr on dlf.contract_id = fct_cntr.corp_contract_id and
                                                                     fct_cntr.utc_order_created_dttm >= '2022-01-01'
    group by t.ticket,
             t.created,
             t.appeal_flg,
             t.date_tiket_open,
             t.date_tiket_work,
             t.tm_open_flg,
             t.tm_work_flg,
             t.lead_confirmed_flg,
             t.links_tiket,
             t.cw_fixed_flg,
             t.start_cw_date,
             t.deal_id,
             t.open_deal_date,
             t.manager_call_date,
             t.time_telemarketing,
             t.telemarketing_sla,
             t.time_telemarketing_work,
             t.time_monitoring,
             t.monitoring_sla,
             t.time_manager,
             t.manager_sla,
             t.cw_fixed_flg = false and dh.status = 'lost',
             dlf.status = 'lost',
             dlf.lost_reason,
             dlf.contract_id,
             dlf.contract_type = 'ОФЕРТА',
             dlf.manager_group,
             dlf.manager_login,
             dlf.manager_name,
             dlf.channel,
             dlf.tags,
             dlf.potential,
             dlf.corp_client_id,
             dlf.add_date,
             dlf.pipeline_id=18
)
, tbl2 as (
    select tbl.ticket,
           tbl.created,
           tbl.appeal_flg,
           tbl.date_tiket_open,
           tbl.date_tiket_work,
           tbl.tm_open_flg,
           tbl.tm_work_flg,
           tbl.lead_confirmed_flg,
           tbl.links_tiket,
           tbl.cw_fixed_flg,
           tbl.start_cw_date,
           tbl.deal_id,
           tbl.open_deal_date,
           tbl.manager_call_date,
           tbl.time_telemarketing,
           tbl.telemarketing_sla,
           tbl.time_telemarketing_work,
           tbl.time_monitoring,
           tbl.monitoring_sla,
           tbl.time_manager,
           tbl.manager_sla,
           tbl.reinstated_cw_flg,
           tbl.status_lost,
           tbl.lost_reason,
           tbl.contract_id,
           tbl.contract_offerta_flg,
           tbl.manager_group,
           tbl.manager_login,
           tbl.manager_name,
           tbl.channel,
           tbl.tags,
           tbl.potential,
           tbl.corp_client_id,
           tbl.add_date,
           tbl.phinics_flg,
           coalesce(tbl.cnt_del_30, sum(case
                                            when utc_order_created_dttm between tbl.add_date and tbl.add_date + 30
                                                then delivery_point_cnt end)) as cnt_del_30,
           coalesce(tbl.del_flag, sum(delivery_point_cnt) > 0)                as del_flag
    from tbl
             left join taxi_cdm_marketplace.fct_order as fct_cntr
                       on tbl.contract_id is null and tbl.phinics_flg = true and
                          tbl.corp_client_id = fct_cntr.corp_client_id and
                          fct_cntr.utc_order_created_dttm >= '2022-01-01'
    group by tbl.ticket,
             tbl.created,
             tbl.appeal_flg,
             tbl.date_tiket_open,
             tbl.date_tiket_work,
             tbl.tm_open_flg,
             tbl.tm_work_flg,
             tbl.lead_confirmed_flg,
             tbl.links_tiket,
             tbl.cw_fixed_flg,
             tbl.start_cw_date,
             tbl.deal_id,
             tbl.open_deal_date,
             tbl.manager_call_date,
             tbl.time_telemarketing,
             tbl.telemarketing_sla,
             tbl.time_telemarketing_work,
             tbl.time_monitoring,
             tbl.monitoring_sla,
             tbl.time_manager,
             tbl.manager_sla,
             tbl.reinstated_cw_flg,
             tbl.status_lost,
             tbl.lost_reason,
             tbl.contract_id,
             tbl.contract_offerta_flg,
             tbl.manager_group,
             tbl.manager_login,
             tbl.manager_name,
             tbl.channel,
             tbl.tags,
             tbl.potential,
             tbl.corp_client_id,
             tbl.add_date,
             tbl.phinics_flg,
             tbl.cnt_del_30,
             tbl.del_flag
)
select
tbl.ticket,
             tbl.created,
             tbl.appeal_flg,
             tbl.date_tiket_open,
             tbl.date_tiket_work,
             tbl.tm_open_flg,
             tbl.tm_work_flg,
             tbl.lead_confirmed_flg,
             tbl.links_tiket,
             tbl.cw_fixed_flg,
             tbl.start_cw_date,
             tbl.deal_id,
             tbl.open_deal_date,
             tbl.manager_call_date,
             tbl.time_telemarketing,
             tbl.telemarketing_sla,
             tbl.time_telemarketing_work,
             tbl.time_monitoring,
             tbl.monitoring_sla,
             tbl.time_manager,
             tbl.manager_sla,
             tbl.reinstated_cw_flg,
             case when tbl.status_lost=true then 'Проигранно'
                  when del_flag=true then 'Есть доставки'
                  when contract_id is not null then 'Заключен контракт'
                  when deal_id is not null then 'Переговоры' end as status_deal,
             tbl.lost_reason,
             tbl.contract_id,
             tbl.contract_offerta_flg,
             tbl.manager_group,
             tbl.manager_login,
             tbl.manager_name,
             tbl.channel,
             tbl.tags,
             tbl.potential,
             tbl.corp_client_id,
             tbl.add_date,
             tbl.phinics_flg,
             tbl.cnt_del_30,
             tbl.del_flag
from tbl2 tbl;