--
--drop table if exists snb_b2b.alextitov_logdata994_data;
-- create table snb_b2b.alextitov_logdata994_data as
truncate table snb_b2b.alextitov_logdata994_data;
insert into snb_b2b.alextitov_logdata994_data
with t as (
    select yql.tm_ticket_key as ticket
         , (to_timestamp(yql.tm_created_dttm) at time zone 'Europe/Moscow')::date    created
         , yql. appeal_flg as appeal_flg
         , to_timestamp(yql.tm_open_dttm) at time zone 'Europe/Moscow'    date_tiket_open
         , to_timestamp(yql.tm_work_dttm) at time zone 'Europe/Moscow'    date_tiket_work
         , to_timestamp(yql.tm_lead_confirmed_dttm) at time zone 'Europe/Moscow'  as tm_lead_confirmed_dttm
         , yql.tm_open_flg as tm_open_flg
         , yql.tm_work_flg as tm_work_flg
         , yql.lead_confirmed_flg as lead_confirmed_flg
         , yql.cw_ticket_key  as links_tiket
         , yql.cw_fixed_flg as cw_fixed_flg
         , to_timestamp(yql.cw_created_dttm) at time zone 'Europe/Moscow'      start_cw_date
         , yql.deal_id
         , to_timestamp(EXTRACT(EPOCH FROM coalesce(bdl.add_time,aml.utc_lead_created_dttm)))at time zone 'Europe/Moscow' --+ Interval'3 hours'
             open_deal_date
         , min(case when dl.type = 'call'
                    then  to_timestamp(EXTRACT(EPOCH FROM dl.marked_as_done_time))at time zone 'Europe/Moscow'
                    else null end) as manager_call_date
    from snb_b2b.alextitov_logdata994_ticket_crt as yql
      left join snb_b2b.niksm_b2b_deals_info_ltd as bdl on bdl.deal_id = yql.deal_id and bdl.which_crm = 6
      left join snb_b2b.amo_leads_info as aml on aml.pd_deal_id=yql.deal_id
      left join snb_b2b.voytekh_pd2_activity as dl on dl.deal_id = yql.deal_id and dl.which_crm = 6

    group by yql.tm_ticket_key
         , (to_timestamp(yql.tm_created_dttm) at time zone 'Europe/Moscow')::date
         , yql. appeal_flg
         , to_timestamp(yql.tm_open_dttm) at time zone 'Europe/Moscow'
         , to_timestamp(yql.tm_work_dttm) at time zone 'Europe/Moscow'
         , yql.tm_open_flg
         , yql.tm_work_flg
         , yql.lead_confirmed_flg
         , yql.cw_ticket_key
         , yql.cw_fixed_flg
         , to_timestamp(yql.cw_created_dttm) at time zone 'Europe/Moscow'
         , yql.deal_id
         , to_timestamp(EXTRACT(EPOCH FROM coalesce(bdl.add_time,aml.utc_lead_created_dttm)))at time zone 'Europe/Moscow'
         , to_timestamp(yql.tm_lead_confirmed_dttm) at time zone 'Europe/Moscow'
)
, calend as (
    select calday,
           to_timestamp(EXTRACT(EPOCH FROM(calday + interval '10 hours') at time zone 'Europe/Moscow'))at time zone 'Europe/Moscow' as dttm_from,
           to_timestamp(EXTRACT(EPOCH FROM(calday + interval '19 hours') at time zone 'Europe/Moscow'))at time zone 'Europe/Moscow' as dttm_to
    from snb_delivery.logdata_calendar
    where working_day_flg
)
,tm1 as (
    select ticket
         , created
         , appeal_flg
         , date_tiket_open
         , date_tiket_work
         , tm_lead_confirmed_dttm
         , tm_open_flg
         , tm_work_flg
         , lead_confirmed_flg
         , links_tiket
         , cw_fixed_flg
         , start_cw_date
         , deal_id
         , open_deal_date
         , manager_call_date
         , greatest(sum(greatest(least(date_tiket_work, coalesce(dttm_to, current_date-1000)) -
                        greatest(date_tiket_open, coalesce(dttm_from, current_date)),'0'::interval)), interval '1 min') *((date_tiket_open is not null)::int* appeal_flg::int) time_telemarketing
         , '00:15:00.000000'::interval as  telemarketing_sla
    from t
      left join calend as cl
        on cl.calday between date_tiket_open::date and coalesce(date_tiket_work::date, current_date-1)
    group by  ticket, created, appeal_flg, date_tiket_open, date_tiket_work, tm_open_flg, tm_work_flg, lead_confirmed_flg
           , links_tiket, cw_fixed_flg, start_cw_date, deal_id, open_deal_date, manager_call_date
    ,tm_lead_confirmed_dttm
)

,tm2 as (
    select ticket
         , created
         , appeal_flg
         , date_tiket_open
         , date_tiket_work
         , tm_open_flg
         , tm_work_flg
         , lead_confirmed_flg
         , links_tiket
         , cw_fixed_flg
         , start_cw_date
         , deal_id
         , open_deal_date
         , manager_call_date
         , time_telemarketing
         , telemarketing_sla
         , greatest(sum(greatest(least(coalesce(start_cw_date,tm_lead_confirmed_dttm),coalesce(dttm_to,current_date-1000)) -
                        greatest(date_tiket_work, coalesce(dttm_from,current_date)),'0'::interval)), interval '1 min')*((date_tiket_work is not null)::int) time_telemarketing_work
    from tm1
        left join calend as cl
        on cl.calday between date_tiket_work::date and coalesce(start_cw_date::date,tm_lead_confirmed_dttm::date, current_date - 1)
    group by  ticket, created, appeal_flg, date_tiket_open, date_tiket_work, tm_open_flg, tm_work_flg, lead_confirmed_flg
           , links_tiket, cw_fixed_flg, start_cw_date, deal_id, open_deal_date, manager_call_date
           , time_telemarketing, telemarketing_sla
)
,tm3 as (
    select ticket
         , created
         , appeal_flg
         , date_tiket_open
         , date_tiket_work
         , tm_open_flg
         , tm_work_flg
         , lead_confirmed_flg
         , links_tiket
         , cw_fixed_flg
         , start_cw_date
         , deal_id
         , open_deal_date
         , manager_call_date
         , time_telemarketing
         , telemarketing_sla
         , time_telemarketing_work
         , greatest(sum(greatest(least(open_deal_date,coalesce(dttm_to,current_date-1000)) -
                        greatest(start_cw_date,coalesce(dttm_from,current_date)),'0'::interval)), interval '1 min')*((start_cw_date is not null)::int) time_monitoring
         , '00:15:00.000000'::interval as  monitoring_sla
    from tm2
        left join calend as cl
        on cl.calday between start_cw_date::date and coalesce(open_deal_date::date, current_date - 1)
    group by  ticket, created, appeal_flg, date_tiket_open, date_tiket_work, tm_open_flg, tm_work_flg, lead_confirmed_flg
           , links_tiket, cw_fixed_flg, start_cw_date, deal_id, open_deal_date, manager_call_date
           , time_telemarketing, telemarketing_sla,time_telemarketing_work
)
,tm4 as (
    select ticket
         , created
         , appeal_flg
         , date_tiket_open
         , date_tiket_work
         , tm_open_flg
         , tm_work_flg
         , lead_confirmed_flg
         , links_tiket
         , cw_fixed_flg
         , start_cw_date
         , deal_id
         , open_deal_date
         , manager_call_date
         , date_part('epoch', time_telemarketing) time_telemarketing
         , date_part('epoch', telemarketing_sla ) telemarketing_sla
         , date_part('epoch', time_telemarketing_work ) time_telemarketing_work
         , date_part('epoch',time_monitoring)  time_monitoring
         , date_part('epoch',monitoring_sla) monitoring_sla
         , date_part('epoch',
             greatest(sum(greatest(least(manager_call_date, coalesce(dttm_to,current_date-1000)) -
                        greatest(open_deal_date,coalesce(dttm_from,current_date)),'0'::interval)), interval '1 min')*((open_deal_date is not null)::int)
             )time_manager
         ,  date_part('epoch','00:10:00.000000'::interval) as  manager_sla
    from tm3
           left join calend as cl
             on cl.calday between open_deal_date::date and coalesce(manager_call_date::date, current_date - 1)
    group by ticket, created, appeal_flg, date_tiket_open, date_tiket_work, tm_open_flg, tm_work_flg, lead_confirmed_flg
           , links_tiket, cw_fixed_flg, start_cw_date, deal_id, open_deal_date, manager_call_date
           , time_telemarketing, telemarketing_sla,time_telemarketing_work
           , time_monitoring, monitoring_sla
)
select * from tm4;

