use hahn;
PRAGMA yt.Pool='taxi-delivery';
-- PRAGMA yt.TmpFolder='//home/taxi-delivery/tmp';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- Telemarketing
$TM_issues_path = "home/startrek/tables/prod/yandex-team/queue/TICKETCREATORTE/issues";
$appeal_type_id = '5800d703e4b075c45a1dca92';
$TM_status_dict =
    AsDict(
        AsTuple('open', '4f6b29673004ccc027df1e1c'),
        AsTuple('work', '4f6b29673004ccc027df1e50'),
        AsTuple('lead_confirmed', '57616a42e4b0a65554799da5'),
    );
$TM_events_path = "home/startrek/tables/prod/yandex-team/queue/TICKETCREATORTE/issue_events";


-- CORPWELCOME
$CW_issues_path = "home/startrek/tables/prod/yandex-team/queue/CORPWELCOME/issues";
$CW_type_dict =
    AsDict(
        AsTuple('task', '4f6b271330049b12e72e3f07'),
        AsTuple('serviceRequest', '528b2a00da6a4727b90433b8'),
        AsTuple('bug', '4f6b271330049b12e72e3ef3'),
        AsTuple('incident', '52e66e12e4b0ad52acf75830'),
    );
$CW_resolution_dict =
    AsDict(
        AsTuple('fixed', '4f6b29cc3004e9443e453da7'),
        AsTuple('escalated', '595ba457d4b2614cd0c44ae0'),
        AsTuple('duplicate', '506d8453e4b0840e65b4926b'),
        AsTuple('invalid', '506d8582e4b0840e65b49298'),
        AsTuple('noReply', '5bab62407fc834001bf1fc59'),
        AsTuple('inappropriate', '5bab618f08c13b001ddf3f86'),
    );

$final_res_path ='home/taxi-delivery/analytics/production/b2b/sla_ticket/ticketcreatorte';

$dttm_from_ms = ($ms) -> {RETURN DateTime::MakeDatetime(DateTime::FromMilliseconds($ms))};
$deal_from_link = ($link) -> {RETURN Re2::Capture('((https://yandexdelivery.pipedrive.com/deal/)|(https://yandexdelivery.amocrm.ru/leads/detail/))(\\d+)(([^\\d]+.*)|)$')($link).`_4`};

$TM_tickets = (
    select
        $dttm_from_ms(`created`) as created,
        key as ticket_key,
        id as ticket_id,
        status == DictLookup($TM_status_dict,'open') as open_flg,
        status == DictLookup($TM_status_dict,'work') as work_flg,
        status == DictLookup($TM_status_dict,'lead_confirmed') as lead_confirmed_flg,
        case when type = $appeal_type_id then true else false end as appeal_flg
    FROM $TM_issues_path as tm_issues
    -- where `key` in ('TICKETCREATORTE-50752', 'TICKETCREATORTE-54709','TICKETCREATORTE-58187','TICKETCREATORTE-59633')
);

$TM_events0 = (
    select
        issue as ticket_id,
        Yson::ConvertToString(changes_element.field) as changes_field,
        $dttm_from_ms(`date`) as event_dttm,
        case when Yson::ConvertToString(added_element.relationship) == 'relates'
            then Yson::ConvertToString(added_element.left) else NULL end as links_ticket,
        case when Yson::ConvertToString(added_element.relationship) == 'relates'
            then Yson::ConvertToString(added_element.right) else NULL end as links_ticket2,
        Yson::ConvertToString(changes_element.newValue.value.id) as status_id
    from $TM_events_path as tm_events
    flatten list by (
        case when ListHasItems(Yson::ConvertToList(changes)) then Yson::ConvertToList(changes) else AsList(null) end as changes_element,
        case when ListHasItems(Yson::ConvertToList(links.added)) then Yson::ConvertToList(links.added) else AsList(null) end as added_element
        )
);

$CW_tickets = (
    SELECT `id` as ticket_id,
        `key` as ticket_key,
        `created`,
        customFields,
        `resolution` in (DictLookup($CW_resolution_dict, 'fixed'),
               DictLookup($CW_resolution_dict, 'escalated')) as fixed_flg
    from $CW_issues_path
    where `type` == DictLookup($CW_type_dict, 'task')
    --   and `resolution` in (
    --       DictLookup($CW_resolution_dict, 'fixed'),
    --       DictLookup($CW_resolution_dict, 'escalated'))
);

$TM_events = (
    SELECT ticket_id,
        max(coalesce(cw.ticket_id,cw2.ticket_id)) as cw_ticket_id,                  --  ���� ���� ��� ����� CORPWELCOME �������� 2+ �������
        min(case when changes_field == 'status' and status_id == DictLookup($TM_status_dict,'open') then event_dttm else null end) as tm_open_dttm,
        min(case when changes_field == 'status' and status_id == DictLookup($TM_status_dict,'work') then event_dttm else null end) as tm_work_dttm,
        min(case when changes_field == 'status' and status_id == DictLookup($TM_status_dict,'lead_confirmed') then event_dttm else null end) as tm_lead_confirmed_dttm
    from $TM_events0 as tm
      left join $CW_tickets as cw
        on cw.ticket_id = tm.links_ticket
      left join $CW_tickets as cw2
        on cw2.ticket_id = tm.links_ticket2
    group by tm.ticket_id as ticket_id
);

$final_res = (
    select
        tm_tickets.ticket_id as tm_ticket_id,
        tm_tickets.ticket_key as tm_ticket_key,
        tm_tickets.created as tm_created_dttm,
        tm_tickets.open_flg as tm_open_flg,
        tm_tickets.work_flg as tm_work_flg,
        tm_tickets.lead_confirmed_flg as lead_confirmed_flg,
        tm_tickets.appeal_flg as appeal_flg,
        tm_open_dttm,
        tm_work_dttm,
        tm_lead_confirmed_dttm,
        cw.ticket_key as cw_ticket_key,
        cw.fixed_flg  as cw_fixed_flg,
        $dttm_from_ms(cw.created) as cw_created_dttm,
        cast($deal_from_link(Yson::ConvertToString(customFields.deal)) as int32) as deal_id
    from $TM_tickets as tm_tickets
      left join $TM_events as tm_events
        on tm_events.ticket_id = tm_tickets.ticket_id
      left join $CW_tickets as cw
        on cw.ticket_id = tm_events.cw_ticket_id
);

INSERT INTO $final_res_path WITH TRUNCATE
select * from $final_res;
