import json
import requests
import pandas as pd
import psycopg2
from datetime import *
import csv
import codecs
import sys

import smtplib
import time
import imaplib
import email
import email.header
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication

from yql.api.v1.client import YqlClient
# from receiver_list import *
# from get_cursor import *
import logging

from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader

with open("keys.json") as f:
    from_file = json.load(f)
yt_token = from_file['sam_yt_token']
gp_user = 'robot-sam-bridges'
gp_token = from_file['sam_gp_token']
hahn = HahnDataLoader(token=yt_token)
greenplum = GreenplumManager(user=gp_user, token=gp_token)

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format='%(asctime)s %(levelname)s: %(message)s')

query = """
use hahn;
PRAGMA yt.Pool='taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

select
contract_id,
contract,
manager_code,
country,
region,
contract_type,
payment_type,
start_dt,
finish_dt,
signed_dt,
faxed_dt,
cancelled_dt,
suspended_dt,
is_deactivated,
is_booked,
booked_dt,
client_id,
client,
person_id,
person_name,
person_inn,
person_email,
person_phone,
invoice_id,
invoice,
act_sum,
min_payment_date,
currency,
payment_term,
invoice_payments_sum,
debt00,
debt130,
debt3060,
debt6090,
debtover90,
debt_sum,
bad_debt,
our_fault,
overdue_debt,
clean_debt,
overdue_clean_debt,
manager,
min_payment_date_v2,
no_acts,
contract_services,
cast(debt_service_id as int32) as debt_service_id,
debt_service,
person_kz_bin,
person_kpp
from `//home/taxi-dwh/import/yandex-balance/corporate_contracts_and_debts`
"""

df = hahn(query)
text = 'corporate_contracts_and_debts'
logging.info(f"{text} loaded, df len = {len(df)}")

tn='snb_b2b.voytekh_corporate_contracts_and_debts'
df['debt_service_id']=df['debt_service_id'].fillna("0").astype(int)
greenplum.write(df, table_name=tn,sep=';',index=False)

logging.info('SUCCESS')
