import json
import requests
import pandas as pd
import psycopg2
from datetime import *
import csv
import codecs
import sys

import smtplib
import time
import imaplib
import email
import email.header
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication

from yql.api.v1.client import YqlClient
import logging

from business_models import greenplum, hahn
from business_models.greenplum import GreenplumManager
from business_models.hahn import HahnDataLoader

with open("keys.json") as f:
    from_file = json.load(f)
yt_token = from_file['sam_yt_token']
gp_user = 'robot-sam-bridges'
gp_token = from_file['sam_gp_token']
hahn = HahnDataLoader(token=yt_token)
greenplum = GreenplumManager(user=gp_user, token=gp_token)

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format='%(asctime)s %(levelname)s: %(message)s')

greenplum.replicate(yt_path='//home/taxi-dwh/import/yandex-balance/corporate_contracts_and_debts',
                    table_name='snb_b2b.voytekh_corporate_contracts_and_debts_raw',
                    if_exist='replace',
                    with_truncate=True)

logging.info('SUCCESS')
