drop table if exists temp_b2b_overview;
create temporary table temp_b2b_overview as

select
    'month' as scale,
    a.month as date,
    corp_order_flg,
    c2c_smb_b2b_flg,
    order_source,
    case when sum_deliveries = 1 then '1'
        when sum_deliveries between 2 and 10 then '2-10'
        when sum_deliveries between 11 and 30 then '11-30'
        when sum_deliveries between 31 and 100 then '31-100'
        when sum_deliveries between 101 and 1000 then '101-1000'
        when sum_deliveries > 1000 then '1000+'
            else Null end as bin_deliveries,
    coalesce(c.contract_crm,'Taxi') as contract_crm,
    case when b.user_id_client is not null then 'Y' else 'N' end as has_deliveries,
    count(distinct a.user_id_client) as clients,
    count(distinct a.corp_contract_id) as corp_clients,
    sum(deliveries) as deliveries,
    sum(net_inflow) as net_inflow
from
    snb_delivery.data_bizdev a
    left join snb_delivery.niksm_contract_manager c on c.contract_id = a.corp_contract_id
    left join
    (
        select month, user_id_client, sum(deliveries) as sum_deliveries
        from snb_delivery.data_bizdev
        group by 1,2
        having sum(deliveries)>0
    ) b
        on a.month = b.month
        and a.user_id_client = b.user_id_client
group by
    2,3,4,5,6,7, 8

union all

select
    'week' as scale,
    a.week_start as date,
    corp_order_flg,
    c2c_smb_b2b_flg,
    order_source,
    case when sum_deliveries = 1 then '1'
        when sum_deliveries between 2 and 10 then '2-10'
        when sum_deliveries between 11 and 30 then '11-30'
        when sum_deliveries between 31 and 100 then '31-100'
        when sum_deliveries between 101 and 1000 then '101-1000'
        when sum_deliveries > 1000 then '1000+'
            else Null end as bin_deliveries,
    coalesce(c.contract_crm,'Taxi') as contract_crm,
    case when b.user_id_client is not null then 'Y' else 'N' end as has_deliveries,
    count(distinct a.user_id_client) as clients,
    count(distinct a.corp_contract_id) as corp_clients,
    sum(deliveries) as deliveries,
    sum(net_inflow) as net_inflow
from
    snb_delivery.data_bizdev a
    left join snb_delivery.niksm_contract_manager c on c.contract_id = a.corp_contract_id
    left join
    (
        select week_start, user_id_client, sum(deliveries) as sum_deliveries
        from snb_delivery.data_bizdev
        group by 1,2
        having sum(deliveries)>0
    ) b
        on a.week_start = b.week_start
        and a.user_id_client = b.user_id_client
group by
    2,3,4,5,6,7, 8
;

analyse temp_b2b_overview;

drop table if exists snb_delivery.dash_b2b_overview;
create table snb_delivery.dash_b2b_overview as
select * 
from temp_b2b_overview
;

grant select on snb_delivery.dash_b2b_overview to public;
comment on table snb_delivery.dash_b2b_overview is 'Данные для деша B2B overview. DBI-227';
