
drop table if exists final;

CREATE TEMP TABLE final as
select
    business,
    c2c_smb_b2b_flg,
    client_or_tier,
    holding_name,
    yandex_client,
    date,
    date_lcl,
    country,
    domestic_int,
    city,
    same_or_next_day,
    same_or_next_day_fake,
    os,
    order_source,
    tariff,
    frequency_flag,
    zero_deliveries,
    count(distinct user_id_client) as users,
    sum(deliveries) as deliveries,
    sum(surge_deliveries) as surge_deliveries,
    sum(orders) as orders,
    sum(trips) as trips,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow,
    avg(case when success_order_flg=1 then surge_success end) as surge_success,
    avg(surge_all) as surge_all
from snb_delivery.data_bizdev
group by 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17
DISTRIBUTED RANDOMLY;




drop table if exists same_pvz;
CREATE TEMP TABLE same_pvz as
select
    business,
    c2c_smb_b2b_flg,
    client_or_tier,
    holding_name,
    yandex_client,
    date,
    date_lcl,
    country,
    domestic_int,
    city,
    same_or_next_day,
    os,
    order_source,
    tariff,
    frequency_flag,
    zero_deliveries,
    users,
    deliveries,
    surge_deliveries,
    orders,
    trips,
    gmv,
    gmv_cards,
    commissions,
    subsidies,
    decoupling,
    net_inflow,
    surge_success,
    surge_all
from final
where same_or_next_day_fake in ('Same', 'Next_Pvz') -- эту инфу мы оставляем
DISTRIBUTED RANDOMLY;



-- Next day и K2 корректная часть

drop table if exists next_total_all;
create temp table next_total_all as

select
    business,
    c2c_smb_b2b_flg,
    client_or_tier,
    holding_name,
    yandex_client,
    date,
    date_lcl,
    country,
    domestic_int,
    city,
    same_or_next_day,
    os,
    order_source,
    tariff,
    frequency_flag,
    zero_deliveries,
    users,
    0 as deliveries,
    0 as surge_deliveries,
    0 as orders,
    0 as trips,
    gmv,
    gmv_cards,
    commissions,
    subsidies,
    decoupling,
    net_inflow,
    1 as surge_success,
    1 as surge_all
from
    final
where
    same_or_next_day_fake = 'Next' -- тут осталяем только Лавку, потому что ПВЗ есть в dm_order

union all

select
    'B2B' as business,
    'B2B' as c2c_smb_b2b_flg,
    'Маркет' as client_or_tier,
    'Яндекс' as holding_name,
    'Yandex_client' as yandex_client,
    date_trunc('day', msk_delivered_dttm::date)::date as date,
    date_trunc('day', msk_delivered_dttm::date)::date as date_lcl,
    'Россия' as country,
    'Россия' as domestic_int,
    region_name as city,
    'Next' as same_or_next_day,
    'Other' as os,
    'API' as order_source,
    'K2' as tariff, -- тут исправляем на К2
    'Other' as frequency_flag,
    cast(NULL as varchar) as zero_deliveries,
    1 as users,
    count(distinct market_order_id) filter (where confirmed_flg) as deliveries,
    0 as surge_deliveries,
    count(distinct market_order_id) as orders,
    count(distinct market_order_id) filter (where confirmed_flg) as trips,
    0 as gmv,
    0 as gmv_cards,
    0 as commissions,
    0 as subsidies,
    0 as decoupling,
    0 as net_inflow,
    1 as surge_success,
    1 as surge_all
from
    snb_delivery.dash_k2
where
    pickup_or_lavka = 'lavka'
    and date_trunc('day', msk_delivered_dttm::date) <= (select max(date) from final)
group by
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17

union all

select
    'B2B' as business,
    'B2B' as c2c_smb_b2b_flg,
    'Маркет' as client_or_tier,
    'Яндекс' as holding_name,
    'Yandex_client' as yandex_client,
    date_trunc('day', msk_delivered_dttm::date)::date as date,
    date_trunc('day', msk_delivered_dttm::date)::date as date_lcl,
    'Россия' as country,
    'Россия' as domestic_int,
    region_name as city,
    'Next' as same_or_next_day,
    'Other' as os,
    'API' as order_source,
    'K2' as tariff, -- тут исправляем на К2
    'Other' as frequency_flag,
    cast(NULL as varchar) as zero_deliveries,
    1 as users,
    count(distinct market_order_id) filter (where confirmed_flg) as deliveries,
    0 as surge_deliveries,
    count(distinct market_order_id) as orders,
    count(distinct market_order_id) filter (where confirmed_flg) as trips,
    0 as gmv,
    0 as gmv_cards,
    0 as commissions,
    0 as subsidies,
    0 as decoupling,
    0 as net_inflow,
    1 as surge_success,
    1 as surge_all
from
    snb_delivery.dash_ts
where
    date_trunc('day', msk_delivered_dttm::date) <= (select max(date) from final)
group by
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17

DISTRIBUTED RANDOMLY;



-- NDD корректная часть

drop table if exists ndd_all;
CREATE TEMP TABLE ndd_all as

-- NDD deliveries - смотрим по дате завершения заказа
SELECT distinct
    date_trunc('day', first_day::date)::date as date,
    country,
    city,
    0 as orders,
    count (request_id) as deliveries,
    0 as surge_deliveries,
    count (request_id) as trips
from
    (
        select distinct
            request_id,
            corp_client_id,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(geo.tz_aggl_name_ru, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
                on a.delivery_region = geo.geobase_id
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd_deliveries
group by
    1, 2, 3

union all


-- NDD orders - смотрим по дате заведения заказа
SELECT distinct
    date_trunc('day', order_day::date)::date as date,
    country,
    city,
    count(distinct request_id) as orders,
    0 as deliveries,
    0 as surge_deliveries,
    0 as trips
from
    (
        select distinct
            request_id,
            corp_client_id,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(geo.tz_aggl_name_ru, 'Москва') as city,
            date_trunc('day', created_dttm:: date)::date as order_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
                on a.delivery_region = geo.geobase_id
        where
            date_trunc('day', created_dttm:: date)::date <= current_date - interval '1 day'
    ) ndd_orders
group by
    1, 2, 3
DISTRIBUTED RANDOMLY;



drop table if exists ndd_correct;
CREATE TEMP TABLE ndd_correct as
select
    'B2B' as business,
    'B2B' as c2c_smb_b2b_flg,
    'Other' as client_or_tier,
    '' as holding_name,
    'Other' as yandex_client,
    date,
    date as date_lcl,
    country,
    'Россия' as domestic_int,
    city,
    'Next' as same_or_next_day,
    'Other' as os,
    'API' as order_source,
    'NDD' as tariff,
    'Other' as frequency_flag,
    cast(NULL as varchar) as zero_deliveries,
    1 as users,
    sum(deliveries) as deliveries,
    sum(surge_deliveries) as surge_deliveries,
    sum(orders) as orders,
    sum(trips) as trips,
    0 as gmv,
    0 as gmv_cards,
    0 as commissions,
    0 as subsidies,
    0 as decoupling,
    0 as net_inflow,
    1 as surge_success,
    1 as surge_all
from ndd_all
where date <= (select max(date) from final)
group by 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 22, 23, 24, 25, 26;


drop table if exists snb_delivery.dash_bizdev_business_overview;

create table snb_delivery.dash_bizdev_business_overview as

select * from same_pvz where date is not null
union all
select * from next_total_all where date is not null
union all
select * from ndd_correct where date is not null
;

alter table snb_delivery.dash_bizdev_business_overview
alter column users type float,
alter column deliveries type float,
alter column surge_deliveries type float,
alter column orders type float,
alter column trips type float,
alter column gmv type float,
alter column gmv_cards type float,
alter column commissions type float,
alter column subsidies type float,
alter column decoupling type float,
alter column net_inflow type float,
alter column surge_success type float,
alter column surge_all type float,
add column all_part_date boolean,
add column all_part_date_lcl boolean;

update snb_delivery.dash_bizdev_business_overview
set all_part_date = date_trunc('day',date)::date < date_trunc('day',current_date)::date,
all_part_date_lcl = date_trunc('day',date_lcl)::date < date_trunc('day',current_date)::date;

GRANT SELECT ON snb_delivery.dash_bizdev_business_overview to public;
