use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$retention_table    = '//home/taxi-delivery/analytics/production/taxi_template/go_b2c_retention';
$audience_table     = '//home/taxi-delivery/analytics/production/taxi_template/go_b2c_audience';
$destination_table  = '//home/taxi-delivery/analytics/production/taxi_template/output_audience';


$date_parse         = DateTime::Parse("%Y-%m-%d");
$date_format        = Datetime::Format('%Y-%m-%d');
$end_dt             = Unwrap(DateTime::MakeDate(CurrentUtcDate() - DateTime::IntervalFromDays(7))); -- отправная точка - неделя назад
$start_dt           = Unwrap(DateTime::MakeDate(DateTime::StartOfWeek(Date('2021-01-01'))));


-- формируем список всех дат за заданный период
$all_dates = (
    select
        $date_format(utc_dt) as week_start,
        $date_format(utc_dt+Interval('P6D')) as week_end,
        $date_format(DateTime::MakeDate(DateTime::StartOfMonth(utc_dt))) as month_start,
        rank() over(order by utc_dt desc) as rnk
    from (
        select ListFromRange($start_dt, $end_dt, Interval("P7D")) as utc_dt
        )
    flatten by utc_dt
);

$curr_date          = (select week_start from $all_dates where rnk = 1); --'2022-06-27';
$prev_w_date        = (select week_start from $all_dates where rnk = 2); --'2022-06-20'; для WoW
$prev_2w_date       = (select week_start from $all_dates where rnk = 3); --'2022-06-13'; для 4-недельных спарклайнов
$prev_3w_date       = (select week_start from $all_dates where rnk = 4); --'2022-06-06'; для 4-недельных спарклайнов
$prev_15w_date      = (select week_start from $all_dates where rnk = 16); --''; для ретеншна
$prev_y_date        = (select week_start from $all_dates where rnk = 53); --'2021-06-28'; для YoY
$supply_month_start = (select month_start from $all_dates where rnk = 2); --'2022-06-01'; партиция supply таблицы, чтобы достать данные для WoW



$audience = (
select
    date,
    level,
    geo,
    sum(au) as audience,
    sum_if(au, is_newbies) as newbies
from
    $audience_table as a
group by
    date,
    level,
    geo

);

$audience_with_lag = (
select
    date,
    level,
    geo,
    audience,
    audience/lag(audience) over w - 1 as audience_wow,
    newbies,
    newbies/lag(newbies) over w -1 as newbies_wow
from $audience
window w as (partition by level, geo order by date)
);

$retention_join = (
select
    level,
    geo,
    sum_if(a.wau, a.first_week=b.first_week) as week_0_for_1,
    sum_if(a.wau, a.first_week=c.first_week) as week_0_for_15,
    sum_if(b.wau, a.first_week=b.first_week) as week_1,
    sum_if(c.wau, a.first_week=c.first_week) as week_15,
    sum_if(b.wau, a.first_week=b.first_week)/sum_if(a.wau, a.first_week=b.first_week) as audience_w1_retention,
    sum_if(c.wau, a.first_week=c.first_week)/sum_if(a.wau, a.first_week=c.first_week) as audience_w15_retention
from
(select * from $retention_table where first_week = $prev_15w_date and age_week=0) as a
left join (select * from $retention_table where age_week=1) as b
    on a.level = b.level
    and a.geo = b.geo
    and a.first_week = b.first_week
left join (select * from $retention_table where age_week=15) as c
    on a.level = c.level
    and a.geo = c.geo
    and a.first_week = c.first_week
GROUP BY
    a.level as level,
    a.geo as geo
);


$audience_join = (
SELECT
    level,
    geo,
    audience,
    audience_wow,
    newbies,
	newbies_wow
from $audience_with_lag as a
where date = $curr_date
);

insert into $destination_table with truncate
SELECT
    $curr_date as date,
    a.level as level,
    a.geo as geo,
    audience,
    audience_wow,
    newbies,
	newbies_wow,
    audience_w1_retention,
    audience_w15_retention
from
    $audience_join as a
    inner join $retention_join as r
        on a.level = r.level
        and a.geo = r.geo
