use hahn;
PRAGMA yt.Pool='taxi-delivery';
PRAGMA yson.DisableStrict;
PRAGMA OrderedColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


$main               = '//home/taxi-delivery/analytics/production/taxi_template/main';               -- скопированная с GP таблица c метриками из Business overview
$supply_overview    = '//home/taxi-delivery/analytics/production/product/supply_overview';          -- таблица с метриками по курьерам. Из-за нее 
$supply             = '//home/taxi-delivery/analytics/production/taxi_template/supply';

$source             = '//home/taxi-delivery/analytics/production/taxi_template/by_city';
$destination        = '//home/taxi-delivery/analytics/production/taxi_template/output_ops';

$date_parse         = DateTime::Parse("%Y-%m-%d");
$date_format        = Datetime::Format('%Y-%m-%d');
$end_dt             = Unwrap(DateTime::MakeDate(CurrentUtcDate() - DateTime::IntervalFromDays(7))); -- отправная точка - неделя назад
$start_dt           = Unwrap(DateTime::MakeDate(DateTime::StartOfWeek(Date('2021-01-01'))));


-- формируем список всех дат за заданный период
$all_dates = (
    select
        $date_format(utc_dt) as week_start,
        $date_format(utc_dt+Interval('P6D')) as week_end,
        $date_format(DateTime::MakeDate(DateTime::StartOfMonth(utc_dt))) as month_start,
        rank() over(order by utc_dt desc) as rnk
    from (
        select ListFromRange($start_dt, $end_dt, Interval("P7D")) as utc_dt
        )
    flatten by utc_dt
);

$curr_date          = (select week_start from $all_dates where rnk = 1); --'2022-06-27';
$prev_w_date        = (select week_start from $all_dates where rnk = 2); --'2022-06-20'; для WoW
$prev_2w_date       = (select week_start from $all_dates where rnk = 3); --'2022-06-13'; для 4-недельных спарклайнов
$prev_3w_date       = (select week_start from $all_dates where rnk = 4); --'2022-06-06'; для 4-недельных спарклайнов
$prev_y_date        = (select week_start from $all_dates where rnk = 53); --'2021-06-28'; для YoY
$supply_month_start = (select month_start from $all_dates where rnk = 2); --'2022-06-01'; партиция supply таблицы, чтобы достать данные для WoW
$prev_15w_date      = (select week_start from $all_dates where rnk = 16);
$curr_date_end      = (select week_end from $all_dates where rnk = 1);

-- очень важный гео меппинг, специально для деша
$geo = (

    select distinct
        name_en,
        name_ru,
        case
            when population_group in ('RU_1M+','RU_500K+','RU_300K+') then name_en
            when population_group in ('RU_200K+','RU_100K+','RU_50K+','RU_50K-') then 'RU_other'
            else 'Other' end as agglomeration_name,
        case
            when population_group in ('RU_MSC','RU_SPB','RU_1M+','RU_500K+','RU_300K+') then population_group
            when population_group in ('RU_200K+','RU_100K+','RU_50K+','RU_50K-') then 'RU_other'
            else 'Other'
            end as population_group,
        tz_country_name_en as country,
        tz_country_name_ru as country_ru,
        case
            when tz_country_name_ru in ('Россия') then 'Russia'
            when tz_country_name_ru in ('Казахстан','Белоруссия','Азербайджан','Армения','Грузия','Киргизия','Молдавия','Узбекистан') then 'CIS'
            else 'International'
            end as country_group1,
        case
            when tz_country_name_ru in ('Россия')
            then 'Russia'
            else 'CIS+Int' 
            end as country_group2
    from
        `//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy` as g
    where
        root_node_id = 'br_root'
        and node_type = 'agglomeration'

);



-- собираем сорс по курьерским метрикам SH TPH
insert into $supply with truncate
select 
    utc_date,
    agglomeration,
    population_group,
    country,
    'Express' as tariff,
    SUM(driver_net_income_cargo+driver_net_income_courier+driver_net_income_express+driver_net_income_other_delivery+driver_net_income_taxi) as money_total,
    SUM_IF(driver_net_income_cargo+driver_net_income_courier+driver_net_income_express+driver_net_income_other_delivery+driver_net_income_taxi,
            transport_type in ('Скорее Такси','Скорее Авто-Курьер','Строго Авто-Курьер')) as money_auto,
    SUM_IF(driver_net_income_cargo+driver_net_income_courier+driver_net_income_express+driver_net_income_other_delivery+driver_net_income_taxi,
            transport_type in ('Велосипед','Мотоцикл')) as money_moto,
    SUM_IF(driver_net_income_cargo+driver_net_income_courier+driver_net_income_express+driver_net_income_other_delivery+driver_net_income_taxi,
            transport_type like 'Грузовой%') as money_cargo,
    SUM_IF(driver_net_income_cargo+driver_net_income_courier+driver_net_income_express+driver_net_income_other_delivery+driver_net_income_taxi,
            transport_type in ('Пешеход')) as money_walk,

    SUM(number_of_trips_cargo+number_of_trips_courier+number_of_trips_express+number_of_trips_other_delivery+number_of_trips_taxi) as trips_total,
    SUM_IF(number_of_trips_cargo+number_of_trips_courier+number_of_trips_express+number_of_trips_other_delivery+number_of_trips_taxi,
            transport_type in ('Скорее Такси','Скорее Авто-Курьер','Строго Авто-Курьер')) as trips_auto,
    SUM_IF(number_of_trips_cargo+number_of_trips_courier+number_of_trips_express+number_of_trips_other_delivery+number_of_trips_taxi,
            transport_type in ('Велосипед','Мотоцикл')) as trips_moto,
    SUM_IF(number_of_trips_cargo+number_of_trips_courier+number_of_trips_express+number_of_trips_other_delivery+number_of_trips_taxi,
            transport_type like 'Грузовой%') as trips_cargo,
    SUM_IF(number_of_trips_cargo+number_of_trips_courier+number_of_trips_express+number_of_trips_other_delivery+number_of_trips_taxi,
            transport_type in ('Пешеход')) as trips_walk,

    SUM(sh_day+sh_night+sh_evening+sh_morning) as sh_total,
    SUM_IF(sh_day+sh_night+sh_evening+sh_morning, transport_type in ('Скорее Такси','Скорее Авто-Курьер','Строго Авто-Курьер')) as sh_auto,
    SUM_IF(sh_day+sh_night+sh_evening+sh_morning, transport_type in ('Велосипед','Мотоцикл')) as sh_moto,
    SUM_IF(sh_day+sh_night+sh_evening+sh_morning, transport_type like 'Грузовой%') as sh_cargo,
    SUM_IF(sh_day+sh_night+sh_evening+sh_morning, transport_type in ('Пешеход')) as sh_walk

from
    range($supply_overview, $supply_month_start) as s
    inner join $geo as g
        on g.name_ru = s.agglomeration
where
    agglomeration is not null and utc_date is not null
group by
    s.utc_date as utc_date,
    g.name_en as agglomeration,
    s.population_group as population_group,
    s.country as country
;
commit;




-- собираем основные метрики и курьерские метрики
insert into $source with truncate
select 
    date,
    tariff,
    city,
    country_group2,
    country_group1,
    country,
    population_group,
    agglomeration_name,
    sum(orders) as orders,
    sum(a.trips) as trips,
    sum(deliveries) as deliveries,
    sum(surge) as surge,
    sum(gmv) as gmv,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow,
    sum(money_total) as money_total,
    sum(money_auto) as money_auto,
    sum(money_moto) as money_moto,
    sum(money_cargo) as money_cargo,
    sum(money_walk) as money_walk,
    sum(sh_total) as sh_total,
    sum(sh_auto) as sh_auto,
    sum(sh_moto) as sh_moto,
    sum(sh_cargo) as sh_cargo,
    sum(sh_walk) as sh_walk,
    sum(trips_total) as trips_total,
    sum(trips_auto) as trips_auto,
    sum(trips_moto) as trips_moto,
    sum(trips_cargo) as trips_cargo,
    sum(trips_walk) as trips_walk
from
    $main as a
    left join $geo as g
        on a.city = g.name_en
    left join $supply as b
        on a.city = b.agglomeration
        and a.date = b.utc_date
        and a.tariff = b.tariff
where
    $date_format(DateTime::StartOfWeek($date_parse(a.date))) in ($curr_date,$prev_w_date,$prev_2w_date,$prev_3w_date,$prev_y_date)
group by
    coalesce($date_format(DateTime::StartOfWeek($date_parse(a.date))), $date_format(DateTime::StartOfWeek($date_parse(b.utc_date)))) as date,
    a.tariff as tariff,
    a.city as city,
    coalesce(g.country_group2,'CIS+Int') as country_group2,
    coalesce(g.country_group1,'International') as country_group1,
    coalesce(g.country,'Turkey') as country,
    coalesce(g.population_group, 'Other') as population_group,
    coalesce(g.agglomeration_name, 'Other') as agglomeration_name
;
commit;


-- раскладываем таблицу по датам для джойна
$curr = (select * from $source where date = $curr_date);
$prev_w = (select * from $source where date = $prev_w_date);
$prev_2w = (select * from $source where date = $prev_2w_date);
$prev_3w = (select * from $source where date = $prev_3w_date);
$prev_y = (select * from $source where date = $prev_y_date);


-- джойним в одну таблицу все сосрсовые метрики, включая исторически (для спарклайнов)
$select = (
select 
    tariff,
    city,
    country_group2,
    country_group1,
    country,
    population_group,
    agglomeration_name,
    sum(c.deliveries) as deliveries,
    sum(w.deliveries) as deliveries_prev_w,
    sum(w2.deliveries) as deliveries_prev_2w,
    sum(w3.deliveries) as deliveries_prev_3w,
    sum(y.deliveries) as deliveries_prev_y,    
    sum(c.surge) as surge,
    sum(w.surge) as surge_prev_w,
    sum(c.gmv) as gmv,
    sum(w.gmv) as gmv_prev_w,
    sum(w2.gmv) as gmv_prev_2w,
    sum(w3.gmv) as gmv_prev_3w,
    sum(c.trips) as trips,
    sum(w.trips) as trips_prev_w,
    sum(c.orders) as orders,
    sum(c.net_inflow) as net_inflow,
    sum(w.net_inflow) as net_inflow_prev_w,
    sum(w2.net_inflow) as net_inflow_prev_2w,
    sum(w3.net_inflow) as net_inflow_prev_3w,
    sum(c.gmv/case country 
            when 'Russia' then 1.2
            when 'Armenia' then 1.2
            when 'Azerbaijan' then 1.18
            when 'Belarus' then 1.2
            when 'Cameroon' then 1.1925
            when 'Chile' then 1.19
            when 'Finland' then 1.24
            when 'Georgia' then 1.18
            when 'Israel' then 1.17
            when 'Ivory Coast' then 1.18
            when 'Kazakhstan' then 1.12
            when 'Kyrgyzstan' then 1.12
            when 'Mexico' then 1.08
            when 'Moldova' then 1.2
            when 'Peru' then 1.18
            when 'Senegal' then 1.18
            when 'Serbia' then 1.2
            when 'South Africa' then 1.14
            when 'Turkey' then 1.18
            when 'UAE' then 1.05
            when 'Uzbekistan' then 1.15
            else 1 end - coalesce(c.commissions,0) + coalesce(c.subsidies,0) - coalesce(c.decoupling,0)) as cost_of_delivery,


    sum(c.money_total) as money_total,
    sum(c.money_auto) as money_auto,
    sum(c.money_cargo) as money_cargo,
    sum(c.money_moto) as money_moto,
    sum(c.money_walk) as money_walk,

    sum(c.sh_total) as sh_total,
    sum(c.sh_auto) as sh_auto,
    sum(c.sh_cargo) as sh_cargo,
    sum(c.sh_moto) as sh_moto,
    sum(c.sh_walk) as sh_walk,

    sum(c.trips_total) as trips_total,
    sum(c.trips_auto) as trips_auto,
    sum(c.trips_cargo) as trips_cargo,
    sum(c.trips_moto) as trips_moto,
    sum(c.trips_walk) as trips_walk,


    sum(w.money_total) as money_total_prev_w,
    sum(w.money_auto) as money_auto_prev_w,
    sum(w.money_cargo) as money_cargo_prev_w,
    sum(w.money_moto) as money_moto_prev_w,
    sum(w.money_walk) as money_walk_prev_w,

    sum(w.sh_total) as sh_total_prev_w,
    sum(w.sh_auto) as sh_auto_prev_w,
    sum(w.sh_cargo) as sh_cargo_prev_w,
    sum(w.sh_moto) as sh_moto_prev_w,
    sum(w.sh_walk) as sh_walk_prev_w,

    sum(w.trips_total) as trips_total_prev_w,
    sum(w.trips_auto) as trips_auto_prev_w,
    sum(w.trips_cargo) as trips_cargo_prev_w,
    sum(w.trips_moto) as trips_moto_prev_w,
    sum(w.trips_walk) as trips_walk_prev_w

from
    $curr as c
    left join $prev_w as w
        on c.city = w.city
        and c.tariff = w.tariff
    left join $prev_2w as w2
        on c.city = w2.city
        and c.tariff = w2.tariff
    left join $prev_3w as w3
        on c.city = w3.city
        and c.tariff = w3.tariff
    left join $prev_y as y
        on y.city = c.city
        and y.tariff = c.tariff
group by
    c.tariff as tariff,
    c.city as city,
    c.country_group2 as country_group2,
    c.country_group1 as country_group1,
    c.country as country,
    c.population_group as population_group,
    c.agglomeration_name as agglomeration_name
);


-- таблица 1: union all, все метрики посчитаны заранее на кджом уровне иерархии
insert into $destination WITH TRUNCATE

select
    $curr_date as date,
    'level 6' as level,
    geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    tariff,
    agglomeration_name as geo

union all


select
    $curr_date as date,
    'level 5' as level,
    geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    population_group as geo,
    tariff

union all

select
    $curr_date as date,
    'level 4' as level,
    geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    country as geo,
    tariff

union all

select
    $curr_date as date,
    'level 3' as level,
    geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    country_group1 as geo,
    tariff

union all

select
    $curr_date as date,
    'level 2' as level,
    geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    country_group2 as geo,
    tariff

union all

select
    $curr_date as date,
    'level 1' as level,
    'TOTAL' as geo,
    tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a
group by
    tariff

union all


select
    $curr_date as date,
    'level 0' as level,
    'TOTAL' as geo,
    'TOTAL' as tariff,
    sum(deliveries) as deliveries,
    sum(deliveries_prev_w) as deliveries_prev_w,
    sum(deliveries_prev_2w) as deliveries_prev_2w,
    sum(deliveries_prev_3w) as deliveries_prev_3w,
    sum(deliveries)/sum(deliveries_prev_w)-1 as deliveries_wow,
    sum(deliveries)/sum(deliveries_prev_y) as deliveries_yoy,    
    sum(surge)/sum(trips) as surge,
    sum(surge)/sum(trips)/(sum(surge_prev_w)/sum(trips_prev_w))-1 as surge_wow,
    sum(gmv) as gmv,
    sum(gmv)/sum(gmv_prev_w)-1 as gmv_wow,
    sum(gmv)/sum(deliveries) as fare,
    sum(trips)/sum(orders) as cr,
    sum(net_inflow) as net_inflow,
    sum(net_inflow)-sum(net_inflow_prev_w) as net_inflow_wow,
    sum(net_inflow)/sum(gmv) as ni_gmv,
    sum(net_inflow_prev_w)/sum(gmv_prev_w) as ni_gmv_prev_w,
    sum(net_inflow_prev_2w)/sum(gmv_prev_2w) as ni_gmv_prev_2w,
    sum(net_inflow_prev_3w)/sum(gmv_prev_3w) as ni_gmv_prev_3w,
    sum(cost_of_delivery) as cost_of_delivery,
    sum(cost_of_delivery)/sum(deliveries) as cpo,

    sum(money_total)/sum(sh_total) as mph_total,
    sum(money_auto)/sum(sh_auto) as mph_auto,
    sum(money_cargo)/sum(sh_cargo) as mph_cargo,
    sum(money_moto)/sum(sh_moto) as mph_moto,
    sum(money_walk)/sum(sh_walk) as mph_walk,

    sum(money_total)/sum(sh_total) / sum(money_total_prev_w)*sum(sh_total_prev_w) - 1 as mph_total_wow,
    sum(money_auto)/sum(sh_auto) / sum(money_auto_prev_w)*sum(sh_auto_prev_w) - 1 as mph_auto_wow,
    sum(money_cargo)/sum(sh_cargo) / sum(money_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as mph_cargo_wow,
    sum(money_moto)/sum(sh_moto) / sum(money_moto_prev_w)*sum(sh_moto_prev_w) - 1 as mph_moto_wow,
    sum(money_walk)/sum(sh_walk) / sum(money_walk_prev_w)*sum(sh_walk_prev_w) - 1 as mph_walk_wow,

    sum(trips_total)/sum(sh_total) as tph_total,
    sum(trips_auto)/sum(sh_auto) as tph_auto,
    sum(trips_cargo)/sum(sh_cargo) as tph_cargo,
    sum(trips_moto)/sum(sh_moto) as tph_moto,
    sum(trips_walk)/sum(sh_walk) as tph_walk,

    sum(trips_total)/sum(sh_total) / sum(trips_total_prev_w)*sum(sh_total_prev_w) - 1 as tph_total_wow,
    sum(trips_auto)/sum(sh_auto) / sum(trips_auto_prev_w)*sum(sh_auto_prev_w) - 1 as tph_auto_wow,
    sum(trips_cargo)/sum(sh_cargo) / sum(trips_cargo_prev_w)*sum(sh_cargo_prev_w) - 1 as tph_cargo_wow,
    sum(trips_moto)/sum(sh_moto) / sum(trips_moto_prev_w)*sum(sh_moto_prev_w) - 1 as tph_moto_wow,
    sum(trips_walk)/sum(sh_walk) / sum(trips_walk_prev_w)*sum(sh_walk_prev_w) - 1 as tph_walk_wow
from $select as a

;

