import pandas as pd
import numpy as np
from business_models import hahn, greenplum
import sys
import datetime
from datetime import date, timedelta
import os

query = """

use hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yson.DisableStrict;
PRAGMA OrderedColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;



insert into `//home/taxi-delivery/analytics/production/taxi_template/output_total_non_additive` with truncate
select
    coalesce(op.date, cr.date, au.date, cl.calweek) as date,
    coalesce(op.level, cr.level, au.level, cl.level) as level,
    coalesce(op.geo, cr.geo, au.geo, cl.geo_name) as geo,
    coalesce(op.tariff, cr.tariff, au.tariff, cl.tariff) as tariff,

    -- ops block
    deliveries,
    deliveries_prev_w,
    deliveries_prev_2w,
    deliveries_prev_3w,
    deliveries_wow,
    deliveries_yoy,    
    surge,
    surge_wow,
    gmv,
    gmv_wow,
    fare,
    cr,
    net_inflow,
    net_inflow_wow,
    ni_gmv,
    ni_gmv_prev_w,
    ni_gmv_prev_2w,
    ni_gmv_prev_3w,
    cost_of_delivery,
    cpo,

    mph_total,
    mph_auto,
    mph_cargo,
    mph_moto,
    mph_walk,

    mph_total_wow,
    mph_auto_wow,
    mph_cargo_wow,
    mph_moto_wow,
    mph_walk_wow,

    tph_total,
    tph_auto,
    tph_cargo,
    tph_moto,
    tph_walk,

    tph_total_wow,
    tph_auto_wow,
    tph_cargo_wow,
    tph_moto_wow,
    tph_walk_wow,

    -- couriers block

    couriers_total,
    couriers_total_prev,
    couriers_total_wow,
    new_couriers,
    new_couriers_prev,
    new_couriers_wow,
    couriers_core,
    couriers_auto,
    couriers_moto,
    couriers_cargo,
    couriers_walk,

    -- audience block
    audience,
    audience_wow,
    newbies,
	newbies_wow,
    audience_w1_retention,
    audience_w15_retention,

    -- clients block
    clients_cnt,
    clients_cnt_wow,
    clients_new_cnt,
    clients_new_cnt_wow,
    clients_cnt_15_prev,
    clients_cnt_15_prev_w1_retention,
    clients_cnt_15_prev_w15_retention    

from
     `//home/taxi-delivery/analytics/production/taxi_template/output_ops` as op
    
    full join (select a.*, 'Express' as tariff from `//home/taxi-delivery/analytics/production/taxi_template/output_couriers` as a) as cr
        on op.level = cr.level
        and op.geo = cr.geo
        and op.tariff = cr.tariff
        and op.date = cr.date
    full join (select a.*, 'Express' as tariff from `//home/taxi-delivery/analytics/production/taxi_template/output_audience` as a) as au
        on op.level = au.level
        and op.geo = au.geo
        and op.tariff = au.tariff
        and op.date = au.date
    full join (select a.*, 'Express' as tariff from `//home/taxi-delivery/analytics/production/taxi_template/output_clients` as a) as cl
        on op.level = cl.level
        and op.geo = cl.geo_name
        and op.tariff = cl.tariff
        and op.date = cl.calweek;

commit;


select *
from `//home/taxi-delivery/analytics/production/taxi_template/output_total_non_additive`
where date = cast(DateTime::MakeDate(DateTime::StartOfWeek(CurrentUtcDate() - DateTime::IntervalFromDays(7))) as string)
order by level, geo;

"""

df = hahn(query)

today = datetime.date.today()
weekday = today.weekday()
start_delta = datetime.timedelta(days=weekday, weeks=1)
suffix = (today - start_delta).strftime('%Y%m%d')
filename = 'Delivery_dashboard_{}.xlsx'.format(suffix)

df.to_excel(filename, index=False)



from business_models.startrek import StartrekWrapper

st = StartrekWrapper()

st.comment('DBI-211', text=u"", attachments=filename, summonees = 'ustinenko')

os.remove(filename)
del(df)
