drop table if exists geo;
create temp table geo as

select
    tariff_zone,
    name_en,
    name_ru,
    case when population_group in ('RU_1M+','RU_500K+','RU_300K+') then name_en end as agglomeration_name,
    case
        when population_group in ('RU_MSC','RU_SPB','RU_1M+','RU_500K+','RU_300K+') then population_group
        when population_group in ('RU_200K+','RU_100K+','RU_50K+','RU_50K-') then 'RU_other'
        else 'Other'
        end as population_group,
    tz_country_name_en as country,
    case
        when tz_country_name_ru in ('Россия') then 'Russia'
        when tz_country_name_ru in ('Казахстан','Белоруссия','Азербайджан','Армения','Грузия','Киргизия','Молдавия','Узбекистан') then 'CIS'
        else 'International' end as country_group1,
    case
        when tz_country_name_ru in ('Россия')
        then 'Russia'
        else 'CIS+Int' end as country_group2
from taxi_cdm_geo.v_dim_full_geo_hierarchy
where
    root_node_id = 'br_root'
    and node_type = 'agglomeration'

DISTRIBUTED RANDOMLY;
ANALYZE geo;



drop table if exists c2c_id;
create temp table c2c_id as

SELECT
    fo.user_phone_pd_id as user_phone_pd_id,
    fo.order_source_code as order_source_code,
    fo.tariff_geo_zone_code as tariff_geo_zone_code,
    geo.country_group2 as country_group2,
    geo.country_group1 as country_group1,
    geo.country as country,
    geo.population_group as population_group,
    geo.agglomeration_name as agglomeration_name,
    (fo.utc_order_created_dttm + INTERVAL '3 hours') as msk_order_created_dttm,
    DATE_TRUNC('week', (fo.utc_order_created_dttm + INTERVAL '3 hours'))::DATE AS week

from taxi_cdm_marketplace.fct_order as fo
left join geo on geo.tariff_zone = fo.tariff_geo_zone_code
where 1=1
    and ((fo.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp'))
    or (fo.tariff_class_code = 'ubernight' and fo.msk_order_created_dttm >= '2021-09-01') -- пока только Доставка и Грузовой
    or (fo.tariff_class_code = 'uberlux' and fo.utc_order_created_dttm >= '2022-03-01'))
    and (fo.utc_order_created_dttm + INTERVAL '3 hours')::DATE BETWEEN '2019-01-01' AND (CURRENT_DATE - INTERVAL '1 day')

    AND fo.delivery_point_cnt > 0
    AND NOT fo.fake_order_flg
    AND NOT fo.mqc_order_flg
    AND NOT fo.user_fraud_flg
    AND fo.order_id not in (select order_id from snb_delivery.self_orders)

    and fo.corp_client_id is null
    and not fo.corp_order_flg

DISTRIBUTED RANDOMLY;
ANALYZE c2c_id;



drop table if exists first_order_source_code;
create temp table first_order_source_code as

select
    c2c_id.*,
    first_value (c2c_id.order_source_code) over
        (partition by
                c2c_id.user_phone_pd_id
        order by c2c_id.msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_order_source
from c2c_id

DISTRIBUTED RANDOMLY;
ANALYZE first_order_source_code;



drop table if exists first_values;
create temp table first_values as

select
    *,

    first_value (week) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_week,

    first_value (country_group2) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_country_group2,

    first_value (country_group1) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_country_group1,

    first_value (country) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_country,

    first_value (population_group) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_population_group,

    first_value (agglomeration_name) over
        (partition by
                user_phone_pd_id
        order by msk_order_created_dttm
        range between unbounded preceding and unbounded following) as first_agglomeration_name

from first_order_source_code
where 1=1
    and first_order_source in ('yandex', 'cargo')
    and order_source_code in ('yandex', 'cargo')

DISTRIBUTED RANDOMLY;
ANALYZE first_values;



drop table if exists final_total;
create temp table final_total as

select
    'week'::text as scale,
    'level 1'::text as level,
    'TOTAL'::text as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_total;



drop table if exists final_country_group2;
create temp table final_country_group2 as

select
    'week'::text as scale,
    'level 2'::text as level,
    country_group2 as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        country_group2,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values
    where first_country_group2 = country_group2) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_country_group2;



drop table if exists final_country_group1;
create temp table final_country_group1 as

select
    'week'::text as scale,
    'level 3'::text as level,
    country_group1 as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        country_group1,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values
    where first_country_group1 = country_group1) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_country_group1;



drop table if exists final_country;
create temp table final_country as

select
    'week'::text as scale,
    'level 4'::text as level,
    country as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        country,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values
    where first_country = country) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_country;



drop table if exists final_population_group;
create temp table final_population_group as

select
    'week'::text as scale,
    'level 5'::text as level,
    population_group as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        population_group,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values
    where first_population_group = population_group) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_population_group;



drop table if exists final_agglomeration_name;
create temp table final_agglomeration_name as

select
    'week'::text as scale,
    'level 6'::text as level,
    agglomeration_name as geo,
    first_week,
    age_week::float,
    count(distinct user_phone_pd_id)::float as wau
from
    (select
        user_phone_pd_id,
        agglomeration_name,
        week,
        first_week,
        ((week - first_week)/7) AS age_week
    from first_values
    where first_agglomeration_name = agglomeration_name) as t1
where not week >= date_trunc('week', NOW())
group by 1, 2, 3, 4, 5

DISTRIBUTED RANDOMLY;
ANALYZE final_agglomeration_name;



drop table if exists snb_delivery.go_b2c_retention_taxi_template;
create table snb_delivery.go_b2c_retention_taxi_template as

select * from final_total
union all
select * from final_country_group2
union all
select * from final_country_group1
union all
select * from final_country
union all
select * from final_population_group
union all
select * from final_agglomeration_name

DISTRIBUTED RANDOMLY;
ANALYZE snb_delivery.go_b2c_retention_taxi_template;
