-- RU REGIONS WITH SPECIAL OPTIONS FOR MOSCOW & SPB
drop table if exists ru_geo;
create temp table ru_geo as
select geo.tariff_zone,
       geo.tz_aggl_name_ru,
       coalesce(
               coalesce(mow.name_en, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region end),
               geo.name_en) as region,
       coalesce(
               coalesce(mow.name_ru, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region_ru end),
               geo.name_ru) as region_ru
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
         left join (select distinct tariff_zone, name_en, name_ru
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('Moscow (Middle Region)', 'Moscow (Near Region)', 'Moscow (adm)', 'Far Moscow Region')) as mow
                   on geo.tariff_zone = mow.tariff_zone
         left join (select min(name_en) as region, min(name_ru) as region_ru, tariff_zone
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('SPb and SPb region', 'Saint-Petersburg (adm)')
                    group by tariff_zone) as spb
                   on geo.tariff_zone = spb.tariff_zone
where geo.tag_list = '{federal district}'
;

-- FULL HIERARCHY WITH RUSSIAN REGIONS
drop table if exists regions_geo;
create temp table regions_geo as
select
    h.tariff_zone,
    h.geobase_id,
    h.name_ru,
    h.name_en as tz_aggl_name_en,
    h.tz_country_name_en,
    coalesce(region, h.tz_country_name_ru) as region_name_ru,
    coalesce(region, h.tz_country_name_en) as region_name_en,
    total_population,
    population_group
from
     core_cdm_geo.v_dim_full_geo_hierarchy h
     left join ru_geo r
               on r.tariff_zone = h.tariff_zone
where
    h.node_type = 'agglomeration'
    and h.root_node_id = 'br_root';







drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

with a as (
         select msk_claim_created_dttm::date as date,
                c.country,
                c.region_name_en as region,
                c.city_en as city,
                c.population_group,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from
            snb_delivery.dash_k2 a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                population_group,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then name_ru || ' (adm)' else region_name_ru end as region_name_ru,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         where pickup_or_lavka = 'lavka'
         group by 1, 2, 3, 4, 5

         union all

         select msk_claim_created_dttm::date as date,
                c.country,
                c.region_name_en as region,
                c.city_en as city,
                c.population_group,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                population_group,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         group by 1, 2, 3, 4, 5
     )
select
    date,
    'NDD'::text as tariff,
    country,
    region,
    city,
    population_group,
    'INTERCO'::text as tier,
    sum(deliveries) as orders,
    sum(deliveries) as deliveries,
    sum(deliveries) as trips,
    sum(deliveries) as surge,
    sum(0) as gmv,
    sum(0) as commissions,
    sum(0) as subsidies,
    sum(0) as decoupling,
    sum(0) as net_inflow
from a
where date < current_date
group by 1,2,3,4,5,6

;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as date,
    'NDD' as tariff,
    country,
    region,
    city,
    population_group,
   case
       when manager_metagroup = 'INTERCO' then 'INTERCO'
       when manager_metagroup = 'Тир 1' then 'Tier 1'
       when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
       when manager_metagroup = 'Тир 3' then 'Tier 3'
       when manager_metagroup is null then 'B2B Platform'
       else 'Tier 4'
       end as tier,
    count(distinct request_id) as orders,
    count(distinct request_id) as deliveries,
    count(distinct request_id) as trips,
    count(distinct request_id) as surge,
    sum(0) as gmv,
    sum(0) as commissions,
    sum(0) as subsidies,
    sum(0) as decoupling,
    sum(0) as net_inflow

from
    (
        select distinct
            request_id,
            a.corp_client_id,
            mangr.manager_metagroup,
            coalesce(c.country,'Russia') as country,
            coalesce(c.region_name_en,'Moscow') as region,
            coalesce(geo.tz_aggl_name_en,'Moscow') as city,
            coalesce(c.population_group,'RU_MSC') as population_group,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join (select geobase_id, max(tz_aggl_name_ru) as tz_aggl_name_ru, max(tz_aggl_name_en) as tz_aggl_name_en
            from core_cdm_geo.v_dim_fi_geo_hierarchy group by 1) geo
                on a.delivery_region = geo.geobase_id
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                population_group,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on geo.tz_aggl_name_ru = c.city_ru
            left join
                (
                    select corp_client_id, max(manager_metagroup) as manager_metagroup
                    from snb_delivery.niksm_contract_manager
                    group by 1
                ) as mangr
                on mangr.corp_client_id = a.corp_client_id
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
where first_day < current_date
group by
    1,2,3,4,5,6,7;



drop table if exists final;
create temp table final as
    select date,
           case
               when tariff = 'K2' then 'NDD' else tariff
               end::text as tariff,
           coalesce(b.tz_country_name_en,c2.country_en) as country,
           coalesce(b.region_name_en,'') as region,
           coalesce(c.city_en,'') as city,
           coalesce(c.population_group,'') as population_group,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(orders)                             as orders,
           sum(deliveries)                       as deliveries,
           sum(trips)                           as trips,
           sum(case when success_order_flg=1 then surge_success end) as surge,
           sum(gmv)                              as gmv,
           sum(commissions)                     as commissions,
           sum(subsidies)                       as subsidies,
           sum(decoupling)                      as decoupling,
           sum(net_inflow)                       as net_inflow
    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
        left join (select distinct on (name_ru) name_ru as city, tz_aggl_name_en as city_en, population_group from regions_geo) c
            on a.city = c.city
        left join (select distinct on (region_name_en) region_name_en as country_en, region_name_ru as country_ru from regions_geo) c2
            on a.country = c2.country_ru
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
--         same_or_next_day_fake in ('Same')
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select date,
           'NDD' as tariff,
           coalesce(b.tz_country_name_en,'Russia') as country,
           coalesce(b.region_name_en,'Moscow') as region,
           coalesce(c.city_en,'Москва') as city,
           coalesce(c.population_group,'RU_MSC') as population_group,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(0)                               as orders,
           sum(0)                               as deliveries,
           sum(0)                               as trips,
           sum(0)                               as surge,
           sum(gmv)                              as gmv,
           sum(commissions)                     as commissions,
           sum(subsidies)                       as subsidies,
           sum(decoupling)                      as decoupling,
           sum(net_inflow)                       as net_inflow

    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
        left join (select distinct on (name_ru) name_ru as city, tz_aggl_name_en as city_en, population_group from regions_geo) c
            on a.city = c.city
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select
        date,
        tariff,
        country,
        region,
        city,
        population_group,
        tier,
        orders,
        deliveries,
        trips,
        surge,
        gmv,
        commissions,
        subsidies,
        decoupling,
        net_inflow
    from ndd_market_lavka

    union all

    select
        date,
        tariff,
        country,
        region,
        city,
        population_group,
        tier,
        orders,
        deliveries,
        trips,
        surge,
        gmv,
        commissions,
        subsidies,
        decoupling,
        net_inflow
    from ndd_deliveries
;


drop table if exists snb_delivery.sm91189_dash_for_danya;
create table snb_delivery.sm91189_dash_for_danya as
select
    date,
    case when tariff = 'NDD' then 'NDD' else 'Express' end as tariff,
    country,
    city,
    sum(orders)::float as orders,
    sum(deliveries)::float as deliveries,
    sum(trips)::float as trips,
    sum(surge)::float as surge,
    sum(gmv)::float as gmv,
    sum(commissions)::float as commissions,
    sum(subsidies)::float as subsidies,
    sum(decoupling)::float as decoupling,
    sum(net_inflow)::float as net_inflow
from final
where date < current_date
group by 1, 2, 3, 4;

