drop table if exists claim;
CREATE TEMP TABLE claim as
    select distinct on (cs.taxi_order_id)
        cs.taxi_order_id,
        claim_id,
        case
            when cs.referral_source_code is not null and cs.corp_client_id is not null
            then referral_source_code
            end as referral_source_code
    from
        delivery_ods_cargo_claims.claim as cs
    where
        cs.claim_id is not null
        and cs.referral_source_code in
                 (
                  'BeeComm', '1С УФА', 'apiship', 'WooCommerce - 1.11.4_test2',
                  'api_1c-bitrix', 'RetailCRM', 'api_1c-bitrix_kz', 'Beteabon', 'iiko',
                  'WooCommerce - 1.11.4_test', 'Shipit', 'shopify', '1С', 'OpenCart – 1.11.3',
                  'Tillypad', 'StarterApp', 'WooCommerce - 1.11.4_test3', 'api_1c-bitrix_by',
                  'WooCommerce - 1.11.4', 'rkeeper', 'Geco', 'WooCommerce - 1.11.4_test7',
                  'Cloud Brands', 'Beteavon', 'WooCommerce - 1.11.4_test6', 'smartomato',
                  'r_keeper_delivery', 'WooCommerce - 1.11.2', '1C', 'Joomla - 1.7.0',
                  'yandex_routing', 'WooCommerce - 1.10.5', 'WooCommerce - 1.11.3',
                  'WooCommerce - 1.11.4_test5'
                 )
        and cs.utc_created_dttm >= (timestamp'2020-01-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC')
    order by 1
DISTRIBUTED by (taxi_order_id);



drop table if exists phoenix;
create temp table phoenix as
    select corp_client_id, min(corp_client_id_created at time zone 'Europe/Moscow')::date as corp_client_id_created
    from snb_delivery.ferenec_funnel_phoenix
    where corp_client_id is not null
    group by corp_client_id
    having min(corp_client_id_created) >= '2021-12-01';



drop table if exists first_order;

CREATE TEMP TABLE first_order as
    select
        user_phone_pd_id,
        min(date_trunc('day', (utc_order_created_dttm + interval '3 hours')):: date) as min_date,
        min(date_trunc('week', (utc_order_created_dttm + interval '3 hours')):: date) as min_week,
        min(date_trunc('month', (utc_order_created_dttm + interval '3 hours')):: date) as min_month
    from
        taxi_cdm_marketplace.fct_order
    where
          utc_order_created_dttm >= (timestamp'2019-05-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC')
        and tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp', 'ubernight')
    group by
        1
DISTRIBUTED by (user_phone_pd_id);
ANALYZE first_order;
------------------------------------------------------------------------------------------------------------------------


drop table if exists money;
create temp table money as
select
    order_id,
    order_cost * currency_rate as gmv,
    gross_commission_revenue_amt * currency_rate as commissions,
    incentives_amt * currency_rate as subsidies,
    b2b_decoupling_amt * currency_rate * case when decoupling_flg then 1 else 0 end as decoupling,
    net_inflow_amt * currency_rate as net_inflow
from
    taxi_cdm_marketplace.fct_order_metric
where
    utc_order_created_dttm >= timestamp'2020-01-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC'
    and tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp', 'ubernight', 'uberlux')
distributed by (order_id);
analyze money;
------------------------------------------------------------------------------------------------------------------------



drop table if exists k2_ts;
create temp table k2_ts as

    select b.taxi_order_id as order_id, pickup_or_lavka, count(distinct market_order_id) as deliveries
    from snb_delivery.dash_k2 a inner join delivery_ods_cargo_claims.claim b
        on a.claim_id = b.claim_id
    group by 1,2
    union
    select b.taxi_order_id as order_id, pickup_or_lavka, count(distinct market_order_id) as deliveries
    from snb_delivery.dash_ts a inner join delivery_ods_cargo_claims.claim b
        on a.claim_id = b.claim_id
    group by 1,2
;
analyze k2_ts;

------------------------------------------------------------------------------------------------------------------------




drop table if exists data_bizdev_orders;

CREATE temp TABLE data_bizdev_orders as
select
    fo.order_id,
    cl.claim_id,
    (fo.utc_order_created_dttm + interval '3 hours')::date as order_date,
    fo.lcl_order_created_dt as local_date,
    fo.success_order_flg::int as success_order_flg,
    fo.tariff_class_code,
    fo.user_client_id,
    fo.corp_client_id,
    fo.corp_contract_id,
    case
        when fo.corp_client_id in ('b2dc2b2e96f8482ba2d1582bd1445184','370be78f439446a1b833a8fcc1234133') then 'Еда - ритейл'
        when ch.holding_name = 'Яндекс.Еда' then 'Еда - рестораны'
        when ch.holding_name = 'Яндес.Лавка' then 'Лавка'
        when ch.holding_name = 'Яндекс.Маркет' or k2_ts.pickup_or_lavka = 'pickup_market' then
            case
                when fo.corp_client_id in ('b010d898a6ef4a3ea75d0e12e6ea51ef') then 'Маркет Экспресс'
                when fo.corp_client_id in ('1f86abc44e5e44b8890b533434008d2e','dca7971b1b62480cbb9441f165e73080') then 'Маркет Грузовой'
                else 'Маркет'
            end
        when ch.holding_name = 'ВкусВилл' or fo.corp_client_id = '51d9772dc9424a14b257920adc1b79fd' then 'Вкусвилл' -- один корп не промаплен
        when ch.holding_name = 'X5 Retail group' then 'X5'
        when ch.holding_name = 'ГК Магнит' then 'Магнит' -- 6 корпов вместо одного
        end as client,
    case
        when ch.holding_name ~ 'Янде(к?)с' or fo.corp_client_id = 'f5364e6a92f643a5aabc696a538dd55d' -- 1030480/20 Такси для Яндекс.Лавки
        then 'Yandex_client'
        else 'Other'
        end as yandex_client,
    fo.coop_account_id,
    fo.user_phone_pd_id,
    fo.user_phone_id,
    k2_ts.pickup_or_lavka,
    case when k2_ts.pickup_or_lavka = 'pickup_market' then k2_ts.deliveries else 0 end as pvz_deliveries,
    fo.request_payment_type,
    fo.fact_payment_type,
    fo.coop_account_type,
    fo.corp_order_flg,
    phoenix.corp_client_id is not null
        and (fo.utc_order_created_dttm + interval '3 hours')::date >= '2021-12-01'
        as phoenix,
    mangr.manager_group,
    mangr.manager_metagroup,
    mangr.lead_name,
    mangr.manager_name,
    mangr.market_segment,
    cn.corp_client_name,
    ch.holding_name,
    fo.tariff_geo_zone_code,
    fo.agglomeration_node_id,
    fo.country_name_ru as country,
    geo.name_ru as city,
    geo.population_group,
    fo.app_name,
    fo.app_platform_name,
    fo.order_source_code,
    fo.destination_plan_geohash_cnt,
    fo.delivery_point_cnt,
    so.order_id as self_order_id,
    cl.referral_source_code,
    fo.order_requirement_list,

    coalesce(money.gmv, 0) as gmv,
    coalesce(money.commissions, 0) as commissions,
    coalesce(money.subsidies, 0) as subsidies,
    coalesce(money.decoupling, 0) as decoupling,
    coalesce(money.net_inflow, 0) as net_inflow,

    fo.balance_rate,
    first_order.min_date,
    first_order.min_week,
    first_order.min_month,
    tier4.user_phone_pd_id as tier4_user_phone_pd_id,
    tier4.utc_valid_from_dt::timestamp as tier4_utc_valid_from_dt,
    tier4.utc_valid_to_dt::timestamp as tier4_utc_valid_to_dt

from
    taxi_cdm_marketplace.fct_order as fo

    left join
    (
        select distinct node_id, name_ru, population_group
        from core_cdm_geo.dim_full_geo_hierarchy
        where node_type = 'agglomeration'
    )
        as geo on geo.node_id = fo.agglomeration_node_id

    left join k2_ts
        on fo.order_id = k2_ts.order_id

    left join first_order as first_order
        on first_order.user_phone_pd_id  = fo.user_phone_pd_id

    left join snb_delivery.smb_users_flags as tier4
        on tier4.user_phone_pd_id = fo.user_phone_pd_id
        and tier4.utc_valid_to_dt = '9999-12-31'

    left join snb_delivery.niksm_contract_manager as mangr
        on mangr.contract_id = fo.corp_contract_id

    left join money
        on money.order_id = fo.order_id

    left join snb_delivery.self_orders so
        on so.order_id = fo.order_id

    left join claim cl
        on cl.taxi_order_id = fo.order_id

    left join snb_delivery.sm91189_corp_holding ch
        on ch.corp_client_id = fo.corp_client_id

    left join (select distinct on (corp_client_id) corp_client_id, corp_client_name from delivery_cdm_b2b.dim_corp_contract) cn
        on cn.corp_client_id = fo.corp_client_id

    left join phoenix
        on phoenix.corp_client_id = fo.corp_client_id

where
    fo.utc_order_created_dttm >= (timestamp'2020-01-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC')
    and (fo.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
        or (fo.tariff_class_code = 'ubernight' and fo.utc_order_created_dttm >= '2021-09-01')
        or (fo.tariff_class_code in ('uberlux','night') and fo.utc_order_created_dttm >= '2022-03-01')
        or (fo.tariff_class_code in ('sdd') and fo.utc_order_created_dttm >= '2022-05-01'))
    and not fo.fake_order_flg
    and not fo.mqc_order_flg
    and not fo.user_fraud_flg
    and so.order_id is null

DISTRIBUTED RANDOMLY;
ANALYZE data_bizdev_orders;
------------------------------------------------------------------------------------------------------------------------



drop table if exists data_bizdev;
create temporary table data_bizdev as
select
    order_id,
    claim_id,
    order_date as date,
    local_date as date_lcl,
    date_trunc('week', order_date)::date as week_start,
    date_trunc('week', local_date)::date as week_lcl_start,
    date_trunc('month', order_date)::date as month,
    date_trunc('month', local_date)::date as month_lcl,
    success_order_flg,
    tariff_class_code,
    user_client_id,
    corp_client_id,
    corp_contract_id,
    client,
    yandex_client,
    coop_account_id,
    user_phone_pd_id,
    user_phone_id,
    pickup_or_lavka,
    pvz_deliveries,
    request_payment_type,
    fact_payment_type,
    coop_account_type,
    corp_order_flg,
    phoenix,
    manager_group,
    manager_metagroup,
    lead_name,
    manager_name,
    market_segment,
    corp_client_name,
    holding_name,
    tariff_geo_zone_code,
    agglomeration_node_id,
    country,
    city,
    population_group,
    app_name,
    app_platform_name,
    order_source_code,
    order_requirement_list,
    destination_plan_geohash_cnt,
    delivery_point_cnt,
    referral_source_code,
    min_date,
    min_week,
    min_month,
    tier4_user_phone_pd_id,
    tier4_utc_valid_from_dt,
    tier4_utc_valid_to_dt,
    coalesce(client, corp_client_id, coop_account_id, user_phone_pd_id, user_phone_id) as user_id_client, -- столбец со всеми id
    case
        when corp_client_id is not null then 'corp_client_id'
        when coop_account_id is not null then 'coop_account_id'
        when user_phone_pd_id is not null then 'user_phone_pd_id'
        else 'user_phone_id'
        end as user_id_type, -- тип id

    case
        when corp_order_flg then 'B2B'
        else 'C2C/SMB'
        end as business,

    case
        when manager_group = 'Тир 3' then 'SMB'
        when corp_order_flg then 'B2B'
        when tier4_user_phone_pd_id is not null then 'SMB'
        else 'C2C'
        end as c2c_smb_b2b_flg,

    coalesce(client, case when tariff_class_code in ('ubernight','uberlux') then 'Uber' end, manager_group, 'Other') as client_or_tier,

    case
        when country = 'Россия'
        then 'Россия'
        else 'Международка'
        end as domestic_int,

    case
        when pickup_or_lavka is not null
        then 'Next'
        else 'Same'
        end as same_or_next_day,

    case
        when pickup_or_lavka = 'lavka' then 'Next'
        when pickup_or_lavka = 'pickup_market' then 'Next_Pvz'
        else 'Same'
        end as same_or_next_day_fake,

    case
        when app_name = 'iphone' then 'Iphone'
        when app_name = 'android' then 'Android'
        else 'Other' end as os,

    case
        when order_source_code in ('yandex','cargo') and corp_client_id is null and corp_order_flg = false then 'Mobile App'
        when order_source_code = 'cargo' then 'API'
        when order_source_code = 'corp_cabinet' then 'Corporate Cabinet'
        when (app_name = 'light_business' and request_payment_type <> 'coop_account') or app_name = 'yandex.delivery' then '/order'
        when order_source_code = 'light_business'
                 or (request_payment_type = 'coop_account' and coop_account_type= 'business') then 'Business account'
        when order_source_code = 'call_center' then 'Call Center'
        else 'Other' end as order_source,

    case
        when pickup_or_lavka is not null then 'K2'
        when tariff_class_code in ('night','sdd') then 'SDD'
        when tariff_class_code in ('express', 'courier', 'ubernight', 'uberlux') then 'Delivery+Courier'
        else 'Cargo' end as tariff,

    case when order_date = min_date then 'Newbie' else 'Old' end as newbie_flag_day,
    cast(NULL as varchar) as zero_deliveries,
    cast(NULL as varchar) as agg_flg,

    cast(0 as int) as sum_prev_30d_deliveries,
    cast(NULL as varchar) as frequency_flag,

    1 as orders,

    success_order_flg as trips,
    case
        when pickup_or_lavka = 'pickup_market' then pvz_deliveries
        else delivery_point_cnt
        end as deliveries,

    case
        when pickup_or_lavka = 'pickup_market' then pvz_deliveries
        else delivery_point_cnt
        end * case when balance_rate <> 1 then 1 else 0 end as surge_deliveries,

    balance_rate as surge_success,
    balance_rate as surge_all,
    gmv * success_order_flg as gmv,
    gmv * success_order_flg
        * case when fact_payment_type in ('card', 'applepay', 'coop_account', 'googlepay')
            then 1 else 0 end as gmv_cards,
    commissions * success_order_flg as commissions,
    subsidies * success_order_flg as subsidies,
    decoupling * success_order_flg as decoupling,
    net_inflow * success_order_flg as net_inflow

from data_bizdev_orders
DISTRIBUTED by (user_id_client, domestic_int, city, same_or_next_day, tariff, date);
------------------------------------------------------------------------------------------------------------------------


DROP TABLE IF EXISTS prev_30d;

CREATE TEMPORARY TABLE prev_30d AS
with w_prev_30d as (
    SELECT user_id_client
         , domestic_int
         , city
         , same_or_next_day
         , tariff
         , date
         , sum(deliveries) AS deliveries
    FROM data_bizdev
    GROUP BY 1, 2, 3, 4, 5, 6
)
SELECT user_id_client
     , domestic_int
     , city
     , same_or_next_day
     , tariff
     , date
     , sum(deliveries) OVER w AS deliveries
FROM w_prev_30d
WINDOW w AS
    (PARTITION BY user_id_client, domestic_int, city, same_or_next_day, tariff
    ORDER BY date
    RANGE BETWEEN 30 PRECEDING AND 1 PRECEDING)

DISTRIBUTED by (user_id_client, domestic_int, city, same_or_next_day, tariff, date);
ANALYZE prev_30d;
------------------------------------------------------------------------------------------------------------------------


update data_bizdev
set sum_prev_30d_deliveries = prev_30d.deliveries
from prev_30d
where
    data_bizdev.user_id_client = prev_30d.user_id_client
    and data_bizdev.domestic_int = prev_30d.domestic_int
    and data_bizdev.city = prev_30d.city
    and data_bizdev.same_or_next_day = prev_30d.same_or_next_day
    and data_bizdev.tariff = prev_30d.tariff
    and data_bizdev.date = prev_30d.date;
------------------------------------------------------------------------------------------------------------------------


update data_bizdev
set
    zero_deliveries = case
        when deliveries = 0
        then 'zero'
        else 'positive'
        end,
    agg_flg = case
        when business = 'B2B'
        then user_id_client -- поменяли тут, так как по-другому сейчас считаем б2б
        else 'no_corp'
        end,
    frequency_flag = case
        when business = 'C2C/SMB' and sum_prev_30d_deliveries = 1 then '1'
        when business = 'C2C/SMB' and sum_prev_30d_deliveries between 2 and 4 then '2-4'
        when business = 'C2C/SMB' and sum_prev_30d_deliveries >= 5 then '5+'
        when business = 'C2C/SMB' and newbie_flag_day = 'Newbie' and sum_prev_30d_deliveries is null then 'Newbie' -- не было доставок в течение 30 предыдущих дней
        when business = 'C2C/SMB' and newbie_flag_day = 'Old' and sum_prev_30d_deliveries is null then 'No del in prev 30 days' -- не было доставок в течение 30 предыдущих дней
        else 'Other'
        end
    ;


-- LOGDATA-2149
update data_bizdev
set tariff = 'SDD', same_or_next_day = 'Same', same_or_next_day_fake = 'Same'
where corp_client_id IN (
    'f7142a11ca8e481fadbe1de6253e3ed1' --Paneco
    ,'d1cb4943f9ca4facbef7a507783b226a' --Ivory
    ,'03ad7fcf3c1a4d7e81e30af78e06a4d4' --Carmella
    ,'badfd29fd0634241b4512e79666808fa' --Vaz
    ,'7169aeb064b04b9da0b451e4d4e32293' --Shook

    ,'07e7df00a6054ef9b284aed1ad4b2b4a' --Espresso
    ,'682cf867498f470593c27559cd57d8c5' --HFD
    ,'d350dd7772354e8587d3aa9734d2dca8' --Amigo
    ,'92020e6386f24cdb8be4ababbfd69ad9' --KSP
    ,'347ac0f7d8c4469b92261fece833f483' --Hemilton
    ,'afd409310214441e9d38a465cb91f1a8' --Cheeta
    ,'57200416f3d54f4dad6bb93933112781' --UPS
    ,'f7db6f9f79c34ba79bd0dda906fb955b' --Cheetah
    ,'54c9ecf6dbd74fe3ac2317596fbff0f6' --Foodlabriut
    ,'c12eb7ee2afc4136abb0337e757fa248' --Factory54
    ,'2b44bcbf04594ea1b6ea52eda344b3a3' --Fruit Valley
    ,'9321900b07f346bd84887ad3cd806d6d' --Artera Flowers
    ,'839ea2f114404232b4f6ffb80ed629bd' --Amor and Briza
);



-- LOGDATA-1292
insert into data_bizdev
select
    route_id,
    route_id,
    route_date::date as date,
    route_date::date as date_lcl,
    date_trunc('week', route_date::date)::date as week_start,
    date_trunc('week', route_date::date)::date as week_lcl_start,
    date_trunc('month', route_date::date)::date as month,
    date_trunc('month', route_date::date)::date as month_lcl,
    max(successful_order_flg::integer) as success_order_flg,
    'express' as tariff_class_code,
    null as user_client_id,
    null as corp_client_id,
    null as corp_contract_id,
    'Other' as client,
    'Other' as yandex_client,
    null as coop_account_id,
    null as user_phone_pd_id,
    null as user_phone_id,
    null as pickup_or_lavka,
    0 as pvz_deliveries,
    null as request_payment_type,
    null as fact_payment_type,
    null as coop_account_type,
    true as corp_order_flg,
    false as phoenix,
    null as manager_group,
    null as manager_metagroup,
    null as lead_name,
    null as manager_name,
    null as market_segment,
    null as corp_client_name,
    null as holding_name,
    case
        when country = 'Чили' then 'santiago'
        when country = 'Сербия' then 'belgrad'
        end as tariff_geo_zone_code,
    null as agglomeration_node_id,
    country,
    city,
    'INT' as population_group,
    null as app_name,
    null as app_platform_name,
    null as order_source_code,
    null as order_requirement_list,
    sum(successful_order_flg::integer) as destination_plan_geohash_cnt,
    sum(successful_order_flg::integer) as delivery_point_cnt,
    null as referral_source_code,
    route_date::date as min_date,
    date_trunc('week', route_date::date)::date as min_week,
    date_trunc('month', route_date::date)::date as min_month,
    null as tier4_user_phone_pd_id,
    timestamp '2021-01-01' AT TIME ZONE 'UTC' as tier4_utc_valid_from_dt,
    timestamp '2021-01-01' AT TIME ZONE 'UTC' as tier4_utc_valid_to_dt,
    null as user_id_client, -- столбец со всеми id
    'user_phone_id' as user_id_type, -- тип id
    'B2B' as business,
    'B2B' as c2c_smb_b2b_flg,
    'Other' as client_or_tier,
    'Международка' as domestic_int,
    'Same' as same_or_next_day,
    'Same' as same_or_next_day_fake,
    'Other' as os,
    'Other' as order_source,
    'SDD' as tariff,
    'Old' as newbie_flag_day,
    'positive' as zero_deliveries,
    null as agg_flg,
    0 as sum_prev_30d_deliveries,
    null as frequency_flag,
    1 as orders,
    max(case when status = 'finished' then 1 else 0 end) as trips,
    sum(case when status = 'finished' then 1 else 0 end) as deliveries,
    0 as surge_deliveries,
    max(case when status = 'finished' then 1 else 0 end) as surge_success,
    max(case when status = 'finished' then 1 else 0 end) as surge_all,
    sum(price_rub) as gmv,
    0 as gmv_cards,
    0 as commissions,
    sum(cost_rub) as subsidies,
    0 as decoupling,
    sum(price_rub-cost_rub) as net_inflow

from
    snb_delivery.data_routing
group by
    route_id,
    route_date::date,
    date_trunc('week', route_date::date)::date,
    date_trunc('month', route_date::date)::date,
    country,
    city
;

------------------------------------------------------------------------------------------------------------------------




drop table if exists snb_delivery.data_bizdev;
create table snb_delivery.data_bizdev as
-- truncate table snb_delivery.data_bizdev;
-- insert into snb_delivery.data_bizdev
select *
from data_bizdev
where date < current_date;
--
--
grant select on snb_delivery.data_bizdev to public;

grant select, delete, insert, references, trigger, truncate, update
    on snb_delivery.data_bizdev to "robot-log-analytics";
