import pandas as pd

from business_models.startrek import StartrekWrapper

from projects.common.tools import run_sql

FILENAME = 'deliveries.xlsx'
TICKET_ID = 'LOGDATA-88'


def main():
    df1 = run_sql('deliveries.sql')
    df2 = run_sql('deliveries_week.sql')

    print(f'Writing to {FILENAME}...')
    with pd.ExcelWriter(FILENAME) as writer:
        df1.to_excel(writer, sheet_name='Day', index=False, encoding='utf-8')
        df2.to_excel(writer, sheet_name='Week', index=False, encoding='utf-8')

    print(f'Sending to {TICKET_ID}...')
    st = StartrekWrapper()
    st.comment(TICKET_ID, text='Обновленные данные по доставкам', attachments=FILENAME)


if __name__ == '__main__':
    main()
