drop table if exists b;
drop table if exists raw;
drop table if exists b2b_deliveries;
drop table if exists dm_order;
drop table if exists t1;
drop table if exists t2;
drop table if exists ndd_market_from_lavka;


create temporary table b as (
SELECT
    distinct new.market_order_id as market_order_id,
    new.market_order_delivered_datetime::timestamp::date as day,
    count(distinct new.market_order_id) +
    least(count(*) FILTER (WHERE oi.item_type_code  != 'parcel_market'), 1) as items
from snb_taxi.logdata_market_lavka_orders as new
left join eda_cdm_marketplace.dm_lavka_order_item oi on new.lavka_order_id = oi.external_id
where oi.external_id in
            (SELECT
                distinct external_id as external_id
            from eda_cdm_marketplace.dm_lavka_order_item
            where item_type_code = 'parcel_market')
group by 1, 2);


create temporary table raw as (
    SELECT
        day,
        'Россия' as country,
        'Delivery + Courier' as order_tariff,
        'Next' as same_or_next_day,
        TRUE as corp_order_flg,
        'Delivery + Courier, B2B' as business,
        'Остальные' as client,
        sum(items) as deliveries
    from b
    left join snb_taxi.logdata_market_lavka_orders as new on new.market_order_id = b.market_order_id
    left join eda_cdm_marketplace.dm_lavka_order as a on a.order_id = new.lavka_order_id
    where a.parcel_market_flg
        and a.confirmed_flg
        and b.day::date between '2020-10-01' and current_date - interval '1 day'
    group by 1, 2, 3, 4, 5, 6, 7
    order by 1);


create temporary table ndd_market_from_lavka as (
    select a.day,
           a.country,
           a.order_tariff,
           a.same_or_next_day,
           a.corp_order_flg,
           a.business,
           a.client,
           coalesce(a.deliveries, 0)                      as deliveries,
           coalesce(b.deliveries, 0)                      as deliveries_dod,
           coalesce(1.0 * a.deliveries / b.deliveries, 0) as dod,
           coalesce(c.deliveries, 0)                      as deliveries_wow,
           coalesce(1.0 * a.deliveries / c.deliveries, 0) as wow,
           coalesce(d.deliveries, 0)                      as deliveries_yoy,
           coalesce(1.0 * a.deliveries / d.deliveries, 0) as yoy
    from raw as a
             left join raw as b on a.day = b.day + interval '1 day' and a.country = b.country
        and a.order_tariff = b.order_tariff
        and a.same_or_next_day = b.same_or_next_day
        and a.corp_order_flg = b.corp_order_flg
        and a.client = b.client
             left join raw as c on a.day = c.day + interval '1 week' and a.country = c.country
        and a.order_tariff = c.order_tariff
        and a.same_or_next_day = c.same_or_next_day
        and a.corp_order_flg = c.corp_order_flg
        and a.client = c.client
             left join raw as d on a.day = d.day + interval '364 days' and a.country = d.country
        and a.order_tariff = d.order_tariff
        and a.same_or_next_day = d.same_or_next_day
        and a.corp_order_flg = d.corp_order_flg
        and a.client = d.client
    where a.day = current_date - interval '1 day'
);


create temporary table b2b_deliveries as (
    select taxi_order_id as order_id, count(distinct claim_point_id) as b2b_deliveries
    from delivery_ods_cargo_claims.claim_segment as cs
             left join delivery_ods_cargo_claims.claim_segment_point as csp on cs.claim_segment_id = csp.claim_segment_id
    where csp.point_status = 'visited'
      and csp.point_type = 'destination'
      and cs.taxi_order_id is not null
      and cs.claim_segment_id is not null
    group by taxi_order_id
);

create temporary table dm_order as (
    select order_id, success_order_flg
    from summary.dm_order as o
    where success_order_flg
      and order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
      and success_order_flg
      and not fake_order_flg
      and not mqc_order_flg
      and utc_order_dt >= current_date - interval '390 days'
)
;

create temporary table t1 as (
    with raw as (select case
                            when o.tariff_class_code in ('express', 'courier') then 'Delivery + Courier'
                            when o.tariff_class_code in ('cargo', 'cargocorp') then 'Cargo'
                            else 'Other' end                                                         as order_tariff,
                        case
                            when corp_order_flg then True
                            when request_payment_type = 'coop_account' and coop_account_type = 'business' then True
                            else False end                                                           as corp_order_flg,
                        case
                            when o.corp_client_id in
                                   ('4decd14f25424e8b82b6d3e4f56d23b2',
                                   'b2dc2b2e96f8482ba2d1582bd1445184',
                                   '87cda4c03d60416bb522e83fe24b3d50',
                                   '162b9899216246f7a1ba9fc14a479e87')
                                then 'Еда'
                            when o.corp_client_id in
                                   ('dc28c565829e48cca458b5feb161d5d6',
                                   '4ee0ceca18ce41e3895786796a967e78',
                                   'bfd05979e380486d9181b62fa05d1fc9')
                                then 'Лавка'
                            when o.corp_client_id in ('efd53f1437f7468fa55460fa58291648',
                                                      '27751a2d0b534affb80d243bc2f68981',
                                                      '51d9772dc9424a14b257920adc1b79fd')
                                then 'ВВ'
                            when o.corp_client_id in ('c092a390e4824110990bbe47c4e82994')
                                then 'X5'
                            when not corp_order_flg
                                 and not ( request_payment_type = 'coop_account' and coop_account_type = 'business')
                                 and coalesce((o.utc_order_created_dttm + interval '3 hours'):: date >= smb.datefrom, False)
                                then 'SMB'
                            else 'Остальные'
                            end                                                     as client,
                        case when ndd.taxi_order_id is not null or ndd_pickup_ondemand.taxi_order_id is not null then 'Next' else 'Same' end          as same_or_next_day,
                        date_trunc('day', (utc_order_created_dttm + interval '3 hours'))::date       as day,
                        case when o.country_name_ru = 'Россия' then 'Россия' else 'Международка' end as country,
                        sum(case
                                when ndd_pickup_ondemand.taxi_order_id is not null then
                                    coalesce(ondemand_pickup_deliveries, 0)
                                when m.order_id is not null then
                                    coalesce(m.b2b_deliveries, 1)
                                when o.destination_plan_geohash_cnt >= 1 then
                                    o.destination_plan_geohash_cnt
                                else 1 end)                                                          as deliveries
                 from taxi_cdm_marketplace.fct_order as o
                          left join b2b_deliveries as m
                                    on o.order_id = m.order_id
                          left join (select distinct taxi_order_id
                                     from ritchie.delivery_ods_cargo_claims.claim as a
                                              inner join snb_eda.lavka_beru_raw as b on a.claim_id = b.claim_id) as ndd
                                    on o.order_id = ndd.taxi_order_id
                          left join (select taxi_order_id,
                                            count(distinct market_order_id) as ondemand_pickup_deliveries
                                     from snb_taxi.logdata_market_pvz_orders
                                     group by 1
                                     order by 1) as ndd_pickup_ondemand on o.order_id = ndd_pickup_ondemand.taxi_order_id
                          left join dm_order as dm on dm.order_id = o.order_id
                          left join snb_taxi.niksm_b2b_tier4_user_datefrom as smb on smb.user_id = o.user_client_id
                 where (utc_order_created_dttm + interval '3 hours')::date between (current_date - interval '390 days') and (current_date - interval '1 day')
                   and o.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
                   and coalesce(dm.success_order_flg, o.success_order_flg)
                   and not fake_order_flg
                   and not mqc_order_flg
                   and ndd.taxi_order_id is null

                 GROUP BY 1, 2, 3, 4, 5, 6)
    SELECT a.day,
           a.country,
           a.order_tariff,
           a.same_or_next_day,
           a.corp_order_flg,
           case
               when a.corp_order_flg = True and a.order_tariff = 'Cargo' then 'Cargo, B2B'
               when a.corp_order_flg = True and a.order_tariff = 'Delivery + Courier' then 'Delivery + Courier, B2B'
               when a.corp_order_flg = False and a.order_tariff = 'Cargo' then 'Cargo, B2C'
               when a.corp_order_flg = False and a.order_tariff = 'Delivery + Courier' then 'Delivery + Courier, B2C'
               else 'Other' end                           as business,
           a.client,
           coalesce(a.deliveries, 0)                      as deliveries,
           coalesce(b.deliveries, 0)                      as deliveries_dod,
           coalesce(1.0 * a.deliveries / b.deliveries, 0) as dod,
           coalesce(c.deliveries, 0)                      as deliveries_wow,
           coalesce(1.0 * a.deliveries / c.deliveries, 0) as wow,
           coalesce(d.deliveries, 0)                      as deliveries_yoy,
           coalesce(1.0 * a.deliveries / d.deliveries, 0) as yoy

    FROM raw as a
             left join raw as b on a.day = b.day + interval '1 day' and a.country = b.country
        and a.order_tariff = b.order_tariff
        and a.same_or_next_day = b.same_or_next_day
        and a.corp_order_flg = b.corp_order_flg
        and a.client = b.client
             left join raw as c on a.day = c.day + interval '1 week' and a.country = c.country
        and a.order_tariff = c.order_tariff
        and a.same_or_next_day = c.same_or_next_day
        and a.corp_order_flg = c.corp_order_flg
        and a.client = c.client
             left join raw as d on a.day = d.day + interval '364 days' and a.country = d.country
        and a.order_tariff = d.order_tariff
        and a.same_or_next_day = d.same_or_next_day
        and a.corp_order_flg = d.corp_order_flg
        and a.client = d.client
    where a.day::date = current_date - interval '1 day'
    order by 2 desc, 3, 4 desc, 5 desc, 6, 7, 1 desc
);

create temporary table t2 as (
    with raw as (select 'Text'                                                                 as order_tariff,
                        True                                                                   as corp_order_flg,
                        case
                            when o.corp_client_id in
                                   ('4decd14f25424e8b82b6d3e4f56d23b2', -- еда
                                   'b2dc2b2e96f8482ba2d1582bd1445184', -- еда
                                   '87cda4c03d60416bb522e83fe24b3d50', -- еда
                                   '162b9899216246f7a1ba9fc14a479e87', -- еда, Беларусь
                                   'dc28c565829e48cca458b5feb161d5d6', -- лавка
                                   '4ee0ceca18ce41e3895786796a967e78', -- лавка
                                   'bfd05979e380486d9181b62fa05d1fc9', -- лавка, не активный договор
                                   'dca7971b1b62480cbb9441f165e73080', -- маркет
                                   '837bd479e8dd4a738479bea13fdf95f7', -- другой яндекс
                                   '2b53ce85082c4391975241ac3e9326f1', -- другой яндекс
                                   'f5364e6a92f643a5aabc696a538dd55d') -- 1030480/20 Такси для Яндекс.Лавки
                                then 'From Yandex with Love'
                            else 'All other' end                                               as client,
                        'Text'                                                                 as same_or_next_day,
                        date_trunc('day', (utc_order_created_dttm + interval '3 hours'))::date as day,
                        'Text'                                                                 as country,
                        'Text'                                                                 as business,
                        sum(case
                                when m.order_id is not null then
                                    coalesce(m.b2b_deliveries, 1)
                                when o.destination_plan_geohash_cnt >= 1 then
                                    o.destination_plan_geohash_cnt
                                else 1 end)                                                    as deliveries
                 from taxi_cdm_marketplace.fct_order as o
                          left join b2b_deliveries as m
                                    on o.order_id = m.order_id
                          left join (select distinct taxi_order_id
                                     from ritchie.delivery_ods_cargo_claims.claim as a
                                              inner join snb_eda.lavka_beru_raw as b on a.claim_id = b.claim_id) as ndd
                                    on o.order_id = ndd.taxi_order_id
                          left join dm_order as dm on dm.order_id = o.order_id
                 where (utc_order_created_dttm + interval '3 hours')::date between (current_date - interval '390 days') and (current_date - interval '1 day')
                   and o.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
                   and coalesce(dm.success_order_flg, o.success_order_flg)
                   and not fake_order_flg
                   and not mqc_order_flg
                   and ndd.taxi_order_id is null

                 GROUP BY 1, 2, 3, 4, 5, 6, 7),
         base as (
             select a.day,
                    a.country,
                    a.order_tariff,
                    a.same_or_next_day,
                    a.corp_order_flg,
                    a.business,
                    a.client,
                    coalesce(a.deliveries, 0) + coalesce(b.deliveries_ndd, 0) as deliveries
             from raw as a
                      left join (select a.day,
                                        'Text'                    as country,
                                        'Text'                    as order_tariff,
                                        'Text'                    as same_or_next_day,
                                        True                      as corp_order_flg,
                                        'Text'                    as business,
                                        'From Yandex with Love'   as client,
                                        coalesce(a.deliveries, 0) as deliveries_ndd
                                 from ndd_market_from_lavka as a) as b
                                on a.day = b.day
                                    and a.country = b.country
                                    and a.order_tariff = b.order_tariff
                                    and a.same_or_next_day = b.same_or_next_day
                                    and a.corp_order_flg = b.corp_order_flg
                                    and a.client = b.client
         )
    SELECT a.day,
           a.country,
           a.order_tariff,
           a.same_or_next_day,
           a.corp_order_flg,
           a.business,
           a.client,
           coalesce(a.deliveries, 0)                      as deliveries,
           coalesce(b.deliveries, 0)                      as deliveries_dod,
           coalesce(1.0 * a.deliveries / b.deliveries, 0) as dod,
           coalesce(c.deliveries, 0)                      as deliveries_wow,
           coalesce(1.0 * a.deliveries / c.deliveries, 0) as wow,
           coalesce(d.deliveries, 0)                      as deliveries_yoy,
           coalesce(1.0 * a.deliveries / d.deliveries, 0) as yoy

    FROM base as a
             left join base as b on a.day = b.day + interval '1 day' and a.country = b.country
        and a.order_tariff = b.order_tariff
        and a.same_or_next_day = b.same_or_next_day
        and a.corp_order_flg = b.corp_order_flg
        and a.client = b.client
             left join base as c on a.day = c.day + interval '1 week' and a.country = c.country
        and a.order_tariff = c.order_tariff
        and a.same_or_next_day = c.same_or_next_day
        and a.corp_order_flg = c.corp_order_flg
        and a.client = c.client
             left join base as d on a.day = d.day + interval '364 days' and a.country = d.country
        and a.order_tariff = d.order_tariff
        and a.same_or_next_day = d.same_or_next_day
        and a.corp_order_flg = d.corp_order_flg
        and a.client = d.client
    where a.day::date = current_date - interval '1 day'
    order by 2 desc, 3, 4 desc, 5 desc, 6, 7, 1 desc
);


select *
from t1
union all
select *
from ndd_market_from_lavka
union all
select *
from t2
order by 2 desc, 3, 4, 5, 6, 7, 8
;
