from business_models import hahn, greenplum
import pandas as pd
import numpy as np
import os


monthly = greenplum("""
                    
SELECT
    business,
    c2c_smb_b2b_flg,
    client_or_tier,
    yandex_client,
    date_trunc('month',date)::date as date,
    'month' as scale,
    country,
    domestic_int,
    city,
    b.population_group,
    same_or_next_day,
    order_source,
    tariff,
    sum(deliveries) as deliveries,
    sum(orders) as orders,
    sum(trips) as trips,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
FROM
    snb_delivery.dash_bizdev_business_overview a
    left join (select distinct tz_aggl_name_ru, population_group from core_cdm_geo.v_dim_fi_geo_hierarchy where node_type='agglomeration') b
        on a.city = b.tz_aggl_name_ru
group by 1,2,3,4,5,6,7,8,9,10,11,12,13                   
                    
                    """)


daily = greenplum("""
                    
SELECT
    business,
    c2c_smb_b2b_flg,
    client_or_tier,
    yandex_client,
    date,
    'day' as scale,
    country,
    domestic_int,
    city,
    b.population_group,
    same_or_next_day,
    order_source,
    tariff,
    sum(deliveries) as deliveries,
    sum(orders) as orders,
    sum(trips) as trips,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
FROM
    snb_delivery.dash_bizdev_business_overview a
    left join (select distinct tz_aggl_name_ru, population_group from core_cdm_geo.v_dim_fi_geo_hierarchy where node_type='agglomeration') b
        on a.city = b.tz_aggl_name_ru

WHERE date_trunc('month',date) >= date_trunc('month', current_date) - interval '1' month
group by 1,2,3,4,5,6,7,8,9,10,11,12,13                  
                    
                    """)


weekly_fact = greenplum("""
                    
select
    business,
    scale,
    date,
    parameter,
    same_or_next_day,
    country,
    case when client = 'Market' then 'Маркет' else client end as client,
    sum(value) as value
from snb_delivery.dash_bizdev_plan_fact
group by 1, 2, 3, 4, 5, 6, 7                
                    
                    """)


ref_list = [(monthly, 'monthly.xlsx'),
            (daily, 'daily.xlsx'),
            (weekly_fact, 'weekly_fact.xlsx')]

dataframes = list(map(lambda x: x[0], ref_list))
filenames = list(map(lambda x: x[1], ref_list))

for name, filename in ref_list:
    name.to_excel(filename)

    

from business_models.startrek import StartrekWrapper

st = StartrekWrapper()

st.comment('LOGDATA-756', text=u"", attachments=filenames[:2])
st.comment('LOGDATA-907', text=u"", attachments=filenames[2])

for dataframe, filename in zip(dataframes, filenames):
    os.remove(filename)
    del(dataframe)
