drop table if exists region_mapping;
create temporary table region_mapping as
with a as (
    SELECT name_ru,
           full_name_ru,
           population_group,
           split_part(full_name_ru, ',', 1) as country,
           case
               when split_part(full_name_ru, ',', 1) = 'Россия'
                   then substring(split_part(full_name_ru, ',', 2), 2, length(split_part(full_name_ru, ',', 2)) - 1)
               else ''
               end                          as fo,
           case
               when split_part(full_name_ru, ',', 1) = 'Россия'
                   then substring(split_part(full_name_ru, ',', 3), 2, length(split_part(full_name_ru, ',', 3)) - 1)
               else ''
               end                          as region,
        case
            when population_group = 'RU_MSC' then 'Москва'
            when population_group = 'RU_SPB' then 'Санкт-Петербург'
            when population_group like any (array['%_1M+', '%_300K+','%_500K+','%_200K+']) then name_ru
            else population_group
            end as city,
        case
            when split_part(full_name_ru, ',', 1) = 'Россия' then case
                when population_group = 'RU_MSC' then 'Москва'
                when population_group = 'RU_SPB' then 'Санкт-Петербург'
                when population_group in ('RU_1M+', 'RU_300K+','RU_500K+') then population_group
                when population_group in ('RU_200K+','RU_100K+') then 'RU_100K+'
                else 'RU_100K-'
                end
            else case
                when population_group like '%_1M+' or population_group like '%_300K+' or population_group like '%_500K+'
                    then 'INT_' || substr(population_group,4,length(population_group)-3)
                when population_group like '%_200K+' or population_group like '%_100K+'
                    then 'INT_100K+'
                else 'INT_100K-'
                end
            end as city_group
    FROM core_cdm_geo.dim_geo_node
    WHERE root_node_id = 'br_root'
      and node_type = 'agglomeration'
)
select
    name_ru,
    full_name_ru,
    country,
    case
        when country = 'Россия' then 'Russia'
        when country in ('Казахстан','Армения','Молдавия','Киргизия','Азербайджан','Белоруссия','Грузия','Узбекистан') then 'CIS'
        else 'EMEA'
        end as macro_region,
    case
        when country = 'Россия' then population_group
        else country
        end as city_group,
    city,
    case
        when name_ru in ('Москва','Санкт-Петербург') then name_ru
        when region = 'Московская область' then 'Подмосковье'
        when region = 'Ленинградская область' then 'Ленинградская Область'
        when country = 'Россия' and fo = 'Дальневосточный ФО' then 'Дальний Восток'
        when country = 'Россия' and fo = 'Сибирский ФО' then 'Сибирь'
        when country = 'Россия' and fo = 'Южный ФО' then 'Юг'
        when country = 'Россия' and fo = 'Уральский ФО' then 'Урал'
        when country = 'Россия' and fo = 'Приволжский ФО' then 'Поволжье'
        when country = 'Россия' and fo = 'Центральный ФО' then 'Центр'
        when country = 'Россия' and fo = 'Северо-Западный ФО' then 'Северо-Запад'
        when country = 'Россия' and fo = 'Северо-Кавказский ФО' then 'Кавказ'
        else country
        end as region
from a;




drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

with a as (
         select msk_claim_created_dttm::date as date,
                b.country,
                b.city_group,
                b.city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from
            snb_delivery.dash_k2 a
            left join region_mapping b
                on b.name_ru = a.region_name
         where pickup_or_lavka = 'lavka'
         group by 1, 2, 3, 4

         union all

         select msk_claim_created_dttm::date as date,
                b.country,
                b.city_group,
                b.city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
            left join region_mapping b
                on b.name_ru = a.region_name
         group by 1, 2, 3, 4
     )
select
    date,
    country,
    city_group,
    city,
    sum(deliveries) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow
from a
group by 1,2,3,4;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as date,
    country,
    city_group,
    city,
    count (distinct request_id) as deliveries
from
    (
        select distinct
            request_id,
            corp_client_id,
            b.country,
            coalesce(b.city_group,'RU_MSC') as city_group,
            coalesce(b.city, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
                on a.delivery_region = geo.geobase_id
            left join region_mapping b
                on b.name_ru = geo.name_ru
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1,2,3,4;




drop table if exists base;
create temporary table base as
SELECT
    date,
    case
        when tariff in ('Delivery+Courier','SDD') then 'Delivery'
        else tariff
        end as tariff,
    c2c_smb_b2b_flg as business,
    b.country,
    b.city_group,
    b.city,
    same_or_next_day_fake,
    sum(deliveries) as deliveries,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(gmv) filter (where tariff_class_code in ('express', 'courier', 'ubernight')) as gmv_express,
    sum(gmv) filter (where tariff_class_code in ('cargo', 'cargocorp')) as gmv_cargo,
    sum(gmv) filter (where client like 'Еда%') as gmv_eda,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
FROM
    snb_delivery.data_bizdev a
    left join region_mapping b
        on b.name_ru = a.city
group by
    1, 2, 3, 4, 5, 6, 7;



drop table if exists base_share;
create temporary table base_share as
select
    *,
    gmv_express*1.0/sum(gmv_express) over (partition by date) as gmv_express_share,
    gmv_cargo*1.0/sum(gmv_cargo) over (partition by date) as gmv_cargo_share,
    gmv_eda*1.0/sum(gmv_eda) over (partition by date) as gmv_eda_share
from
    base;



drop table if exists data_fact;
create temporary table data_fact as

    select
        b.date,
        b.tariff,
        b.country,
        b.city_group,
        b.city,
        b.business,
        b.same_or_next_day_fake,
        b.deliveries,
        b.gmv,
        b.gmv_cards,
        b.commissions,
        b.subsidies
            + coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            + coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            as subsidies,
        b.decoupling
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as decoupling,
        b.net_inflow
            - coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            - coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as net_inflow
    from
        base_share as b
        left join snb_delivery.data_geosubs as geo
            on b.date = geo.dt::date
        left join snb_delivery.data_eda_expenses as eda_exp
            on b.date = eda_exp.day::date
;




drop table if exists daily;
create temporary table daily as

    select
        date,
        tariff,
        country,
        city_group,
        city,
        business,
        sum(deliveries) as deliveries,
        sum(gmv) as gmv,
        sum(gmv_cards) as gmv_cards,
        sum(commissions) as commissions,
        sum(subsidies) as subsidies,
        sum(decoupling) as decoupling,
        sum(net_inflow) as net_inflow
    from
        data_fact
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        date,
        tariff,
        'Россия' as country,
        city_group,
        city,
        'B2B' as business,
        0 as deliveries,
        sum(gmv) as gmv,
        sum(gmv_cards) as gmv_cards,
        sum(commissions) as commissions,
        sum(subsidies) as subsidies,
        sum(decoupling) as decoupling,
        sum(net_inflow) as net_inflow
    from
        data_fact
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        date,
        'K2' as tariff,
        'Россия' as country,
        city_group,
        city,
        'B2B' as business,
        sum(deliveries) as deliveries,
        0 as gmv,
        0 as gmv_cards,
        0 as commissions,
        0 as subsidies,
        0 as decoupling,
        0 as net_inflow
    from
        ndd_market_lavka
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        date::date,
        'NDD' as tariff,
        'Россия' as country,
        city_group,
        city,
        'B2B' as business,
        sum(deliveries) as deliveries,
        0 as gmv,
        0 as gmv_cards,
        0 as commissions,
        0 as subsidies,
        0 as decoupling,
        0 as net_inflow
    from
        ndd_deliveries
    group by
        1, 2, 3, 4, 5, 6
;



drop table if exists snb_delivery.dash_finance_estimate_source;
create table snb_delivery.dash_finance_estimate_source as
    select
        date,
        tariff,
        country,
        city_group,
        city,
        business,
        sum(deliveries)::float as deliveries,
        sum(gmv)::float as gmv,
        sum(gmv_cards)::float as gmv_cards,
        sum(commissions)::float as commissions,
        sum(subsidies)::float as subsidies,
        sum(decoupling)::float as decoupling,
        sum(net_inflow)::float as net_inflow
    from
        daily
    group by
        1, 2, 3, 4, 5, 6
    having
        sum(deliveries) <> 0
distributed by (date)
;




drop table if exists act_share_source_day;
create temp table act_share_source_day as
select
    date,
    tariff,
    country,
    city_group,
    city,
    business,
    sum(deliveries) as deliveries,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
from snb_delivery.dash_finance_estimate_source
where date_trunc('month', date) <= date_trunc('month', current_date)
group by 1,2,3,4,5,6;


drop table if exists act_share_day;
create temp table act_share_day as
select
    *,
    case
        when sum(deliveries) over(partition by date, tariff, country, business) = 0
        then 0
        else deliveries*1.0/sum(deliveries) over(partition by date, tariff, country, business)
        end as deliveries_share,
    case
        when sum(gmv) over(partition by date, tariff, country, business) = 0
        then 0
        else gmv*1.0/sum(gmv) over(partition by date, tariff, country, business)
        end as gmv_share,
    -- GMV CARDS SHARE = % FROM GMV
    case
        when sum(gmv) over(partition by date, tariff, country) = 0
        then 0
        else gmv_cards*1.0/sum(gmv) over(partition by date, tariff, country)
        end as gmv_cards_share,
    case
        when sum(commissions) over(partition by date, tariff, country, business) = 0
        then 0
        else commissions*1.0/sum(commissions) over(partition by date, tariff, country, business)
        end as commissions_share,
    case
        when sum(subsidies) over(partition by date, tariff, country, business) = 0
        then 0
        else subsidies*1.0/sum(subsidies) over(partition by date, tariff, country, business)
        end as subsidies_share,
    case
        when sum(decoupling) over(partition by date, tariff, country, business) = 0
        then 0
        else decoupling*1.0/sum(decoupling) over(partition by date, tariff, country, business)
        end as decoupling_share,
    case
        when sum(net_inflow) over(partition by date, tariff, country, business) = 0
        then 0
        else net_inflow*1.0/sum(net_inflow) over(partition by date, tariff, country, business)
        end as net_inflow_share
from
    act_share_source_day;





drop table if exists act_share_source_month;
create temp table act_share_source_month as
select
    date_trunc('month',date)::date as month,
    tariff,
    country,
    city_group,
    city,
    sum(deliveries) as deliveries,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
from act_share_day
group by 1,2,3,4,5;



drop table if exists act_share_month;
create temp table act_share_month as
select
    *,
    case
        when sum(deliveries) over(partition by month, tariff, country) = 0
        then 0
        else deliveries*1.0/sum(deliveries) over(partition by month, tariff, country)
        end as deliveries_share,
    case
        when sum(gmv) over(partition by month, tariff, country) = 0
        then 0
        else gmv*1.0/sum(gmv) over(partition by month, tariff, country)
        end as gmv_share,
    -- GMV CARDS SHARE = % FROM GMV
    case
        when sum(gmv) over(partition by month, tariff, country) = 0
        then 0
        else gmv_cards*1.0/sum(gmv) over(partition by month, tariff, country)
        end as gmv_cards_share,
    case
        when sum(commissions) over(partition by month, tariff, country) = 0
        then 0
        else commissions*1.0/sum(commissions) over(partition by month, tariff, country)
        end as commissions_share,
    case
        when sum(subsidies) over(partition by month, tariff, country) = 0
        then 0
        else subsidies*1.0/sum(subsidies) over(partition by month, tariff, country)
        end as subsidies_share,
    case
        when sum(decoupling) over(partition by month, tariff, country) = 0
        then 0
        else decoupling*1.0/sum(decoupling) over(partition by month, tariff, country)
        end as decoupling_share,
    case
        when sum(net_inflow) over(partition by month, tariff, country) = 0
        then 0
        else net_inflow*1.0/sum(net_inflow) over(partition by month, tariff, country)
        end as net_inflow_share
from
    act_share_source_month;





drop table if exists plan_split;
create temp table plan_split as
with plan as
(
        select
            date,
            date_trunc('month',date)::date as month,
            tariff,
            country,
            business,
            sum(value) filter(where metric = 'deliveries') as deliveries_plan,
            sum(value) filter(where metric = 'gmv') as gmv_plan,
            sum(value) filter(where metric = 'commissions') as commissions_plan,
            sum(value) filter(where metric = 'subsidies') as subsidies_plan,
            sum(value) filter(where metric = 'decoupling') as decoupling_plan,
            sum(value) filter(where metric = 'net_inflow') as net_inflow_plan
        from snb_delivery.plans_bud_202207
        where date_trunc('month', date) <= date_trunc('month', current_date)
        group by 1,2,3,4,5
        having sum(case when metric = 'deliveries' then value else 0 end) <> 0
)
select
    coalesce(plan.date, d.date) as date,
    coalesce(plan.tariff, d.tariff) as tariff,
    coalesce(plan.country, d.country) as country,
    d.city_group,
    d.city,
    coalesce(plan.business, d.business) as business,

    plan.deliveries_plan as plan_deliveries,
    d.deliveries as fact_deliveries,
    d.deliveries_share as day_deliveries_share,
    0 as month_deliveries_share,

--     if no daily city fact split for respective plan, then use respective monthly split
--     if no plan for this date (historical dates) then use fact
    coalesce(plan.deliveries_plan*d.deliveries_share,d.deliveries) as deliveries,
    coalesce(plan.gmv_plan*d.gmv_share,d.gmv) as gmv,
    coalesce(plan.gmv_plan*d.gmv_cards_share,d.gmv_cards) as gmv_cards,
    coalesce(plan.commissions_plan*d.commissions_share,d.commissions) as commissions,
    coalesce(plan.subsidies_plan*d.subsidies_share,d.subsidies) as subsidies,
    coalesce(plan.decoupling_plan*d.decoupling_share,d.decoupling) as decoupling,
    coalesce(plan.net_inflow_plan*d.net_inflow_share,d.net_inflow) as net_inflow
from
    plan
    full join act_share_day as d
        on plan.date = d.date
        and plan.tariff = d.tariff
        and plan.country = d.country
        and plan.business = d.business
;


-- HOW DO DEAL WITH SPLITS MISSED IN PLAN

drop table if exists missed_split;
create temp table missed_split as
select date, tariff, country, business
from plan_split
where city_group is null
group by 1,2,3,4;


delete from plan_split p
using missed_split m
where p.date = m.date and p.tariff = m.tariff and p.country = m.country and p.business = m.business;


with plan as
(
        select
            date,
            date_trunc('month',date)::date as month,
            tariff,
            country,
            business,
            sum(value) filter(where metric = 'deliveries') as deliveries_plan,
            sum(value) filter(where metric = 'gmv') as gmv_plan,
            sum(value) filter(where metric = 'commissions') as commissions_plan,
            sum(value) filter(where metric = 'subsidies') as subsidies_plan,
            sum(value) filter(where metric = 'decoupling') as decoupling_plan,
            sum(value) filter(where metric = 'net_inflow') as net_inflow_plan
        from snb_delivery.plans_bud_202207
        where date_trunc('month', date) <= date_trunc('month', current_date)
        group by 1,2,3,4,5
        having sum(case when metric = 'deliveries' then value else 0 end) <> 0
)
insert into plan_split
select
    plan.date as date,
    coalesce(plan.tariff, m.tariff) as tariff,
    coalesce(plan.country, m.country) as country,
    m.city_group,
    m.city,
    plan.business,

    plan.deliveries_plan as plan_deliveries,
    m.deliveries as fact_deliveries,
    0 as day_deliveries_share,
    m.deliveries_share as month_deliveries_share,

--     if no daily city fact split for respective plan, then use respective monthly split
--     if no plan for this date (historical dates) then use fact
    plan.deliveries_plan*m.deliveries_share as deliveries,
    plan.gmv_plan*m.gmv_share as gmv,
    plan.gmv_plan*m.gmv_cards_share as gmv_cards,
    plan.commissions_plan*m.commissions_share as commissions,
    plan.subsidies_plan*m.subsidies_share as subsidies,
    plan.decoupling_plan*m.decoupling_share as decoupling,
    plan.net_inflow_plan*m.net_inflow_share as net_inflow
from
    plan
    inner join missed_split
        using (date, tariff, country, business)
    inner join act_share_month as m
        on plan.month = m.month
        and plan.tariff = m.tariff
        and plan.country = m.country;



-- select date_trunc('month',date)::date as date, sum(deliveries) as deliveries
-- from plan_split
-- group by 1
-- order by 1;





drop table if exists snb_delivery.dash_finance_estimate;
create table snb_delivery.dash_finance_estimate as
select
    date_trunc('month',coalesce(a.date, b.date, p.date))::date as date,
    coalesce(a.tariff, b.tariff, p.tariff) as tariff,
    coalesce(a.country, b.country, p.country) as country,
    coalesce(a.city_group, b.city_group, p.city_group) as city_group,
    coalesce(a.city, b.city, p.city) as city,
    coalesce(a.business, b.business, p.business) as business,

    sum(coalesce(p.deliveries,0))::float as deliveries_plan,
    sum(coalesce(p.gmv,0))::float as gmv_plan,
    sum(coalesce(p.gmv_cards,0))::float as gmv_cards_plan,
    sum(coalesce(p.commissions,0))::float as commissions_plan,
    sum(coalesce(p.subsidies,0))::float as subsidies_plan,
    sum(coalesce(p.decoupling,0))::float as decoupling_plan,

    sum(coalesce(a.deliveries,b."deliveries_ML",0))::float as deliveries_ML,
    sum(coalesce(a.deliveries,b.deliveries_trend,0))::float as deliveries_trend,
    sum(coalesce(a.deliveries,b.deliveries_halftrend,0))::float as deliveries_halftrend,
    sum(coalesce(a.deliveries,b.deliveries_avg,0))::float as deliveries_avg,

    sum(coalesce(a.gmv,b."gmv_ML",0))::float as gmv_ML,
    sum(coalesce(a.gmv,b.gmv_trend,0))::float as gmv_trend,
    sum(coalesce(a.gmv,b.gmv_halftrend,0))::float as gmv_halftrend,
    sum(coalesce(a.gmv,b.gmv_avg,0))::float as gmv_avg,

    sum(coalesce(a.gmv_cards,b."gmv_cards_ML",0))::float as gmv_cards_ML,
    sum(coalesce(a.gmv_cards,b.gmv_cards_trend,0))::float as gmv_cards_trend,
    sum(coalesce(a.gmv_cards,b.gmv_cards_halftrend,0))::float as gmv_cards_halftrend,
    sum(coalesce(a.gmv_cards,b.gmv_cards_avg,0))::float as gmv_cards_avg,

    sum(coalesce(a.commissions,b."commissions_ML",0))::float as commissions_ML,
    sum(coalesce(a.commissions,b.commissions_trend,0))::float as commissions_trend,
    sum(coalesce(a.commissions,b.commissions_halftrend,0))::float as commissions_halftrend,
    sum(coalesce(a.commissions,b.commissions_avg,0))::float as commissions_avg,

    sum(coalesce(a.subsidies,b."subsidies_ML",0))::float as subsidies_ML,
    sum(coalesce(a.subsidies,b.subsidies_trend,0))::float as subsidies_trend,
    sum(coalesce(a.subsidies,b.subsidies_halftrend,0))::float as subsidies_halftrend,
    sum(coalesce(a.subsidies,b.subsidies_avg,0))::float as subsidies_avg,

    sum(coalesce(a.decoupling,b."decoupling_ML",0))::float as decoupling_ML,
    sum(coalesce(a.decoupling,b.decoupling_trend,0))::float as decoupling_trend,
    sum(coalesce(a.decoupling,b.decoupling_halftrend,0))::float as decoupling_halftrend,
    sum(coalesce(a.decoupling,b.decoupling_avg,0))::float as decoupling_avg

from
    snb_delivery.dash_finance_estimate_source a
    full join snb_delivery.data_ml_estimate b
        using(date, tariff, country, city_group, city, business)
    full join plan_split p
        using(date, tariff, country, city_group, city, business)
where
    date_trunc('month', coalesce(a.date,b.date,p.date)) <= date_trunc('month', current_date)
group by
    1,2,3,4,5,6
;
