use hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$assumptions = '//home/taxi-delivery/analytics/production/finance/ebitda/ebitda_assumptions';
$estimate = '//home/taxi-delivery/analytics/production/bizdev/dash_finance_estimate';
$waterfall = '//home/taxi-delivery/analytics/production/finance/ebitda/ebitda_waterfall';


$fx_curr = (
SELECT avg(rate) as rate
from `//home/taxi-dwh/dds/dim_currency_rate`
where 
    target_cur == "RUB"
    and source_cur ='USD'
    and `date` between cast(CurrentUtcDate() - Interval('P14D') as string) and cast(CurrentUtcDate() - Interval('P1D') as string)
);

$fx_last = (
SELECT avg(rate) as rate
from `//home/taxi-dwh/dds/dim_currency_rate`
where 
    target_cur == "RUB"
    and source_cur ='USD'
    and substring(`date`,0,7) = substring(cast(CurrentUtcDate() - Interval('P30D') as string),0,7)
);


    

$order = ($item) -> {
return
    if($item = 'Net inflow',1,
    if($item = 'Third Party Logistics',2,
    if($item = 'Acquiring',3,
    if($item = 'Insurance',4,
    if($item = 'SMS & IVR',5,
    if($item = 'Support',6,
    if($item = 'Manual Operations Support',7,
    if($item = 'Marketing',8,
    if($item = 'Brand Royalty',9,
    if($item = 'Courier Expenses',10,
    if($item = 'Operations',11,
    if($item = 'Adj.HR expenses (w/o SDC)',12,
    if($item = 'Rent & Utilities, General expenses & Other',13)))))))))))))
};

$date_base = (select substring(max(date),0,7) as dt from $estimate);
$header = (select DateTime::Format("%B %Y")(DateTime::ParseIso8601(max(date))) from $estimate);


$totals = (
select
    date,
    stream_name,
    sum(deliveries_trend) as deliveries,
    sum(gmv_trend) as gross_bookings,
    sum(commissions_ml) as commissions,
    sum(subsidies_ml) as incentives,
    sum(decoupling_ml) as decoupling,
    sum(commissions_ml-subsidies_ml+decoupling_ml) as net_inflow
from
    $estimate
where
    SUBSTRING(date,0,7) = $date_base
    and country <> 'TOTAL'
group by
    SUBSTRING(date,0,7) as date,
    case when country not in ('Азербайджан','Армения','Белоруссия',
    'Грузия','Казахстан','Киргизия','Латвия','Молдавия',
    'Россия','Узбекистан','Финляндия','Эстония')
    THEN 'International'
    when tariff in ('K2','NDD')
    THEN 'NDD'
    ELSE 'Express'
    END as stream_name
);




-- LAST NON CLOSED MONTH BLOCK BEGIN

$last_month = (substring(Cast(DateTime::MakeDate(DateTime::StartOfMonth(DateTime::ShiftMonths(CurrentUtcDate(), -1))) as string),0,7));

$totals_last_month = (
select
    date,
    stream_name,
    sum(deliveries_trend) as deliveries,
    sum(gmv_trend) as gross_bookings,
    sum(commissions_trend) as commissions,
    sum(subsidies_trend) as incentives,
    sum(decoupling_trend) as decoupling,
    sum(commissions_trend-subsidies_trend+decoupling_trend) as net_inflow
from
    $estimate
where
    SUBSTRING(date,0,7) = $last_month
    and country <> 'TOTAL'
group by
    SUBSTRING(date,0,7) as date,
    case when country not in ('Азербайджан','Армения','Белоруссия',
    'Грузия','Казахстан','Киргизия','Латвия','Молдавия',
    'Россия','Узбекистан','Финляндия','Эстония')
    THEN 'International'
    when tariff in ('K2','NDD')
    THEN 'NDD'
    ELSE 'Express'
    END as stream_name)
    ;


$last_month_condition = (
select coalesce(1,0)
from $assumptions
where budget_or_RR = 'Act' and substring(date,0,7) = $last_month);

-- LAST NON CLOSED MONTH BLOCK END



$source = (

    -- current month run rate for net inflow
    select
        $date_base as month,
        1 as is_current_month,
        0 as is_year_to_date,
        'RR' as budget_or_RR,
        stream_name,
        'Net inflow' as item,
        net_inflow as value,
        $fx_curr as usd_rate
    from
        $totals
    where
        stream_name in ('Express','International')

    union all

    -- current month run rate for expenses
    select
        SUBSTRING(a.date,0,7) as month,
        1 as is_current_month,
        0 as is_year_to_date,
        a.budget_or_RR as budget_or_RR,
        a.stream_name as stream_name,
        a.item as item,
        a.value*if(logic='Deliveries', t.deliveries,if(logic='Hard',1,if(logic='NI',t.net_inflow)))*if(a.item = 'Net inflow',1,-1) as value,
        $fx_curr as usd_rate
    from
        $assumptions as a
        left join $totals as t
            on a.stream_name = t.stream_name
    where
        SUBSTRING(a.date,0,7) = $date_base
        and budget_or_RR in ('RR')

    union all

    -- previous months fact
    select
        SUBSTRING(date,0,7) as month,
        0 as is_current_month,
        1 as is_year_to_date,
        'RR' as budget_or_RR, -- для следующего запроса
        a.stream_name as stream_name,
        a.item as item,
        a.value*if(a.item = 'Net inflow',1,-1) as value,
        a.Exchange_rate as usd_rate
    from
        $assumptions as a
    where
        SUBSTRING(date,0,7) < $date_base
        and budget_or_RR in ('Act')

    union all

    -- budget for all months
    select
        month,
        is_current_month,
        is_year_to_date,
        budget_or_RR,
        stream_name,
        item,
        sum(case when item = 'Net inflow' then value else -value end) as value,
        usd_rate
    from
        $assumptions as a
    where
        budget_or_RR in ('Budget')
    group by
        SUBSTRING(date,0,7) as month,
        if(SUBSTRING(date,0,7) = $date_base,1,0) as is_current_month,
        if(SUBSTRING(date,0,7) < $date_base,1,0) as is_year_to_date,
        budget_or_RR,
        stream_name,
        item,
        Exchange_rate as usd_rate

    union all

    -- LAST NON CLOSED MONTH BLOCK BEGIN
    -- act for net inflow
    select
        $last_month as month,
        0 as is_current_month,
        1 as is_year_to_date,
        'RR' as budget_or_RR,  -- rename RR->Act because we are showing the 'closed' month
        stream_name,
        'Net inflow' as item,
        net_inflow as value,
        $fx_last as usd_rate
    from
        $totals_last_month
    where
        $last_month_condition is null -- if no Act value in Assumptions for last month
    
    union all

    -- act for expenses
    select
        SUBSTRING(a.date,0,7) as month,
        0 as is_current_month,
        1 as is_year_to_date,
        budget_or_RR,
        a.stream_name as stream_name,
        a.item as item,
        a.value*if(logic='Deliveries', t.deliveries,if(logic='Hard',1,if(logic='NI',t.net_inflow)))*if(a.item = 'Net inflow',1,-1) as value,
        $fx_last as usd_rate
    from
        $assumptions as a
        left join $totals_last_month as t
            on a.stream_name = t.stream_name
            and SUBSTRING(a.date,0,7) = t.date
    where
        SUBSTRING(a.date,0,7) = $last_month
        and budget_or_RR in ('RR')
        and $last_month_condition is null -- if no Act value in Assumptions for last month

    -- LAST NON CLOSED MONTH BLOCK END

);




$budget_rr = (
select
    a.*,
    $order(item) as step
from
    $source as a

)
;


$difference = (
select
    month,
    is_current_month,
    is_year_to_date,
    'Difference' as budget_or_RR,
    stream_name,
    item,
    step,
    sum(case when budget_or_RR = 'RR' then value else -value end) as value,
    usd_rate
from
    $budget_rr
group by
    month,
    is_current_month,
    is_year_to_date,
    stream_name,
    item,
    $order(item) as step,
    usd_rate
)
;   

insert into $waterfall with truncate
select $header as header, a.*, a.value/a.usd_rate as value_usd from $budget_rr as a
union all
select $header as header, b.*, b.value/b.usd_rate as value_usd from $difference as b
order by budget_or_RR, stream_name, step;
