import numpy as np
import pandas as pd
from business_models.startrek import StartrekWrapper
from business_models import greenplum, hahn
from datetime import date
from dateutil.relativedelta import relativedelta
import os

# собираем данные с 25 числа предыдущего месяца по 24 число текущего

end_date = date(date.today().year, date.today().month,24)
start_date = end_date + relativedelta(months=-1) + relativedelta(days=1)
start_date_minus_1 = end_date + relativedelta(months=-1)
start_month = end_date + relativedelta(months=-1) + relativedelta(days=-23)

print('start_date:', str(start_date))
print('end_date:',str(end_date))
print('start_date_minus_1:', str(start_date_minus_1))
print('start_month:', str(start_month))


QUERY = """

select
    a.order_nr,
    a.order_id,
    a.success_order_flg,
    a.status,
    a.cancel_reason_code,
    a.cancel_reason_name,
    a.moscow_order_dt as dt,
    a.corp_contract_id,
    case
        when c.tariff_zone is not null then 'moscow_region'
        when f.tariff_zone is not null then 'leningr_region'
        when city in ('Москва', 'Санкт-Петербург', 'Екатеринбург', 'Казань', 'Ростов-на-Дону',
                      'Астрахань', 'Таганрог', 'Нижний Новгород',
                        'Сургут', 'Ставрополь', 'Тверь', 'Чебоксары') then city
        else 'other cities'
        end as city,
    a.order_tariff,
    case
        when (a.decoupling_user_cost * a.currency_rate - a.decoupling_driver_cost * a.currency_rate) > 0
        then true
        else false
        end as is_decoupling_positive,
    a.taxi_dispatch_reason_code,
    order_cost * currency_rate                          as order_cost,
    order_before_surge_cost * currency_rate             as order_cost_before_surge,
    -subsidy_value * currency_rate                      as subsidy_value,
    subsidy_commission_value * currency_rate            as subsidy_commission,
    -subsidy_commission_discount_value * currency_rate  as subsidy_commission_discount,
    decoupling_user_cost * currency_rate -
    decoupling_driver_cost * currency_rate              as decoupling_value,
    net_inflow_amt * currency_rate                      as net_inflow,
    coalesce(b.subsidy_mfg_geo,0) as subsidy_mfg_geo,
    coalesce(b.subsidy_mfg,0) as subsidy_mfg,
    coalesce(b.subsidy_nmfg,0) as subsidy_nmfg,
    coalesce(b.subsidy_do_x_get_y,0) as subsidy_do_x_get_y,
    coalesce(b.subsidy_misc,0) as subsidy_misc,
    coalesce(b.other_subsidies,0) as other_subsidies
  from
  (
  select
        taxi_dispatch_cargo_uuid_id,
        taxi_dispatch_reason_code,
        order_nr,
        msk_created_dttm,
        b.*,
        ocr.code as cancel_reason_code,
        ocr.name as cancel_reason_name
    from
        eda_cdm_marketplace.dm_order as a
        join
            (
                select
                    d.order_id,
                    d.success_order_flg,
                    d.user_status as status,
                    d.tariff_geo_zone_code as tariff_zone,
                    d.utc_order_created_dt as utc_order_dt,
                    d.msk_order_created_dt as moscow_order_dt,
                    d.msk_order_created_dttm as moscow_order_dttm,
                    d.corp_contract_id,
                    d.agglomeration_name_ru as city,
                    d.tariff_class_code as order_tariff,
                    m.order_cost,
                    m.order_before_surge_cost,
                    m.subsidy_value,
                    m.subsidy_commission_value,
                    m.subsidy_commission_discount_value,
                    m.decoupling_user_cost,
                    m.decoupling_driver_cost,
                    m.net_inflow_amt,
                    m.currency_rate,
--                     t.claim_uuid,
                    t.cargo_ref_id
                from
                    taxi_cdm_marketplace.fct_order as d
                    inner join taxi_cdm_marketplace.fct_order_metric m
                        on m.order_id = d.order_id
                    join
                    (
                        select taxi_order_id, min(cargo_ref_id) as cargo_ref_id
                        from delivery_ods_cargo_claims.claim
                        group by 1
                    ) as t
                        on d.order_id = t.taxi_order_id
                where
                    d.corp_contract_id in ('544807/20','1664414/21',
                    '1202379/20','2125007/21','2125004/21','1918234/21')
            ) as b
            on a.taxi_dispatch_cargo_uuid_id = b.cargo_ref_id
        LEFT JOIN eda_ods_bigfood.order_cancel as oc
            ON oc.order_id = a.order_id
        LEFT JOIN eda_ods_bigfood.order_cancel_reason as ocr
            ON ocr.id = oc.reason_id
    where
        msk_created_dttm >= '{START_MONTH}'
        and taxi_dispatch_reason_code is not null
  ) as a
  left join
       (
         select
            order_id,
            sum(case when detailed_product_name = 'subsidy_mfg_geo' then subsidy_value else 0 end) as subsidy_mfg_geo,
            sum(case when detailed_product_name = 'subsidy_mfg' then subsidy_value else 0 end) as subsidy_mfg,
            sum(case when detailed_product_name = 'subsidy_nmfg' then subsidy_value else 0 end) as subsidy_nmfg,
            sum(case when detailed_product_name = 'subsidy_do_x_get_y' then subsidy_value else 0 end) as subsidy_do_x_get_y,
            sum(case when detailed_product_name = 'subsidy_misc' then subsidy_value else 0 end) as subsidy_misc,
            sum(case when detailed_product_name not in ('subsidy_misc','subsidy_do_x_get_y','subsidy_nmfg',
                        'subsidy_mfg','subsidy_mfg_geo') then subsidy_value else 0 end) as other_subsidies
        from taxi_cdm_finance.fct_order_subsidy
        where utc_transaction_dttm >= '{START_MONTH}'
        group by 1
    ) as b
        on a.order_id = b.order_id

    left join (
        select distinct tariff_zone
        from core_cdm_geo.v_dim_op_geo_hierarchy
        where node_id in ('op_moscow_region')
    ) as c
        on a.tariff_zone = c.tariff_zone

    left join (
        select distinct tariff_zone
        from core_cdm_geo.v_dim_op_geo_hierarchy
        where node_id in ('br_leningradskaja_obl') and tariff_zone != 'spb'
    ) as f
        on a.tariff_zone = f.tariff_zone

where -- status = 'cancelled' and
    corp_contract_id in ('544807/20','1664414/21',
                    '1202379/20','2125007/21','2125004/21','1918234/21')
    and utc_order_dt >= '{START_DATE_MINUS_1}'
    and a.moscow_order_dt between '{START_DATE}' and '{END_DATE}'
    and a.success_order_flg
    and (a.decoupling_user_cost * a.currency_rate - a.decoupling_driver_cost * a.currency_rate) <= 0

""".format(
    START_DATE = str(start_date),
    END_DATE = str(end_date),
    START_MONTH = str(start_month),
    START_DATE_MINUS_1 = str(start_date_minus_1)
)


TICKET = 'LOGDATA-892'
TEXT = 'Данные с {} по {}'.format(str(start_date), str(end_date))
EXCEL_FILE = 'eda_fallback_{}_{:2d}.xlsx'.format(end_date.year, end_date.month)


df = greenplum(QUERY)
df.to_excel(EXCEL_FILE, index=False)
st = StartrekWrapper()
st.comment(TICKET,TEXT,summonees='dima-ryzhkov', attachments=EXCEL_FILE)


os.remove(EXCEL_FILE)
del(df)
