-- RU REGIONS WITH SPECIAL OPTIONS FOR MOSCOW & SPB
drop table if exists ru_geo;
create temp table ru_geo as
select geo.tariff_zone,
       geo.tz_aggl_name_en,
       coalesce(
               coalesce(mow.name_en, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region end),
               geo.name_en) as region
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
         left join (select distinct tariff_zone, name_en
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('Moscow (Middle Region)',
                                      'Moscow (Near Region)',
                                      'Moscow (adm)',
                                      'Far Moscow Region')) as mow
                   on geo.tariff_zone = mow.tariff_zone
         left join (select min(name_en) as region,
                           tariff_zone
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('SPb and SPb region', 'Saint-Petersburg (adm)')
                    group by tariff_zone) as spb
                   on geo.tariff_zone = spb.tariff_zone
where geo.tag_list = '{federal district}'
;

-- FULL HIERARCHY WITH RUSSIAN REGIONS
drop table if exists regions_geo;
create temp table regions_geo as
select
    h.tariff_zone,
    h.geobase_id,
    h.name_ru,
    h.name_en as tz_aggl_name_en,
    h.tz_country_name_en,
    coalesce(region, h.tz_country_name_en) as region_name_en,
    total_population,
    population_group
from
     core_cdm_geo.v_dim_full_geo_hierarchy h
     left join ru_geo r
               on r.tariff_zone = h.tariff_zone
where
    h.node_type = 'agglomeration'
    and h.root_node_id = 'br_root';




drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

with a as (
         select msk_claim_created_dttm::date as date,
                c.country,
                c.region_name_en as region,
                c.city_en as city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from
            snb_delivery.dash_k2 a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         where pickup_or_lavka = 'lavka'
         group by 1, 2, 3, 4

         union all

         select msk_claim_created_dttm::date as date,
                c.country,
                c.region_name_en as region,
                c.city_en as city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         group by 1, 2, 3, 4
     )
select
    date,
    'NDD'::text as tariff,
    country,
    region,
    city,
    'INTERCO'::text as tier,
    sum(deliveries) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow
from a
where date < current_date
group by 1,2,3,4,5

;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as date,
    'NDD' as tariff,
    country,
    region,
    city,
   case
       when manager_metagroup = 'INTERCO' then 'INTERCO'
       when manager_metagroup = 'Тир 1' then 'Tier 1'
       when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
       when manager_metagroup = 'Тир 3' then 'Tier 3'
       when manager_metagroup is null then 'B2B Platform'
       else 'Tier 4'
       end as tier,
    count (distinct request_id) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow

from
    (
        select distinct
            request_id,
            a.corp_client_id,
            mangr.manager_metagroup,
            coalesce(c.country,'Russia') as country,
            coalesce(c.region_name_en,'Moscow') as region,
            coalesce(geo.tz_aggl_name_ru,'Moscow') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join (select geobase_id, max(tz_aggl_name_ru) as tz_aggl_name_ru from core_cdm_geo.v_dim_fi_geo_hierarchy group by 1) geo
                on a.delivery_region = geo.geobase_id
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on geo.tz_aggl_name_ru = c.city_ru
            left join
                (
                    select corp_client_id, max(manager_metagroup) as manager_metagroup
                    from snb_delivery.niksm_contract_manager
                    group by 1
                ) as mangr
                on mangr.corp_client_id = a.corp_client_id
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
where first_day < current_date
group by
    1,2,3,4,5,6;



drop table if exists final;
create temp table final as
    select date,
           case
               when tariff = 'K2' then 'NDD' else tariff
               end::text as tariff,
           coalesce(b.tz_country_name_en,'Russia') as country,
           coalesce(b.region_name_en,'Moscow') as region,
           coalesce(c.city_en,'Moscow') as city,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(deliveries)                       as deliveries,
           sum(gmv)                              as gmv,
           sum(net_inflow)                       as net_inflow
    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
        left join (select distinct on (name_ru) name_ru as city, tz_aggl_name_en as city_en from regions_geo) c
            on a.city = c.city
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
--         same_or_next_day_fake in ('Same')
    group by
        1, 2, 3, 4, 5, 6

    union all

    select date,
           'NDD' as tariff,
           coalesce(b.tz_country_name_en,'Russia') as country,
           coalesce(b.region_name_en,'Moscow') as region,
           coalesce(c.city_en,'Москва') as city,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(0)                       as deliveries,
           sum(gmv)                              as gmv,
           sum(net_inflow)                       as net_inflow

    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
        left join (select distinct on (name_ru) name_ru as city, tz_aggl_name_en as city_en from regions_geo) c
            on a.city = c.city
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        date,
        tariff,
        country,
        region,
        city,
        tier,
        deliveries,
        gmv,
        net_inflow
    from ndd_market_lavka

    union all

    select
        date,
        tariff,
        country,
        region,
        city,
        tier,
        deliveries,
        gmv,
        net_inflow
    from ndd_deliveries
;


drop table if exists snb_delivery.dash_bizdev_growth_by_region;
create table snb_delivery.dash_bizdev_growth_by_region as
    select date,
           case
               when tariff = 'NDD' then 'NDD'
               else case when country = 'Russia' then 'Russia' else 'International' end end as country,
           case when tariff = 'NDD' then tariff else region end                             as region,
           city,
           tier,
           sum(deliveries)::float as deliveries,
           sum(gmv)::float as gmv,
           sum(net_inflow)::float as net_inflow
    from final
    where date < current_date
    group by 1, 2, 3, 4, 5;


alter table snb_delivery.dash_bizdev_growth_by_region
add column max_date date,
add column current_month boolean,

add column text_yesterday text,
add column is_yesterday_curr boolean,
add column is_yesterday_prev boolean,
add column is_yesterday_prev2 boolean,

add column text_weektodate text,
add column is_weektodate_curr boolean,
add column is_weektodate_prev boolean,
add column is_weektodate_prev2 boolean,

add column text_lastfullweek text,
add column is_lastfullweek_curr boolean,
add column is_lastfullweek_prev boolean,
add column is_lastfullweek_prev2 boolean,

add column text_monthtodate text,
add column is_monthtodate_curr boolean,
add column is_monthtodate_prev boolean,
add column is_monthtodate_prev2 boolean,

add column text_lastfullmonth text,
add column is_lastfullmonth_curr boolean,
add column is_lastfullmonth_prev boolean,
add column is_lastfullmonth_prev2 boolean,

add column text_last7days text,
add column is_last7days_curr boolean,
add column is_last7days_prev boolean,
add column is_last7days_prev2 boolean;


update snb_delivery.dash_bizdev_growth_by_region
set max_date = (select max(date) from snb_delivery.dash_bizdev_growth_by_region);

update snb_delivery.dash_bizdev_growth_by_region
set
    current_month = date_trunc('month',date) = date_trunc('month',max_date),
    is_yesterday_curr = date between max_date and max_date,
    is_yesterday_prev = date between max_date - 1 and max_date - 1,
    is_yesterday_prev2 = date between max_date - 7 and max_date - 7,
    is_weektodate_curr = date between date_trunc('week',max_date) and max_date,
    is_weektodate_prev = date between date_trunc('week',max_date - interval '1 week') and (max_date - interval '1 week'),
    is_weektodate_prev2 = date between date_trunc('week',max_date - interval '4 weeks') and (max_date - interval '4 weeks'),
    is_lastfullweek_curr = date between (date_trunc('week',max_date+1) - interval '1 week') and (date_trunc('week',max_date+1) - interval '1 day'),
    is_lastfullweek_prev = date between (date_trunc('week',max_date+1) - interval '2 weeks') and (date_trunc('week',max_date+1) - interval '1 week' - interval '1 day'),
    is_lastfullweek_prev2 = date between (date_trunc('week',max_date+1) - interval '5 weeks') and (date_trunc('week',max_date+1) - interval '4 weeks' - interval '1 day'),
    is_monthtodate_curr = date between date_trunc('month',max_date) and max_date,
    is_monthtodate_prev = date between (date_trunc('month',max_date) - interval '1 month') and (max_date - interval '1 month'),
    is_monthtodate_prev2 = date between (date_trunc('month',max_date) - interval '1 year') and (max_date - interval '1 year' - interval '1 day'),
    is_lastfullmonth_curr = date between (date_trunc('month',max_date+1) - interval '1 month') and (date_trunc('month',max_date+1) - interval '1 day'),
    is_lastfullmonth_prev = date between (date_trunc('month',max_date+1) - interval '2 months') and (date_trunc('month',max_date+1) - interval '1 month' - interval '1 day'),
    is_lastfullmonth_prev2 = date between (date_trunc('month',max_date+1) - interval '13 months') and (date_trunc('month',max_date+1) - interval '12 months' - interval '1 day'),
    is_last7days_curr = date between max_date - 6 and max_date,
    is_last7days_prev = date between max_date - 13 and max_date - 7,
    is_last7days_prev2 = date between max_date - 34 and max_date - 28;


grant select on snb_delivery.dash_bizdev_growth_by_region to public;

comment on table snb_delivery.dash_bizdev_growth_by_region is 'Данные для деша Growth по регионам и городам. LOGDATA-1055';



drop table if exists snb_delivery.dash_bizdev_growth_by_region_short;
create table snb_delivery.dash_bizdev_growth_by_region_short as
select
        coalesce(a.date, b.date)                          as date,
        coalesce(a.region, b.region)                      as region,
        coalesce(a.country, b.country)                    as country,
        unnest(array ['deliveries','gmv','net_inflow'])   as metric,
        unnest(array[a.deliveries::float, a.gmv::float, a.net_inflow::float]) as fact,
        unnest(array [b.deliveries, b.gmv, b.net_inflow]) as plan,
        unnest(array[
            case when coalesce(a.date, b.date, c.date) < current_date then a.deliveries else c."value_ML_deliveries" end,
            case when coalesce(a.date, b.date, c.date) < current_date then a.gmv else c."value_ML_gmv" end,
            case when coalesce(a.date, b.date, c.date) < current_date then a.net_inflow else c."value_ML_net_inflow" end
            ]) as forecast_ml
from
     (
        select date, region, country, sum(deliveries) as deliveries, sum(gmv) as gmv, sum(net_inflow) as net_inflow
        from snb_delivery.dash_bizdev_growth_by_region
        group by 1,2,3
        having sum(deliveries) > 0
    ) as a
          full join snb_delivery.plans_growth_by_region b
                    using (date, region, country)
          full join snb_delivery.data_growth_by_region_ml c
                    using (date, region, country)
;



alter table snb_delivery.dash_bizdev_growth_by_region_short
add column max_date date,
add column current_month boolean,

add column text_yesterday text,
add column is_yesterday_curr boolean,
add column is_yesterday_prev boolean,
add column is_yesterday_prev2 boolean,

add column text_weektodate text,
add column is_weektodate_curr boolean,
add column is_weektodate_prev boolean,
add column is_weektodate_prev2 boolean,

add column text_lastfullweek text,
add column is_lastfullweek_curr boolean,
add column is_lastfullweek_prev boolean,
add column is_lastfullweek_prev2 boolean,

add column text_monthtodate text,
add column is_monthtodate_curr boolean,
add column is_monthtodate_prev boolean,
add column is_monthtodate_prev2 boolean,

add column text_lastfullmonth text,
add column is_lastfullmonth_curr boolean,
add column is_lastfullmonth_prev boolean,
add column is_lastfullmonth_prev2 boolean,

add column text_last7days text,
add column is_last7days_curr boolean,
add column is_last7days_prev boolean,
add column is_last7days_prev2 boolean;


update snb_delivery.dash_bizdev_growth_by_region_short
set max_date = (select max(date) from snb_delivery.dash_bizdev_growth_by_region_short where fact is not null);

update snb_delivery.dash_bizdev_growth_by_region_short
set
    current_month = date_trunc('month',date) = date_trunc('month',max_date),
    is_yesterday_curr = date between max_date and max_date,
    is_yesterday_prev = date between max_date - 1 and max_date - 1,
    is_yesterday_prev2 = date between max_date - 7 and max_date - 7,
    is_weektodate_curr = date between date_trunc('week',max_date) and max_date,
    is_weektodate_prev = date between date_trunc('week',max_date - interval '1 week') and (max_date - interval '1 week'),
    is_weektodate_prev2 = date between date_trunc('week',max_date - interval '4 weeks') and (max_date - interval '4 weeks'),
    is_lastfullweek_curr = date between (date_trunc('week',max_date+1) - interval '1 week') and (date_trunc('week',max_date+1) - interval '1 day'),
    is_lastfullweek_prev = date between (date_trunc('week',max_date+1) - interval '2 weeks') and (date_trunc('week',max_date+1) - interval '1 week' - interval '1 day'),
    is_lastfullweek_prev2 = date between (date_trunc('week',max_date+1) - interval '5 weeks') and (date_trunc('week',max_date+1) - interval '4 weeks' - interval '1 day'),
    is_monthtodate_curr = date between date_trunc('month',max_date) and max_date,
    is_monthtodate_prev = date between (date_trunc('month',max_date) - interval '1 month') and (max_date - interval '1 month'),
    is_monthtodate_prev2 = date between (date_trunc('month',max_date) - interval '1 year') and (max_date - interval '1 year' - interval '1 day'),
    is_lastfullmonth_curr = date between (date_trunc('month',max_date+1) - interval '1 month') and (date_trunc('month',max_date+1) - interval '1 day'),
    is_lastfullmonth_prev = date between (date_trunc('month',max_date+1) - interval '2 months') and (date_trunc('month',max_date+1) - interval '1 month' - interval '1 day'),
    is_lastfullmonth_prev2 = date between (date_trunc('month',max_date+1) - interval '13 months') and (date_trunc('month',max_date+1) - interval '12 months' - interval '1 day'),
    is_last7days_curr = date between max_date - 6 and max_date,
    is_last7days_prev = date between max_date - 13 and max_date - 7,
    is_last7days_prev2 = date between max_date - 34 and max_date - 28,
    text_yesterday = 'Current: ' || max_date::date || ' to ' || max_date::date ||
                     '. Previous: ' || (max_date - 1)::date || ' to ' || (max_date - 1)::date ||
                     '. Before previous: ' || (max_date - 7)::date || ' to ' || (max_date - 7)::date || '.',
    text_weektodate = 'Current: ' || (date_trunc('week',max_date))::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (date_trunc('week',max_date - interval '1 week'))::date || ' to ' || (max_date - interval '1 week')::date ||
                     '. Before previous: ' || (date_trunc('week',max_date - interval '4 weeks'))::date || ' to ' || (max_date - interval '4 weeks')::date || '.',
    text_lastfullweek = 'Current: ' || (date_trunc('week',max_date+1) - interval '1 week')::date || ' to ' || (date_trunc('week',max_date+1) - interval '1 day')::date ||
                     '. Previous: ' || (date_trunc('week',max_date+1) - interval '2 weeks')::date || ' to ' || (date_trunc('week',max_date+1) - interval '1 week' - interval '1 day')::date ||
                     '. Before previous: ' || (date_trunc('week',max_date+1) - interval '5 weeks')::date || ' to ' || (date_trunc('week',max_date+1) - interval '4 weeks' - interval '1 day')::date || '.',
    text_monthtodate = 'Current: ' || (date_trunc('month',max_date))::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (date_trunc('month',max_date) - interval '1 month')::date || ' to ' || (max_date - interval '1 month')::date ||
                     '. Before previous: ' || (date_trunc('month',max_date) - interval '1 year')::date || ' to ' || (max_date - interval '1 year' - interval '1 day')::date || '.',
    text_lastfullmonth = 'Current: ' || (date_trunc('month',max_date+1) - interval '1 month')::date || ' to ' || (date_trunc('month',max_date+1) - interval '1 day')::date ||
                     '. Previous: ' || (date_trunc('month',max_date+1) - interval '2 months')::date || ' to ' || (date_trunc('month',max_date+1) - interval '1 month' - interval '1 day')::date ||
                     '. Before previous: ' || (date_trunc('month',max_date+1) - interval '13 months')::date || ' to ' || (date_trunc('month',max_date+1) - interval '12 months' - interval '1 day')::date || '.',
    text_last7days = 'Current: ' || (max_date - 6)::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (max_date - 13)::date || ' to ' || (max_date - 7)::date ||
                     '. Before previous: ' || (max_date - 34)::date || ' to ' || (max_date - 28)::date || '.';


grant select on snb_delivery.dash_bizdev_growth_by_region_short to public;

comment on table snb_delivery.dash_bizdev_growth_by_region_short is 'Данные для деша Growth по регионам. LOGDATA-1055';
